/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.kse.crypto.CryptoException;
import org.kse.crypto.digest.DigestType;
import org.kse.crypto.digest.DigestUtil;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.LnfUtil;
import org.kse.gui.PlatformUtil;
import org.kse.gui.error.DError;

public class DViewCertificateFingerprint
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/resources");
    private JPanel jpButtons;
    private JButton jbCopy;
    private JButton jbOK;
    private JPanel jpFingerprint;
    private JScrollPane jspPolicy;
    private JTextArea jtaFingerprint;
    private byte[] encodedCertificate;
    private DigestType fingerprintAlg;

    public DViewCertificateFingerprint(JFrame parent, byte[] encodedCertificate, DigestType fingerprintAlg) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.encodedCertificate = encodedCertificate;
        this.fingerprintAlg = fingerprintAlg;
        this.initComponents();
    }

    public DViewCertificateFingerprint(JDialog parent, byte[] encodedCertificate, DigestType fingerprintAlg) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.encodedCertificate = encodedCertificate;
        this.fingerprintAlg = fingerprintAlg;
        this.initComponents();
    }

    private void initComponents() {
        this.jbCopy = new JButton(res.getString("DViewCertificateFingerprint.jbCopy.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbCopy, res.getString("DViewCertificateFingerprint.jbCopy.mnemonic").charAt(0));
        this.jbCopy.setToolTipText(res.getString("DViewCertificateFingerprint.jbCopy.tooltip"));
        this.jbCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewCertificateFingerprint.this);
                    DViewCertificateFingerprint.this.copyPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewCertificateFingerprint.this);
                }
            }
        });
        this.jbOK = new JButton(res.getString("DViewCertificateFingerprint.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DViewCertificateFingerprint.this.okPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, null, this.jbCopy);
        this.jpFingerprint = new JPanel(new BorderLayout());
        this.jpFingerprint.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jtaFingerprint = new JTextArea();
        this.jtaFingerprint.setFont(new Font("Monospaced", 0, LnfUtil.getDefaultFontSize()));
        this.jtaFingerprint.setEditable(false);
        this.jtaFingerprint.setTabSize(4);
        this.jtaFingerprint.setLineWrap(true);
        this.jtaFingerprint.putClientProperty("JTextArea.infoBackground", Boolean.TRUE);
        this.jtaFingerprint.setToolTipText(MessageFormat.format(res.getString("DViewCertificateFingerprint.jtaFingerprint.tooltip"), this.fingerprintAlg.friendly()));
        this.jspPolicy = PlatformUtil.createScrollPane(this.jtaFingerprint, 22, 31);
        this.jspPolicy.setPreferredSize(new Dimension(280, 125));
        this.jpFingerprint.add((Component)this.jspPolicy, "Center");
        this.getContentPane().add((Component)this.jpFingerprint, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.setTitle(MessageFormat.format(res.getString("DViewCertificateFingerprint.Title"), this.fingerprintAlg.friendly()));
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DViewCertificateFingerprint.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DViewCertificateFingerprint.this.jbOK.requestFocus();
            }
        });
        this.populateFingerprint();
    }

    private void populateFingerprint() {
        if (this.encodedCertificate != null) {
            try {
                this.jtaFingerprint.setText(DigestUtil.getFriendlyMessageDigest(this.encodedCertificate, this.fingerprintAlg));
            }
            catch (CryptoException ex) {
                Container container = this.getParent();
                DError dError = null;
                dError = container instanceof JDialog ? new DError((JDialog)container, (Throwable)ex) : new DError((JFrame)container, (Throwable)ex);
                dError.setLocationRelativeTo(container);
                dError.setVisible(true);
                return;
            }
        } else {
            this.jtaFingerprint.setText("");
        }
        this.jtaFingerprint.setCaretPosition(0);
    }

    private void copyPressed() {
        String fingerprint = this.jtaFingerprint.getText();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection copy = new StringSelection(fingerprint);
        clipboard.setContents(copy, copy);
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

