/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.PublicKey;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.kse.crypto.CryptoException;
import org.kse.gui.CursorUtil;
import org.kse.gui.crypto.DKeyIdentifierChooser;
import org.kse.gui.error.DError;
import org.kse.utilities.io.HexUtil;

public class JKeyIdentifier
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/resources");
    private JTextField jtfKeyIdentifier;
    private JButton jbEditKeyIdentifier;
    private JButton jbClearKeyIdentifier;
    private String title;
    private PublicKey publicKey;
    private byte[] keyIdentifier;

    public JKeyIdentifier(String title, PublicKey publicKey) {
        this.title = title;
        this.publicKey = publicKey;
        this.initComponents();
    }

    private void initComponents() {
        this.jtfKeyIdentifier = new JTextField(40);
        this.jtfKeyIdentifier.setEditable(false);
        GridBagConstraints gbc_jtfKeyIdentifier = new GridBagConstraints();
        gbc_jtfKeyIdentifier.gridwidth = 1;
        gbc_jtfKeyIdentifier.gridheight = 1;
        gbc_jtfKeyIdentifier.gridx = 0;
        gbc_jtfKeyIdentifier.gridy = 0;
        gbc_jtfKeyIdentifier.insets = new Insets(0, 0, 0, 5);
        ImageIcon editIcon = new ImageIcon(this.getClass().getResource("images/edit_key_id.png"));
        this.jbEditKeyIdentifier = new JButton(editIcon);
        this.jbEditKeyIdentifier.setToolTipText(res.getString("JKeyIdentifier.jbEditKeyIdentifier.tooltip"));
        this.jbEditKeyIdentifier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JKeyIdentifier.this);
                    JKeyIdentifier.this.editKeyIdentifier();
                }
                finally {
                    CursorUtil.setCursorFree(JKeyIdentifier.this);
                }
            }
        });
        GridBagConstraints gbc_jbEditKeyIdentifier = new GridBagConstraints();
        gbc_jbEditKeyIdentifier.gridwidth = 1;
        gbc_jbEditKeyIdentifier.gridheight = 1;
        gbc_jbEditKeyIdentifier.gridx = 1;
        gbc_jbEditKeyIdentifier.gridy = 0;
        gbc_jbEditKeyIdentifier.insets = new Insets(0, 0, 0, 5);
        ImageIcon clearIcon = new ImageIcon(this.getClass().getResource("images/clear_key_id.png"));
        this.jbClearKeyIdentifier = new JButton(clearIcon);
        this.jbClearKeyIdentifier.setToolTipText(res.getString("JKeyIdentifier.jbClearKeyIdentifier.tooltip"));
        this.jbClearKeyIdentifier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JKeyIdentifier.this);
                    JKeyIdentifier.this.clearKeyIdentifier();
                }
                finally {
                    CursorUtil.setCursorFree(JKeyIdentifier.this);
                }
            }
        });
        GridBagConstraints gbc_jbClearKeyIdentifier = new GridBagConstraints();
        gbc_jbClearKeyIdentifier.gridwidth = 1;
        gbc_jbClearKeyIdentifier.gridheight = 1;
        gbc_jbClearKeyIdentifier.gridx = 2;
        gbc_jbClearKeyIdentifier.gridy = 0;
        gbc_jbClearKeyIdentifier.insets = new Insets(0, 0, 0, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jtfKeyIdentifier, gbc_jtfKeyIdentifier);
        this.add((Component)this.jbEditKeyIdentifier, gbc_jbEditKeyIdentifier);
        this.add((Component)this.jbClearKeyIdentifier, gbc_jbClearKeyIdentifier);
        this.populate();
    }

    public byte[] getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public void setKeyIdentifier(byte[] keyIdentifier) {
        this.keyIdentifier = keyIdentifier;
        this.populate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.jbEditKeyIdentifier.setEnabled(enabled);
        this.jbClearKeyIdentifier.setEnabled(enabled);
    }

    @Override
    public void setToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
        this.jtfKeyIdentifier.setToolTipText(toolTipText);
    }

    private void populate() {
        if (this.keyIdentifier != null) {
            this.jtfKeyIdentifier.setText(HexUtil.getHexString(this.keyIdentifier));
            this.jbClearKeyIdentifier.setEnabled(true);
        } else {
            this.jtfKeyIdentifier.setText("");
            this.jbClearKeyIdentifier.setEnabled(false);
        }
        this.jtfKeyIdentifier.setCaretPosition(0);
    }

    private void editKeyIdentifier() {
        Container container = this.getTopLevelAncestor();
        try {
            DKeyIdentifierChooser dKeyIdentifierChooser = null;
            dKeyIdentifierChooser = container instanceof JDialog ? new DKeyIdentifierChooser((JDialog)container, this.title, this.publicKey, this.keyIdentifier) : new DKeyIdentifierChooser((JFrame)container, this.title, this.publicKey, this.keyIdentifier);
            dKeyIdentifierChooser.setLocationRelativeTo(container);
            dKeyIdentifierChooser.setVisible(true);
            byte[] newKeyIdentifier = dKeyIdentifierChooser.getKeyIdentifier();
            if (newKeyIdentifier == null) {
                return;
            }
            this.setKeyIdentifier(newKeyIdentifier);
        }
        catch (CryptoException ex) {
            DError dError = null;
            dError = container instanceof JDialog ? new DError((JDialog)container, (Throwable)ex) : new DError((JFrame)container, (Throwable)ex);
            dError.setLocationRelativeTo(container);
            dError.setVisible(true);
        }
    }

    private void clearKeyIdentifier() {
        this.setKeyIdentifier(null);
    }
}

