/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.generalname;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.kse.gui.CursorUtil;
import org.kse.gui.JKseTable;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.generalname.DGeneralNameChooser;
import org.kse.gui.crypto.generalname.GeneralNamesTableCellRend;
import org.kse.gui.crypto.generalname.GeneralNamesTableHeadRend;
import org.kse.gui.crypto.generalname.GeneralNamesTableModel;
import org.kse.utilities.os.OperatingSystem;

public class JGeneralNames
extends JPanel {
    private static final long serialVersionUID = 459512931464920941L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/generalname/resources");
    private JPanel jpGeneralNameButtons;
    private JButton jbAdd;
    private JButton jbEdit;
    private JButton jbRemove;
    private JScrollPane jspGeneralNames;
    private JKseTable jtGeneralNames;
    private String title;
    private boolean enabled = true;

    public JGeneralNames(String title) {
        this.title = title;
        this.initComponents();
    }

    private void initComponents() {
        this.jbAdd = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/add_general_nms.png"))));
        this.jbAdd.setMargin(new Insets(2, 2, 0, 0));
        this.jbAdd.setToolTipText(res.getString("JGeneralNames.jbAdd.tooltip"));
        this.jbAdd.setMnemonic(res.getString("JGeneralNames.jbAdd.mnemonic").charAt(0));
        this.jbAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JGeneralNames.this);
                    JGeneralNames.this.addPressed();
                }
                finally {
                    CursorUtil.setCursorFree(JGeneralNames.this);
                }
            }
        });
        this.jbEdit = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/edit_general_nms.png"))));
        this.jbEdit.setMargin(new Insets(2, 2, 0, 0));
        this.jbEdit.setToolTipText(res.getString("JGeneralNames.jbEdit.tooltip"));
        this.jbEdit.setMnemonic(res.getString("JGeneralNames.jbEdit.mnemonic").charAt(0));
        this.jbEdit.setEnabled(false);
        this.jbEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JGeneralNames.this);
                    JGeneralNames.this.editPressed();
                }
                finally {
                    CursorUtil.setCursorFree(JGeneralNames.this);
                }
            }
        });
        this.jbRemove = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/remove_general_nms.png"))));
        this.jbRemove.setMargin(new Insets(2, 2, 0, 0));
        this.jbRemove.setToolTipText(res.getString("JGeneralNames.jbRemove.tooltip"));
        this.jbRemove.setMnemonic(res.getString("JGeneralNames.jbRemove.mnemonic").charAt(0));
        this.jbRemove.setEnabled(false);
        this.jbRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JGeneralNames.this);
                    JGeneralNames.this.removePressed();
                }
                finally {
                    CursorUtil.setCursorFree(JGeneralNames.this);
                }
            }
        });
        this.jpGeneralNameButtons = new JPanel();
        this.jpGeneralNameButtons.setLayout(new BoxLayout(this.jpGeneralNameButtons, 1));
        this.jpGeneralNameButtons.add(Box.createVerticalGlue());
        this.jpGeneralNameButtons.add(this.jbAdd);
        this.jpGeneralNameButtons.add(Box.createVerticalStrut(3));
        this.jpGeneralNameButtons.add(this.jbEdit);
        this.jpGeneralNameButtons.add(Box.createVerticalStrut(3));
        this.jpGeneralNameButtons.add(this.jbRemove);
        this.jpGeneralNameButtons.add(Box.createVerticalGlue());
        GeneralNamesTableModel generalNamesTableModel = new GeneralNamesTableModel();
        this.jtGeneralNames = new JKseTable(generalNamesTableModel);
        TableRowSorter<GeneralNamesTableModel> sorter = new TableRowSorter<GeneralNamesTableModel>(generalNamesTableModel);
        sorter.setComparator(0, new GeneralNamesTableModel.GeneralNameComparator());
        this.jtGeneralNames.setRowSorter(sorter);
        this.jtGeneralNames.setShowGrid(false);
        this.jtGeneralNames.setRowMargin(0);
        this.jtGeneralNames.getColumnModel().setColumnMargin(0);
        this.jtGeneralNames.getTableHeader().setReorderingAllowed(false);
        this.jtGeneralNames.setAutoResizeMode(4);
        this.jtGeneralNames.setRowHeight(Math.max(18, this.jtGeneralNames.getRowHeight()));
        for (int i = 0; i < this.jtGeneralNames.getColumnCount(); ++i) {
            TableColumn column = this.jtGeneralNames.getColumnModel().getColumn(i);
            column.setHeaderRenderer(new GeneralNamesTableHeadRend(this.jtGeneralNames.getTableHeader().getDefaultRenderer()));
            column.setCellRenderer(new GeneralNamesTableCellRend());
        }
        ListSelectionModel selectionModel = this.jtGeneralNames.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    JGeneralNames.this.updateButtonControls();
                }
            }
        });
        this.jtGeneralNames.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JGeneralNames.this.maybeEditGeneralName(evt);
            }
        });
        this.jtGeneralNames.addKeyListener(new KeyAdapter(){
            boolean deleteLastPressed = false;

            @Override
            public void keyPressed(KeyEvent evt) {
                if (!OperatingSystem.isMacOs()) {
                    this.deleteLastPressed = evt.getKeyCode() == 127;
                }
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                if (!OperatingSystem.isMacOs() && this.deleteLastPressed && evt.getKeyCode() == 127) {
                    try {
                        CursorUtil.setCursorBusy(JGeneralNames.this);
                        this.deleteLastPressed = false;
                        JGeneralNames.this.removeSelectedGeneralName();
                    }
                    finally {
                        CursorUtil.setCursorFree(JGeneralNames.this);
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                if (OperatingSystem.isMacOs() && evt.getKeyChar() == '\b') {
                    try {
                        CursorUtil.setCursorBusy(JGeneralNames.this);
                        JGeneralNames.this.removeSelectedGeneralName();
                    }
                    finally {
                        CursorUtil.setCursorFree(JGeneralNames.this);
                    }
                }
            }
        });
        this.jspGeneralNames = PlatformUtil.createScrollPane(this.jtGeneralNames, 20, 31);
        this.jspGeneralNames.getViewport().setBackground(this.jtGeneralNames.getBackground());
        this.setLayout(new BorderLayout(5, 5));
        this.setPreferredSize(new Dimension(250, 150));
        this.add((Component)this.jspGeneralNames, "Center");
        this.add((Component)this.jpGeneralNameButtons, "East");
        this.selectFirstGeneralNameInTable();
        this.updateButtonControls();
    }

    public GeneralNames getGeneralNames() {
        return new GeneralNames(this.getGeneralNamesTableModel().getData().toArray(new GeneralName[0]));
    }

    public void setGeneralNames(GeneralNames generalNames) {
        this.getGeneralNamesTableModel().load(generalNames);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.updateButtonControls();
    }

    @Override
    public void setToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
        this.jspGeneralNames.setToolTipText(toolTipText);
        this.jtGeneralNames.setToolTipText(toolTipText);
    }

    private void addPressed() {
        Container container = this.getTopLevelAncestor();
        DGeneralNameChooser dGeneralNameChooser = null;
        dGeneralNameChooser = container instanceof JDialog ? new DGeneralNameChooser((JDialog)container, this.title, null) : new DGeneralNameChooser((JFrame)container, this.title, null);
        dGeneralNameChooser.setLocationRelativeTo(container);
        dGeneralNameChooser.setVisible(true);
        GeneralName newGeneralName = dGeneralNameChooser.getGeneralName();
        if (newGeneralName == null) {
            return;
        }
        this.getGeneralNamesTableModel().addRow(newGeneralName);
        this.selectGeneralNameInTable(newGeneralName);
        this.updateButtonControls();
    }

    private void removePressed() {
        this.removeSelectedGeneralName();
    }

    private void removeSelectedGeneralName() {
        int selectedRow = this.jtGeneralNames.getSelectedRow();
        if (selectedRow != -1) {
            ((GeneralNamesTableModel)this.jtGeneralNames.getModel()).removeRow(selectedRow);
            this.selectFirstGeneralNameInTable();
            this.updateButtonControls();
        }
    }

    private void editPressed() {
        this.editSelectedGeneralName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeEditGeneralName(MouseEvent evt) {
        Point point;
        int row;
        if (evt.getClickCount() > 1 && (row = this.jtGeneralNames.rowAtPoint(point = new Point(evt.getX(), evt.getY()))) != -1) {
            try {
                CursorUtil.setCursorBusy(this);
                this.jtGeneralNames.setRowSelectionInterval(row, row);
                this.editSelectedGeneralName();
            }
            finally {
                CursorUtil.setCursorFree(this);
            }
        }
    }

    private void updateButtonControls() {
        if (!this.enabled) {
            this.jbAdd.setEnabled(false);
            this.jbEdit.setEnabled(false);
            this.jbRemove.setEnabled(false);
        } else {
            this.jbAdd.setEnabled(true);
            int selectedRow = this.jtGeneralNames.getSelectedRow();
            if (selectedRow == -1) {
                this.jbEdit.setEnabled(false);
                this.jbRemove.setEnabled(false);
            } else {
                this.jbEdit.setEnabled(true);
                this.jbRemove.setEnabled(true);
            }
        }
    }

    private void editSelectedGeneralName() {
        int selectedRow = this.jtGeneralNames.getSelectedRow();
        if (selectedRow != -1) {
            GeneralName generalName = (GeneralName)this.jtGeneralNames.getValueAt(selectedRow, 0);
            Container container = this.getTopLevelAncestor();
            Window dGeneralNameChooser = null;
            if (container instanceof JDialog) {
                dGeneralNameChooser = new DGeneralNameChooser((JDialog)container, this.title, generalName);
            } else if (container instanceof JFrame) {
                dGeneralNameChooser = new DGeneralNameChooser((JFrame)container, this.title, generalName);
            }
            dGeneralNameChooser.setLocationRelativeTo(container);
            ((Dialog)dGeneralNameChooser).setVisible(true);
            GeneralName newGeneralName = ((DGeneralNameChooser)dGeneralNameChooser).getGeneralName();
            if (newGeneralName == null) {
                return;
            }
            this.getGeneralNamesTableModel().removeRow(selectedRow);
            this.getGeneralNamesTableModel().addRow(newGeneralName);
            this.selectGeneralNameInTable(newGeneralName);
            this.updateButtonControls();
        }
    }

    private void selectGeneralNameInTable(GeneralName generalName) {
        for (int i = 0; i < this.jtGeneralNames.getRowCount(); ++i) {
            if (!generalName.equals(this.jtGeneralNames.getValueAt(i, 0))) continue;
            this.jtGeneralNames.changeSelection(i, 0, false, false);
            return;
        }
    }

    private void selectFirstGeneralNameInTable() {
        if (this.getGeneralNamesTableModel().getRowCount() > 0) {
            this.jtGeneralNames.changeSelection(0, 0, false, false);
        }
    }

    private GeneralNamesTableModel getGeneralNamesTableModel() {
        return (GeneralNamesTableModel)this.jtGeneralNames.getModel();
    }
}

