/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.policyinformation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.bouncycastle.asn1.x509.UserNotice;
import org.kse.crypto.x509.CertificatePolicyQualifierType;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.policyinformation.JUserNotice;
import org.kse.gui.error.DError;

public class DPolicyQualifierInfoChooser
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/policyinformation/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpPolicyQualifierInfo;
    private JLabel jlPolicyQualifierInfoType;
    private JRadioButton jrbCps;
    private JRadioButton jrbUserNotice;
    private JLabel jlPolicyQualifierInfoValue;
    private JPanel jpPolicyQualifierInfoValue;
    private JTextField jtfCps;
    private JUserNotice junUserNotice;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private PolicyQualifierInfo policyQualifierInfo;

    public DPolicyQualifierInfoChooser(JFrame parent, String title, PolicyQualifierInfo policyQualifierInfo) throws IOException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(policyQualifierInfo);
    }

    public DPolicyQualifierInfoChooser(JDialog parent, String title, PolicyQualifierInfo policyQualifierInfo) throws IOException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(policyQualifierInfo);
    }

    private void initComponents(PolicyQualifierInfo policyQualifierInfo) throws IOException {
        this.jlPolicyQualifierInfoType = new JLabel(res.getString("DPolicyQualifierInfoChooser.jlPolicyQualifierInfoType.text"));
        GridBagConstraints gbc_jlPolicyQualifierInfoType = new GridBagConstraints();
        gbc_jlPolicyQualifierInfoType.gridx = 0;
        gbc_jlPolicyQualifierInfoType.gridy = 0;
        gbc_jlPolicyQualifierInfoType.gridwidth = 1;
        gbc_jlPolicyQualifierInfoType.gridheight = 1;
        gbc_jlPolicyQualifierInfoType.anchor = 13;
        this.jrbCps = new JRadioButton(res.getString("DPolicyQualifierInfoChooser.jrbCps.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jrbCps, res.getString("DPolicyQualifierInfoChooser.jrbCps.mnemonic").charAt(0));
        this.jrbCps.setToolTipText(res.getString("DPolicyQualifierInfoChooser.jrbCps.tooltip"));
        this.jrbCps.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DPolicyQualifierInfoChooser.this.policyQualifierInfoTypeChanged();
            }
        });
        GridBagConstraints gbc_jrbCps = new GridBagConstraints();
        gbc_jrbCps.gridx = 1;
        gbc_jrbCps.gridy = 0;
        gbc_jrbCps.gridwidth = 1;
        gbc_jrbCps.gridheight = 1;
        gbc_jrbCps.anchor = 17;
        this.jrbUserNotice = new JRadioButton(res.getString("DPolicyQualifierInfoChooser.jrbUserNotice.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jrbUserNotice, res.getString("DPolicyQualifierInfoChooser.jrbUserNotice.mnemonic").charAt(0));
        this.jrbUserNotice.setToolTipText(res.getString("DPolicyQualifierInfoChooser.jrbUserNotice.tooltip"));
        this.jrbUserNotice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DPolicyQualifierInfoChooser.this.policyQualifierInfoTypeChanged();
            }
        });
        GridBagConstraints gbc_jrbUserNotice = new GridBagConstraints();
        gbc_jrbUserNotice.gridx = 2;
        gbc_jrbUserNotice.gridy = 0;
        gbc_jrbUserNotice.gridwidth = 1;
        gbc_jrbUserNotice.gridheight = 1;
        gbc_jrbUserNotice.anchor = 17;
        ButtonGroup bgPolicyQualifierInfoType = new ButtonGroup();
        bgPolicyQualifierInfoType.add(this.jrbCps);
        bgPolicyQualifierInfoType.add(this.jrbUserNotice);
        this.jlPolicyQualifierInfoValue = new JLabel(res.getString("DPolicyQualifierInfoChooser.jlPolicyQualifierInfoValue.text"));
        GridBagConstraints gbc_jlPolicyQualifierInfoValue = new GridBagConstraints();
        gbc_jlPolicyQualifierInfoValue.gridx = 0;
        gbc_jlPolicyQualifierInfoValue.gridy = 1;
        gbc_jlPolicyQualifierInfoValue.gridwidth = 1;
        gbc_jlPolicyQualifierInfoValue.gridheight = 1;
        gbc_jlPolicyQualifierInfoValue.anchor = 13;
        this.jtfCps = new JTextField(30);
        this.junUserNotice = new JUserNotice(res.getString("DPolicyQualifierInfoChooser.UserNotice.Title"));
        this.jpPolicyQualifierInfoValue = new JPanel(new FlowLayout(0));
        GridBagConstraints gbc_jpPolicyQualifierInfoValue = new GridBagConstraints();
        gbc_jpPolicyQualifierInfoValue.gridx = 1;
        gbc_jpPolicyQualifierInfoValue.gridy = 1;
        gbc_jpPolicyQualifierInfoValue.gridwidth = 2;
        gbc_jpPolicyQualifierInfoValue.gridheight = 1;
        gbc_jpPolicyQualifierInfoValue.insets = new Insets(0, 0, 0, 0);
        gbc_jpPolicyQualifierInfoValue.anchor = 17;
        this.jpPolicyQualifierInfoValue.add(this.jtfCps);
        this.jpPolicyQualifierInfo = new JPanel(new GridBagLayout());
        this.jpPolicyQualifierInfo.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpPolicyQualifierInfo.add((Component)this.jlPolicyQualifierInfoType, gbc_jlPolicyQualifierInfoType);
        this.jpPolicyQualifierInfo.add((Component)this.jrbCps, gbc_jrbCps);
        this.jpPolicyQualifierInfo.add((Component)this.jrbUserNotice, gbc_jrbUserNotice);
        this.jpPolicyQualifierInfo.add((Component)this.jlPolicyQualifierInfoValue, gbc_jlPolicyQualifierInfoValue);
        this.jpPolicyQualifierInfo.add((Component)this.jpPolicyQualifierInfoValue, gbc_jpPolicyQualifierInfoValue);
        this.jbOK = new JButton(res.getString("DPolicyQualifierInfoChooser.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPolicyQualifierInfoChooser.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DPolicyQualifierInfoChooser.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPolicyQualifierInfoChooser.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPolicyQualifierInfoChooser.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.jpPolicyQualifierInfo);
        this.getContentPane().add("South", this.jpButtons);
        this.populate(policyQualifierInfo);
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void policyQualifierInfoTypeChanged() {
        this.jpPolicyQualifierInfoValue.removeAll();
        if (this.jrbCps.isSelected()) {
            this.jpPolicyQualifierInfoValue.add(this.jtfCps);
        } else if (this.jrbUserNotice.isSelected()) {
            this.jpPolicyQualifierInfoValue.add(this.junUserNotice);
        }
        this.pack();
    }

    private void populate(PolicyQualifierInfo policyQualifierInfo) throws IOException {
        if (policyQualifierInfo == null) {
            this.jrbCps.setSelected(true);
        } else {
            ASN1ObjectIdentifier policyQualifierId = policyQualifierInfo.getPolicyQualifierId();
            if (policyQualifierId.equals((ASN1Primitive)new ASN1ObjectIdentifier(CertificatePolicyQualifierType.PKIX_CPS_POINTER_QUALIFIER.oid()))) {
                this.jrbCps.setSelected(true);
                this.jtfCps.setText(((DERIA5String)policyQualifierInfo.getQualifier()).getString());
                this.jtfCps.setCaretPosition(0);
            } else if (policyQualifierId.equals((ASN1Primitive)new ASN1ObjectIdentifier(CertificatePolicyQualifierType.PKIX_USER_NOTICE_QUALIFIER.oid()))) {
                this.jrbUserNotice.setSelected(true);
                ASN1Encodable userNoticeObj = policyQualifierInfo.getQualifier();
                UserNotice userNotice = UserNotice.getInstance((Object)userNoticeObj);
                this.junUserNotice.setUserNotice(userNotice);
            } else {
                this.jrbCps.setSelected(true);
            }
        }
    }

    public PolicyQualifierInfo getPolicyQualifierInfo() {
        return this.policyQualifierInfo;
    }

    private void okPressed() {
        PolicyQualifierInfo newPolicyQualifierInfo = null;
        try {
            if (this.jrbCps.isSelected()) {
                String cps = this.jtfCps.getText().trim();
                if (cps.length() == 0) {
                    JOptionPane.showMessageDialog(this, res.getString("DPolicyQualifierInfoChooser.CpsValueReq.message"), this.getTitle(), 2);
                    return;
                }
                newPolicyQualifierInfo = new PolicyQualifierInfo(new ASN1ObjectIdentifier(CertificatePolicyQualifierType.PKIX_CPS_POINTER_QUALIFIER.oid()), (ASN1Encodable)new DERIA5String(cps).toASN1Primitive());
            } else {
                UserNotice userNotice = this.junUserNotice.getUserNotice();
                if (userNotice == null) {
                    JOptionPane.showMessageDialog(this, res.getString("DPolicyQualifierInfoChooser.UserNoticeValueReq.message"), this.getTitle(), 2);
                    return;
                }
                newPolicyQualifierInfo = new PolicyQualifierInfo(new ASN1ObjectIdentifier(CertificatePolicyQualifierType.PKIX_USER_NOTICE_QUALIFIER.oid()), (ASN1Encodable)userNotice);
            }
        }
        catch (Exception e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.policyQualifierInfo = newPolicyQualifierInfo;
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

