/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.policyinformation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.kse.gui.CursorUtil;
import org.kse.gui.JKseTable;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.policyinformation.DPolicyQualifierInfoChooser;
import org.kse.gui.crypto.policyinformation.PolicyQualifierInfoTableCellRend;
import org.kse.gui.crypto.policyinformation.PolicyQualifierInfoTableHeadRend;
import org.kse.gui.crypto.policyinformation.PolicyQualifierInfoTableModel;
import org.kse.gui.error.DError;
import org.kse.utilities.os.OperatingSystem;

public class JPolicyQualifierInfo
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/policyinformation/resources");
    private JPanel jpPolicyQualifierInfoButtons;
    private JButton jbAdd;
    private JButton jbEdit;
    private JButton jbRemove;
    private JScrollPane jspPolicyQualifierInfo;
    private JKseTable jtPolicyQualifierInfo;
    private String title;
    private List<PolicyQualifierInfo> policyQualifierInfo;
    private boolean enabled = true;

    public JPolicyQualifierInfo(String title) {
        this.title = title;
        this.initComponents();
    }

    private void initComponents() {
        this.jbAdd = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/add_policy_qualifier_info.png"))));
        this.jbAdd.setMargin(new Insets(2, 2, 0, 0));
        this.jbAdd.setToolTipText(res.getString("JPolicyQualifierInfo.jbAdd.tooltip"));
        this.jbAdd.setMnemonic(res.getString("JPolicyQualifierInfo.jbAdd.mnemonic").charAt(0));
        this.jbAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JPolicyQualifierInfo.this);
                    JPolicyQualifierInfo.this.addPressed();
                }
                finally {
                    CursorUtil.setCursorFree(JPolicyQualifierInfo.this);
                }
            }
        });
        this.jbEdit = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/edit_policy_qualifier_info.png"))));
        this.jbEdit.setMargin(new Insets(2, 2, 0, 0));
        this.jbEdit.setToolTipText(res.getString("JPolicyQualifierInfo.jbEdit.tooltip"));
        this.jbEdit.setMnemonic(res.getString("JPolicyQualifierInfo.jbEdit.mnemonic").charAt(0));
        this.jbEdit.setEnabled(false);
        this.jbEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JPolicyQualifierInfo.this);
                    JPolicyQualifierInfo.this.editPressed();
                }
                finally {
                    CursorUtil.setCursorFree(JPolicyQualifierInfo.this);
                }
            }
        });
        this.jbRemove = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/remove_policy_qualifier_info.png"))));
        this.jbRemove.setMargin(new Insets(2, 2, 0, 0));
        this.jbRemove.setToolTipText(res.getString("JPolicyQualifierInfo.jbRemove.tooltip"));
        this.jbRemove.setMnemonic(res.getString("JPolicyQualifierInfo.jbRemove.mnemonic").charAt(0));
        this.jbRemove.setEnabled(false);
        this.jbRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JPolicyQualifierInfo.this);
                    JPolicyQualifierInfo.this.removePressed();
                }
                finally {
                    CursorUtil.setCursorFree(JPolicyQualifierInfo.this);
                }
            }
        });
        this.jpPolicyQualifierInfoButtons = new JPanel();
        this.jpPolicyQualifierInfoButtons.setLayout(new BoxLayout(this.jpPolicyQualifierInfoButtons, 1));
        this.jpPolicyQualifierInfoButtons.add(Box.createVerticalGlue());
        this.jpPolicyQualifierInfoButtons.add(this.jbAdd);
        this.jpPolicyQualifierInfoButtons.add(Box.createVerticalStrut(3));
        this.jpPolicyQualifierInfoButtons.add(this.jbEdit);
        this.jpPolicyQualifierInfoButtons.add(Box.createVerticalStrut(3));
        this.jpPolicyQualifierInfoButtons.add(this.jbRemove);
        this.jpPolicyQualifierInfoButtons.add(Box.createVerticalGlue());
        PolicyQualifierInfoTableModel policyQualifierInfoTableModel = new PolicyQualifierInfoTableModel();
        this.jtPolicyQualifierInfo = new JKseTable(policyQualifierInfoTableModel);
        TableRowSorter<PolicyQualifierInfoTableModel> sorter = new TableRowSorter<PolicyQualifierInfoTableModel>(policyQualifierInfoTableModel);
        sorter.setComparator(0, new PolicyQualifierInfoTableModel.PolicyQualifierInfoComparator());
        this.jtPolicyQualifierInfo.setRowSorter(sorter);
        this.jtPolicyQualifierInfo.setShowGrid(false);
        this.jtPolicyQualifierInfo.setRowMargin(0);
        this.jtPolicyQualifierInfo.getColumnModel().setColumnMargin(0);
        this.jtPolicyQualifierInfo.getTableHeader().setReorderingAllowed(false);
        this.jtPolicyQualifierInfo.setAutoResizeMode(4);
        this.jtPolicyQualifierInfo.setRowHeight(Math.max(18, this.jtPolicyQualifierInfo.getRowHeight()));
        for (int i = 0; i < this.jtPolicyQualifierInfo.getColumnCount(); ++i) {
            TableColumn column = this.jtPolicyQualifierInfo.getColumnModel().getColumn(i);
            column.setHeaderRenderer(new PolicyQualifierInfoTableHeadRend(this.jtPolicyQualifierInfo.getTableHeader().getDefaultRenderer()));
            column.setCellRenderer(new PolicyQualifierInfoTableCellRend());
        }
        ListSelectionModel selectionModel = this.jtPolicyQualifierInfo.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    JPolicyQualifierInfo.this.updateButtonControls();
                }
            }
        });
        this.jtPolicyQualifierInfo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPolicyQualifierInfo.this.maybeEditPolicyQualifierInfo(evt);
            }
        });
        this.jtPolicyQualifierInfo.addKeyListener(new KeyAdapter(){
            boolean deleteLastPressed = false;

            @Override
            public void keyPressed(KeyEvent evt) {
                if (!OperatingSystem.isMacOs()) {
                    this.deleteLastPressed = evt.getKeyCode() == 127;
                }
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                if (!OperatingSystem.isMacOs() && this.deleteLastPressed && evt.getKeyCode() == 127) {
                    try {
                        CursorUtil.setCursorBusy(JPolicyQualifierInfo.this);
                        this.deleteLastPressed = false;
                        JPolicyQualifierInfo.this.removeSelectedPolicyQualifierInfo();
                    }
                    finally {
                        CursorUtil.setCursorFree(JPolicyQualifierInfo.this);
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                if (OperatingSystem.isMacOs() && evt.getKeyChar() == '\b') {
                    try {
                        CursorUtil.setCursorBusy(JPolicyQualifierInfo.this);
                        JPolicyQualifierInfo.this.removeSelectedPolicyQualifierInfo();
                    }
                    finally {
                        CursorUtil.setCursorFree(JPolicyQualifierInfo.this);
                    }
                }
            }
        });
        this.jspPolicyQualifierInfo = PlatformUtil.createScrollPane(this.jtPolicyQualifierInfo, 20, 31);
        this.jspPolicyQualifierInfo.getViewport().setBackground(this.jtPolicyQualifierInfo.getBackground());
        this.setLayout(new BorderLayout(5, 5));
        this.setPreferredSize(new Dimension(400, 150));
        this.add((Component)this.jspPolicyQualifierInfo, "Center");
        this.add((Component)this.jpPolicyQualifierInfoButtons, "East");
        this.populate();
    }

    public List<PolicyQualifierInfo> getPolicyQualifierInfo() {
        return this.policyQualifierInfo;
    }

    public void setPolicyQualifierInfo(List<PolicyQualifierInfo> policyQualifierInfo) {
        this.policyQualifierInfo = policyQualifierInfo;
        this.populate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.updateButtonControls();
    }

    @Override
    public void setToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
        this.jspPolicyQualifierInfo.setToolTipText(toolTipText);
        this.jtPolicyQualifierInfo.setToolTipText(toolTipText);
    }

    private void populate() {
        if (this.policyQualifierInfo == null) {
            this.policyQualifierInfo = new ArrayList<PolicyQualifierInfo>();
        }
        this.reloadPolicyQualifierInfoTable();
        this.selectFirstPolicyQualifierInfoInTable();
        this.updateButtonControls();
    }

    private void addPressed() {
        Container container = this.getTopLevelAncestor();
        try {
            DPolicyQualifierInfoChooser dPolicyQualifierInfoChooser = null;
            dPolicyQualifierInfoChooser = container instanceof JDialog ? new DPolicyQualifierInfoChooser((JDialog)container, this.title, null) : new DPolicyQualifierInfoChooser((JFrame)container, this.title, null);
            dPolicyQualifierInfoChooser.setLocationRelativeTo(container);
            dPolicyQualifierInfoChooser.setVisible(true);
            PolicyQualifierInfo newPolicyQualifierInfo = dPolicyQualifierInfoChooser.getPolicyQualifierInfo();
            if (newPolicyQualifierInfo == null) {
                return;
            }
            this.policyQualifierInfo.add(newPolicyQualifierInfo);
            this.populate();
            this.selectPolicyQualifierInfoInTable(newPolicyQualifierInfo);
        }
        catch (IOException ex) {
            DError dError = null;
            dError = container instanceof JDialog ? new DError((JDialog)container, (Throwable)ex) : new DError((JFrame)container, (Throwable)ex);
            dError.setLocationRelativeTo(container);
            dError.setVisible(true);
        }
    }

    private void removePressed() {
        this.removeSelectedPolicyQualifierInfo();
    }

    private void removeSelectedPolicyQualifierInfo() {
        int selectedRow = this.jtPolicyQualifierInfo.getSelectedRow();
        if (selectedRow != -1) {
            PolicyQualifierInfo policyQualInfo = (PolicyQualifierInfo)this.jtPolicyQualifierInfo.getValueAt(selectedRow, 0);
            this.policyQualifierInfo.remove(policyQualInfo);
            this.reloadPolicyQualifierInfoTable();
            this.selectFirstPolicyQualifierInfoInTable();
            this.updateButtonControls();
        }
    }

    private void editPressed() {
        this.editSelectedPolicQualifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeEditPolicyQualifierInfo(MouseEvent evt) {
        Point point;
        int row;
        if (evt.getClickCount() > 1 && (row = this.jtPolicyQualifierInfo.rowAtPoint(point = new Point(evt.getX(), evt.getY()))) != -1) {
            try {
                CursorUtil.setCursorBusy(this);
                this.jtPolicyQualifierInfo.setRowSelectionInterval(row, row);
                this.editSelectedPolicQualifier();
            }
            finally {
                CursorUtil.setCursorFree(this);
            }
        }
    }

    private void updateButtonControls() {
        if (!this.enabled) {
            this.jbAdd.setEnabled(false);
            this.jbEdit.setEnabled(false);
            this.jbRemove.setEnabled(false);
        } else {
            this.jbAdd.setEnabled(true);
            int selectedRow = this.jtPolicyQualifierInfo.getSelectedRow();
            if (selectedRow == -1) {
                this.jbEdit.setEnabled(false);
                this.jbRemove.setEnabled(false);
            } else {
                this.jbEdit.setEnabled(true);
                this.jbRemove.setEnabled(true);
            }
        }
    }

    private void editSelectedPolicQualifier() {
        int selectedRow = this.jtPolicyQualifierInfo.getSelectedRow();
        if (selectedRow != -1) {
            PolicyQualifierInfo policyQualInfo = (PolicyQualifierInfo)this.jtPolicyQualifierInfo.getValueAt(selectedRow, 0);
            Container container = this.getTopLevelAncestor();
            try {
                DPolicyQualifierInfoChooser dPolicyQualifierInfoChooser = null;
                dPolicyQualifierInfoChooser = container instanceof JDialog ? new DPolicyQualifierInfoChooser((JDialog)container, this.title, policyQualInfo) : new DPolicyQualifierInfoChooser((JFrame)container, this.title, policyQualInfo);
                dPolicyQualifierInfoChooser.setLocationRelativeTo(container);
                dPolicyQualifierInfoChooser.setVisible(true);
                PolicyQualifierInfo newPolicyQualifierInfo = dPolicyQualifierInfoChooser.getPolicyQualifierInfo();
                if (newPolicyQualifierInfo == null) {
                    return;
                }
                this.policyQualifierInfo.remove(policyQualInfo);
                this.policyQualifierInfo.add(newPolicyQualifierInfo);
                this.populate();
                this.selectPolicyQualifierInfoInTable(newPolicyQualifierInfo);
            }
            catch (IOException ex) {
                DError dError = null;
                dError = container instanceof JDialog ? new DError((JDialog)container, (Throwable)ex) : new DError((JFrame)container, (Throwable)ex);
                dError.setLocationRelativeTo(container);
                dError.setVisible(true);
            }
        }
    }

    private void selectPolicyQualifierInfoInTable(PolicyQualifierInfo policyQualInfo) {
        for (int i = 0; i < this.jtPolicyQualifierInfo.getRowCount(); ++i) {
            if (!policyQualInfo.equals(this.jtPolicyQualifierInfo.getValueAt(i, 0))) continue;
            this.jtPolicyQualifierInfo.changeSelection(i, 0, false, false);
            return;
        }
    }

    private void reloadPolicyQualifierInfoTable() {
        this.getPolicyQualifierInfoTableModel().load(this.policyQualifierInfo);
    }

    private void selectFirstPolicyQualifierInfoInTable() {
        if (this.getPolicyQualifierInfoTableModel().getRowCount() > 0) {
            this.jtPolicyQualifierInfo.changeSelection(0, 0, false, false);
        }
    }

    private PolicyQualifierInfoTableModel getPolicyQualifierInfoTableModel() {
        return (PolicyQualifierInfoTableModel)this.jtPolicyQualifierInfo.getModel();
    }
}

