/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.policyinformation;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.kse.crypto.x509.PolicyInformationUtil;

public class PolicyQualifierInfoTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/policyinformation/resources");
    private String[] columnNames = new String[1];
    private Object[][] data;

    public PolicyQualifierInfoTableModel() {
        this.columnNames[0] = res.getString("PolicyQualifierInfoTableModel.PolicyQualifierInfoColumn");
        this.data = new Object[0][0];
    }

    public void load(List<PolicyQualifierInfo> policyQualifierInfo) {
        PolicyQualifierInfo[] policyQualifierInfoArray = policyQualifierInfo.toArray(new PolicyQualifierInfo[policyQualifierInfo.size()]);
        Arrays.sort(policyQualifierInfoArray, new PolicyQualifierInfoComparator());
        this.data = new Object[policyQualifierInfoArray.length][1];
        int i = 0;
        for (PolicyQualifierInfo policyQualInfo : policyQualifierInfoArray) {
            this.data[i][0] = policyQualInfo;
            ++i;
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return PolicyQualifierInfo.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    static class PolicyQualifierInfoComparator
    implements Comparator<PolicyQualifierInfo> {
        PolicyQualifierInfoComparator() {
        }

        @Override
        public int compare(PolicyQualifierInfo policyQualifierInfo1, PolicyQualifierInfo policyQualifierInfo2) {
            try {
                return PolicyInformationUtil.toString(policyQualifierInfo1).compareToIgnoreCase(PolicyInformationUtil.toString(policyQualifierInfo2));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

