/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.kse.crypto.secretkey.SecretKeyType;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;

public class DGenerateSecretKey
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpOptions;
    private JPanel jpKeyAlg;
    private JLabel jlKeyAlg;
    private JComboBox<SecretKeyType> jcbKeyAlg;
    private JPanel jpKeySize;
    private JLabel jlKeySize;
    private JSpinner jsKeySize;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private SecretKeyType secretKeyType;
    private int secretKeySize;
    private boolean success = false;

    public DGenerateSecretKey(JFrame parent, SecretKeyType secretKeyType, int secretKeySize) {
        super((Window)parent, res.getString("DGenerateSecretKey.Title"), Dialog.ModalityType.DOCUMENT_MODAL);
        this.secretKeyType = secretKeyType;
        this.secretKeySize = secretKeySize;
        this.initComponents();
    }

    private void initComponents() {
        this.jlKeySize = new JLabel(res.getString("DGenerateSecretKey.jlKeySize.text"));
        this.jsKeySize = new JSpinner();
        this.jsKeySize.setToolTipText(res.getString("DGenerateSecretKey.jsKeySize.tooltip"));
        this.jpKeySize = new JPanel(new FlowLayout(0));
        this.jpKeySize.add(this.jlKeySize);
        this.jpKeySize.add(this.jsKeySize);
        this.jlKeyAlg = new JLabel(res.getString("DGenerateSecretKey.jlKeyAlg.text"));
        this.jcbKeyAlg = new JComboBox();
        this.jcbKeyAlg.setToolTipText(res.getString("DGenerateSecretKey.jcbKeyAlg.tooltip"));
        this.populateKeyAlgs();
        this.loadKeySizes(this.secretKeySize);
        this.jcbKeyAlg.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DGenerateSecretKey.this.loadKeySizes(DGenerateSecretKey.this.getSecretKeySize());
            }
        });
        this.jpKeyAlg = new JPanel(new FlowLayout(0));
        this.jpKeyAlg.add(this.jlKeyAlg);
        this.jpKeyAlg.add(this.jcbKeyAlg);
        this.jsKeySize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DGenerateSecretKey.this.correctSecretKeySize();
            }
        });
        this.jpOptions = new JPanel(new GridLayout(2, 1, 5, 5));
        this.jpOptions.add(this.jpKeyAlg);
        this.jpOptions.add(this.jpKeySize);
        this.jpOptions.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()));
        this.jbOK = new JButton(res.getString("DGenerateSecretKey.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGenerateSecretKey.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DGenerateSecretKey.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGenerateSecretKey.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGenerateSecretKey.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpOptions, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DGenerateSecretKey.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void populateKeyAlgs() {
        for (SecretKeyType secretKeyType : SecretKeyType.values()) {
            this.jcbKeyAlg.addItem(secretKeyType);
        }
        this.jcbKeyAlg.setSelectedItem((Object)this.secretKeyType);
    }

    private void loadKeySizes(int secretKeySize) {
        SecretKeyType secretKeyType = this.getSecretKeyType();
        secretKeySize = this.validateSecretKeySize(secretKeyType, secretKeySize);
        this.jsKeySize.setModel(new SpinnerNumberModel(secretKeySize, secretKeyType.minSize(), secretKeyType.maxSize(), secretKeyType.stepSize()));
        this.jsKeySize.setEnabled(secretKeyType.maxSize() > secretKeyType.minSize());
    }

    private void correctSecretKeySize() {
        int secretKeySize;
        SecretKeyType secretKeyType = this.getSecretKeyType();
        int validatedSecretKeySize = this.validateSecretKeySize(secretKeyType, secretKeySize = this.getSecretKeySize());
        if (validatedSecretKeySize != secretKeySize) {
            this.jsKeySize.getModel().setValue(validatedSecretKeySize);
        }
    }

    private int validateSecretKeySize(SecretKeyType secretKeyType, int secretKeySize) {
        int maxSize;
        int minSize;
        int stepSize = secretKeyType.stepSize();
        if (secretKeySize % stepSize != 0) {
            int difference = secretKeySize % stepSize;
            secretKeySize = difference <= stepSize / 2 ? (secretKeySize -= difference) : (secretKeySize += stepSize - difference);
        }
        if (secretKeySize < (minSize = secretKeyType.minSize())) {
            secretKeySize = minSize;
        }
        if (secretKeySize > (maxSize = secretKeyType.maxSize())) {
            secretKeySize = maxSize;
        }
        return secretKeySize;
    }

    public int getSecretKeySize() {
        return ((Number)this.jsKeySize.getValue()).intValue();
    }

    public SecretKeyType getSecretKeyType() {
        return (SecretKeyType)((Object)this.jcbKeyAlg.getSelectedItem());
    }

    public boolean isSuccessful() {
        return this.success;
    }

    private void okPressed() {
        this.success = true;
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

