/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.KeyPair;
import java.security.Provider;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.kse.crypto.keypair.KeyPairType;
import org.kse.crypto.keypair.KeyPairUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.error.DError;

public class DGeneratingKeyPair
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpGenKeyPair;
    private JLabel jlGenKeyPair;
    private JPanel jpProgress;
    private JProgressBar jpbGenKeyPair;
    private JPanel jpCancel;
    private JButton jbCancel;
    private KeyPairType keyPairType;
    private int keySize;
    private String curveName;
    private KeyPair keyPair;
    private Thread generator;
    private Provider provider;

    public DGeneratingKeyPair(JFrame parent, KeyPairType keyPairType, int keySize, Provider provider) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.keyPairType = keyPairType;
        this.keySize = keySize;
        this.provider = provider;
        this.initComponents();
    }

    public DGeneratingKeyPair(JFrame parent, KeyPairType keyPairType, String curveName, Provider provider) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.keyPairType = keyPairType;
        this.curveName = curveName;
        this.provider = provider;
        this.initComponents();
    }

    private void initComponents() {
        this.jlGenKeyPair = new JLabel(res.getString("DGeneratingKeyPair.jlGenKeyPair.text"));
        ImageIcon icon = new ImageIcon(this.getClass().getResource("images/genkp.png"));
        this.jlGenKeyPair.setIcon(icon);
        this.jlGenKeyPair.setHorizontalTextPosition(10);
        this.jlGenKeyPair.setIconTextGap(15);
        this.jpGenKeyPair = new JPanel(new FlowLayout(1));
        this.jpGenKeyPair.add(this.jlGenKeyPair);
        this.jpGenKeyPair.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jpbGenKeyPair = new JProgressBar();
        this.jpbGenKeyPair.setIndeterminate(true);
        this.jpProgress = new JPanel(new FlowLayout(1));
        this.jpProgress.add(this.jpbGenKeyPair);
        this.jpProgress.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jbCancel = new JButton(res.getString("DGeneratingKeyPair.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGeneratingKeyPair.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGeneratingKeyPair.this.cancelPressed();
            }
        });
        this.jpCancel = PlatformUtil.createDialogButtonPanel(this.jbCancel);
        this.getContentPane().add((Component)this.jpGenKeyPair, "North");
        this.getContentPane().add((Component)this.jpProgress, "Center");
        this.getContentPane().add((Component)this.jpCancel, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                if (DGeneratingKeyPair.this.generator != null && DGeneratingKeyPair.this.generator.isAlive()) {
                    DGeneratingKeyPair.this.generator.interrupt();
                }
                DGeneratingKeyPair.this.closeDialog();
            }
        });
        this.setTitle(res.getString("DGeneratingKeyPair.Title"));
        this.setResizable(false);
        this.pack();
    }

    public void startKeyPairGeneration() {
        this.generator = new Thread(new GenerateKeyPair());
        this.generator.setPriority(1);
        this.generator.start();
    }

    private void cancelPressed() {
        if (this.generator != null && this.generator.isAlive()) {
            this.generator.interrupt();
        }
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    private class GenerateKeyPair
    implements Runnable {
        private GenerateKeyPair() {
        }

        @Override
        public void run() {
            try {
                if (DGeneratingKeyPair.this.keyPairType != KeyPairType.EC) {
                    DGeneratingKeyPair.this.keyPair = KeyPairUtil.generateKeyPair(DGeneratingKeyPair.this.keyPairType, DGeneratingKeyPair.this.keySize, DGeneratingKeyPair.this.provider);
                } else {
                    DGeneratingKeyPair.this.keyPair = KeyPairUtil.generateECKeyPair(DGeneratingKeyPair.this.curveName, DGeneratingKeyPair.this.provider);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DGeneratingKeyPair.this.isShowing()) {
                            DGeneratingKeyPair.this.closeDialog();
                        }
                    }
                });
            }
            catch (Exception ex) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DGeneratingKeyPair.this.isShowing()) {
                            DError dError = new DError(DGeneratingKeyPair.this, (Throwable)ex);
                            dError.setLocationRelativeTo(DGeneratingKeyPair.this);
                            dError.setVisible(true);
                            DGeneratingKeyPair.this.closeDialog();
                        }
                    }
                });
            }
        }
    }
}

