/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.ProxySelector;
import java.security.Security;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.bouncycastle.asn1.x500.X500Name;
import org.kse.crypto.SecurityProvider;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.CursorUtil;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.JEscDialog;
import org.kse.gui.KeyStoreTableColumns;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dnchooser.DistinguishedNameChooser;
import org.kse.gui.password.PasswordQualityConfig;
import org.kse.utilities.DialogViewer;
import org.kse.utilities.net.ManualProxySelector;
import org.kse.utilities.net.NoProxySelector;
import org.kse.utilities.net.PacProxySelector;
import org.kse.utilities.net.ProxyAddress;
import org.kse.utilities.net.SystemProxySelector;
import org.kse.utilities.os.OperatingSystem;

public class DPreferences
extends JEscDialog {
    private static final long serialVersionUID = 8804918466790662761L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JTabbedPane jtpPreferences;
    private JPanel jpAuthorityCertificates;
    private JLabel jlCaCertificatesFile;
    private JTextField jtfCaCertificatesFile;
    private JButton jbBrowseCaCertificatesFile;
    private JCheckBox jcbUseCaCertificates;
    private JCheckBox jcbUseWinTrustedRootCertificates;
    private JLabel jlTrustChecks;
    private JCheckBox jcbEnableImportTrustedCertTrustCheck;
    private JCheckBox jcbEnableImportCaReplyTrustCheck;
    private JLabel jlPasswordQuality;
    private JCheckBox jcbEnablePasswordQuality;
    private JCheckBox jcbEnforceMinimumPasswordQuality;
    private JLabel jlMinimumPasswordQuality;
    private JSlider jsMinimumPasswordQuality;
    private JPanel jpUI;
    private JLabel jlLookFeelNote;
    private JLabel jlLookFeel;
    private JComboBox<String> jcbLookFeel;
    private JLabel jlLanguage;
    private JComboBox<LanguageItem> jcbLanguage;
    private JCheckBox jcbLookFeelDecorated;
    private JPanel jpInternetProxy;
    private JRadioButton jrbNoProxy;
    private JRadioButton jrbSystemProxySettings;
    private JRadioButton jrbManualProxyConfig;
    private JLabel jlHttpHost;
    private JTextField jtfHttpHost;
    private JLabel jlHttpPort;
    private JTextField jtfHttpPort;
    private JLabel jlHttpsHost;
    private JTextField jtfHttpsHost;
    private JLabel jlHttpsPort;
    private JTextField jtfHttpsPort;
    private JLabel jlSocksHost;
    private JTextField jtfSocksHost;
    private JLabel jlSocksPort;
    private JTextField jtfSocksPort;
    private JRadioButton jrbAutomaticProxyConfig;
    private JLabel jlPacUrl;
    private JTextField jtfPacUrl;
    private JLabel jlAutoUpdateChecks;
    private JCheckBox jcbEnableAutoUpdateChecks;
    private JSpinner jspAutoUpdateCheckInterval;
    private JLabel jlAutoUpdateChecksDays;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private JPanel jpDefaultName;
    private DistinguishedNameChooser distinguishedNameChooser;
    private X500Name distinguishedName;
    private int expiryWarnDays;
    private boolean useCaCertificates;
    private File caCertificatesFile;
    private boolean useWinTrustRootCertificates;
    private boolean enableImportTrustedCertTrustCheck;
    private boolean enableImportCaReplyTrustCheck;
    private PasswordQualityConfig passwordQualityConfig;
    private ArrayList<UIManager.LookAndFeelInfo> lookFeelInfoList = new ArrayList();
    private UIManager.LookAndFeelInfo lookFeelInfo;
    private boolean lookFeelDecorated;
    private String language;
    private boolean autoUpdateChecksEnabled;
    private int autoUpdateChecksInterval;
    private String defaultDN;
    private boolean cancelled = false;
    private KeyStoreTableColumns kstColumns;
    private JPanel jpDisplayColumns;
    private JLabel jlDisplayColumns;
    private JCheckBox jcbEnableEntryName;
    private boolean bEnableEntryName;
    private JCheckBox jcbEnableAlgorithm;
    private boolean bEnableAlgorithm;
    private JCheckBox jcbEnableKeySize;
    private boolean bEnableKeySize;
    private JCheckBox jcbEnableCertificateExpiry;
    private boolean bEnableCertificateExpiry;
    private JCheckBox jcbEnableLastModified;
    private boolean bEnableLastModified;
    private JCheckBox jcbEnableCurve;
    private boolean bEnableCurve;
    private JCheckBox jcbEnableSKI;
    private boolean bEnableSKI;
    private JCheckBox jcbEnableAKI;
    private boolean bEnableAKI;
    private JCheckBox jcbEnableIssuerDN;
    private boolean bEnableIssuerDN;
    private JCheckBox jcbEnableIssuerCN;
    private boolean bEnableIssuerCN;
    private JCheckBox jcbEnableSubjectDN;
    private boolean bEnableSubjectDN;
    private JCheckBox jcbEnableSubjectCN;
    private boolean bEnableSubjectCN;
    private JCheckBox jcbEnableIssuerO;
    private boolean bEnableIssuerO;
    private JCheckBox jcbEnableSubjectO;
    private boolean bEnableSubjectO;
    private JLabel jlExpirationWarnDays;
    private JTextField jtfExpirationWarnDays;
    private boolean bColumnsChanged;

    public DPreferences(JFrame parent, boolean useCaCertificates, File caCertificatesFile, boolean useWinTrustedRootCertificates, boolean enableImportTrustedCertTrustCheck, boolean enableImportCaReplyTrustCheck, PasswordQualityConfig passwordQualityConfig, String defaultDN, String language, boolean autoUpdateChecksEnabled, int autoUpdateChecksInterval, KeyStoreTableColumns kstColumns) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.useCaCertificates = useCaCertificates;
        this.caCertificatesFile = caCertificatesFile;
        this.useWinTrustRootCertificates = useWinTrustedRootCertificates;
        this.enableImportTrustedCertTrustCheck = enableImportTrustedCertTrustCheck;
        this.enableImportCaReplyTrustCheck = enableImportCaReplyTrustCheck;
        this.passwordQualityConfig = passwordQualityConfig;
        this.defaultDN = defaultDN;
        this.language = language;
        this.autoUpdateChecksEnabled = autoUpdateChecksEnabled;
        this.autoUpdateChecksInterval = autoUpdateChecksInterval;
        this.expiryWarnDays = kstColumns.getExpiryWarnDays();
        this.kstColumns = kstColumns;
        this.initComponents();
    }

    private void initComponents() {
        this.initAuthorityCertificatesTab();
        this.initUserInterfaceTab();
        this.initInternetProxyTab();
        this.initDefaultNameTab();
        this.initDisplayColumnsTab();
        this.jtpPreferences = new JTabbedPane();
        this.jtpPreferences.setTabLayoutPolicy(0);
        this.jtpPreferences.addTab(res.getString("DPreferences.jpAuthorityCertificates.text"), new ImageIcon(this.getClass().getResource("images/tab_authcerts.png")), this.jpAuthorityCertificates, res.getString("DPreferences.jpAuthorityCertificates.tooltip"));
        this.jtpPreferences.addTab(res.getString("DPreferences.jpUI.text"), new ImageIcon(this.getClass().getResource("images/tab_lookfeel.png")), this.jpUI, res.getString("DPreferences.jpUI.tooltip"));
        this.jtpPreferences.addTab(res.getString("DPreferences.jpInternetProxy.text"), new ImageIcon(this.getClass().getResource("images/tab_internetproxy.png")), this.jpInternetProxy, res.getString("DPreferences.jpInternetProxy.tooltip"));
        this.jtpPreferences.addTab(res.getString("DPreferences.jpDefaultName.text"), new ImageIcon(this.getClass().getResource("images/tab_defaultname.png")), this.jpDefaultName, res.getString("DPreferences.jpDefaultName.tooltip"));
        this.jtpPreferences.addTab(res.getString("DPreferences.jpDisplayColumns.text"), new ImageIcon(this.getClass().getResource("images/tab_columns.png")), this.jpDisplayColumns, res.getString("DPreferences.jpDisplayColumns.tooltip"));
        this.jtpPreferences.setBorder(new EmptyBorder(5, 5, 5, 5));
        if (!OperatingSystem.isMacOs()) {
            this.jtpPreferences.setMnemonicAt(0, res.getString("DPreferences.jpAuthorityCertificates.mnemonic").charAt(0));
            this.jtpPreferences.setMnemonicAt(1, res.getString("DPreferences.jpUI.mnemonic").charAt(0));
            this.jtpPreferences.setMnemonicAt(2, res.getString("DPreferences.jpInternetProxy.mnemonic").charAt(0));
            this.jtpPreferences.setMnemonicAt(3, res.getString("DPreferences.jpDefaultName.mnemonic").charAt(0));
            this.jtpPreferences.setMnemonicAt(4, res.getString("DPreferences.jpDisplayColumns.mnemonic").charAt(0));
        }
        this.jbOK = new JButton(res.getString("DPreferences.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DPreferences.this);
                    DPreferences.this.okPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DPreferences.this);
                }
            }
        });
        this.jbCancel = new JButton(res.getString("DPreferences.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPreferences.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPreferences.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jtpPreferences, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DPreferences.this.cancelPressed();
            }
        });
        this.setTitle(res.getString("DPreferences.Title"));
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void initAuthorityCertificatesTab() {
        this.jlCaCertificatesFile = new JLabel(res.getString("DPreferences.jlCaCertificatesFile.text"));
        this.jtfCaCertificatesFile = new JTextField(this.caCertificatesFile.toString(), 25);
        this.jtfCaCertificatesFile.setToolTipText(res.getString("DPreferences.jtfCaCertificatesFile.tooltip"));
        this.jtfCaCertificatesFile.setCaretPosition(0);
        this.jtfCaCertificatesFile.setEditable(false);
        this.jbBrowseCaCertificatesFile = new JButton(res.getString("DPreferences.jbBrowseCaCertificatesFile.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbBrowseCaCertificatesFile, res.getString("DPreferences.jbBrowseCaCertificatesFile.mnemonic").charAt(0));
        this.jbBrowseCaCertificatesFile.setToolTipText(res.getString("DPreferences.jbBrowseCaCertificatesFile.tooltip"));
        this.jcbUseCaCertificates = new JCheckBox(res.getString("DPreferences.jcbUseCaCertificates.text"), this.useCaCertificates);
        this.jcbUseCaCertificates.setToolTipText(res.getString("DPreferences.jcbUseCaCertificates.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jcbUseCaCertificates, res.getString("DPreferences.jcbUseCaCertificates.mnemonic").charAt(0));
        this.jcbUseWinTrustedRootCertificates = new JCheckBox(res.getString("DPreferences.jcbUseWinTrustRootCertificates.text"), this.useWinTrustRootCertificates);
        this.jcbUseWinTrustedRootCertificates.setToolTipText(res.getString("DPreferences.jcbUseWinTrustRootCertificates.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jcbUseWinTrustedRootCertificates, res.getString("DPreferences.jcbUseWinTrustRootCertificates.menmonic").charAt(0));
        this.jlTrustChecks = new JLabel(res.getString("DPreferences.jlTrustChecks.text"));
        this.jcbEnableImportTrustedCertTrustCheck = new JCheckBox(res.getString("DPreferences.jcbEnableImportTrustedCertTrustCheck.text"), this.enableImportTrustedCertTrustCheck);
        this.jcbEnableImportTrustedCertTrustCheck.setToolTipText(res.getString("DPreferences.jcbEnableImportTrustedCertTrustCheck.tooltip"));
        this.jcbEnableImportTrustedCertTrustCheck.setMnemonic(res.getString("DPreferences.jcbEnableImportTrustedCertTrustCheck.mnemonic").charAt(0));
        this.jcbEnableImportCaReplyTrustCheck = new JCheckBox(res.getString("DPreferences.jcbEnableImportCaReplyTrustCheck.text"), this.enableImportCaReplyTrustCheck);
        this.jcbEnableImportCaReplyTrustCheck.setToolTipText(res.getString("DPreferences.jcbEnableImportCaReplyTrustCheck.tooltip"));
        this.jcbEnableImportCaReplyTrustCheck.setMnemonic(res.getString("DPreferences.jcbEnableImportCaReplyTrustCheck.mnemonic").charAt(0));
        this.jpAuthorityCertificates = new JPanel();
        this.jpAuthorityCertificates.setLayout((LayoutManager)new MigLayout("insets dialog", "20lp[][]", "20lp[][]"));
        this.jpAuthorityCertificates.add((Component)this.jlCaCertificatesFile, "split");
        this.jpAuthorityCertificates.add((Component)this.jtfCaCertificatesFile, "");
        this.jpAuthorityCertificates.add((Component)this.jbBrowseCaCertificatesFile, "wrap rel");
        if (Security.getProvider(SecurityProvider.MS_CAPI.jce()) != null) {
            this.jpAuthorityCertificates.add((Component)this.jcbUseCaCertificates, "wrap rel");
            this.jpAuthorityCertificates.add((Component)this.jcbUseWinTrustedRootCertificates, "wrap para");
        } else {
            this.jpAuthorityCertificates.add((Component)this.jcbUseCaCertificates, "wrap para");
        }
        this.jpAuthorityCertificates.add((Component)this.jlTrustChecks, "wrap unrel");
        this.jpAuthorityCertificates.add((Component)this.jcbEnableImportTrustedCertTrustCheck, "wrap rel");
        this.jpAuthorityCertificates.add((Component)this.jcbEnableImportCaReplyTrustCheck, "wrap unrel");
        this.jbBrowseCaCertificatesFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DPreferences.this);
                    DPreferences.this.browsePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DPreferences.this);
                }
            }
        });
    }

    private void initUserInterfaceTab() {
        this.jlLookFeelNote = new JLabel(res.getString("DPreferences.jlLookFeelNote.text"));
        this.jlLookFeel = new JLabel(res.getString("DPreferences.jlLookFeel.text"));
        this.jcbLookFeel = new JComboBox();
        this.jcbLookFeel.setToolTipText(res.getString("DPreferences.jcbLookFeel.tooltip"));
        this.initLookAndFeelSelection();
        this.jcbLookFeelDecorated = new JCheckBox(res.getString("DPreferences.jcbLookFeelDecorated.text"), JFrame.isDefaultLookAndFeelDecorated());
        this.jcbLookFeelDecorated.setToolTipText(res.getString("DPreferences.jcbLookFeelDecorated.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jcbLookFeelDecorated, res.getString("DPreferences.jcbLookFeelDecorated.menmonic").charAt(0));
        this.jlLanguage = new JLabel(res.getString("DPreferences.jlLanguage.text"));
        this.jcbLanguage = new JComboBox();
        this.jcbLanguage.setToolTipText(res.getString("DPreferences.jcbLanguage.tooltip"));
        this.initLanguageSelection();
        this.jlAutoUpdateChecks = new JLabel(res.getString("DPreferences.jlAutoUpdateChecks.text"));
        this.jcbEnableAutoUpdateChecks = new JCheckBox(res.getString("DPreferences.jcbEnableAutoUpdateChecks.text"));
        this.jcbEnableAutoUpdateChecks.setSelected(this.autoUpdateChecksEnabled);
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel((double)this.autoUpdateChecksInterval, 1.0, 999.0, 1.0);
        this.jspAutoUpdateCheckInterval = new JSpinner(spinnerModel);
        this.jspAutoUpdateCheckInterval.setEnabled(this.autoUpdateChecksEnabled);
        this.jlAutoUpdateChecksDays = new JLabel(res.getString("DPreferences.jlAutoUpdateChecksDays.text"));
        this.jlPasswordQuality = new JLabel(res.getString("DPreferences.jpPasswordQuality.text"));
        this.jcbEnablePasswordQuality = new JCheckBox(res.getString("DPreferences.jcbEnablePasswordQuality.text"));
        this.jcbEnablePasswordQuality.setMnemonic(res.getString("DPreferences.jcbEnablePasswordQuality.mnemonic").charAt(0));
        this.jcbEnablePasswordQuality.setToolTipText(res.getString("DPreferences.jcbEnablePasswordQuality.tooltip"));
        this.jcbEnforceMinimumPasswordQuality = new JCheckBox(res.getString("DPreferences.jcbEnforceMinimumPasswordQuality.text"));
        this.jcbEnforceMinimumPasswordQuality.setMnemonic(res.getString("DPreferences.jcbEnforceMinimumPasswordQuality.mnemonic").charAt(0));
        this.jcbEnforceMinimumPasswordQuality.setToolTipText(res.getString("DPreferences.jcbEnforceMinimumPasswordQuality.tooltip"));
        this.jlMinimumPasswordQuality = new JLabel(res.getString("DPreferences.jlMinimumPasswordQuality.text"));
        this.jsMinimumPasswordQuality = new JSlider(0, 100);
        this.jsMinimumPasswordQuality.setPaintLabels(true);
        this.jsMinimumPasswordQuality.setMajorTickSpacing(25);
        this.jsMinimumPasswordQuality.setToolTipText(res.getString("DPreferences.jsMinimumPasswordQuality.tooltip"));
        boolean passwordQualityEnabled = this.passwordQualityConfig.getEnabled();
        boolean passwordQualityEnforced = this.passwordQualityConfig.getEnforced();
        int minimumPasswordQuality = this.passwordQualityConfig.getMinimumQuality();
        this.jcbEnablePasswordQuality.setSelected(passwordQualityEnabled);
        this.jcbEnforceMinimumPasswordQuality.setSelected(passwordQualityEnforced);
        this.jsMinimumPasswordQuality.setValue(minimumPasswordQuality);
        this.jcbEnforceMinimumPasswordQuality.setEnabled(passwordQualityEnabled);
        this.jlMinimumPasswordQuality.setEnabled(passwordQualityEnabled && passwordQualityEnforced);
        this.jsMinimumPasswordQuality.setEnabled(passwordQualityEnabled && passwordQualityEnforced);
        this.jpUI = new JPanel();
        this.jpUI.setLayout((LayoutManager)new MigLayout("insets dialog", "20lp[][]", "20lp[][]"));
        this.jpUI.add((Component)this.jlLookFeelNote, "split, span, wrap unrel");
        this.jpUI.add((Component)this.jlLookFeel, "");
        this.jpUI.add(this.jcbLookFeel, "growx");
        this.jpUI.add((Component)this.jcbLookFeelDecorated, "wrap");
        this.jpUI.add((Component)this.jlLanguage, "");
        this.jpUI.add(this.jcbLanguage, "growx, wrap unrel");
        this.jpUI.add((Component)this.jlAutoUpdateChecks, "spanx, split 4");
        this.jpUI.add((Component)this.jcbEnableAutoUpdateChecks, "");
        this.jpUI.add((Component)this.jspAutoUpdateCheckInterval, "");
        this.jpUI.add((Component)this.jlAutoUpdateChecksDays, "wrap unrel");
        this.jpUI.add((Component)this.jlPasswordQuality, "spanx, wrap");
        this.jpUI.add((Component)this.jcbEnablePasswordQuality, "spanx, wrap");
        this.jpUI.add((Component)this.jcbEnforceMinimumPasswordQuality, "spanx, gapx indent, wrap");
        this.jpUI.add((Component)this.jlMinimumPasswordQuality, "gapx 4*indent, top, spanx, split 3");
        this.jpUI.add((Component)this.jsMinimumPasswordQuality, "wrap");
        this.jcbEnableAutoUpdateChecks.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DPreferences.this.jspAutoUpdateCheckInterval.setEnabled(DPreferences.this.jcbEnableAutoUpdateChecks.isSelected());
            }
        });
        this.jcbEnablePasswordQuality.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DPreferences.this.jcbEnforceMinimumPasswordQuality.setEnabled(DPreferences.this.jcbEnablePasswordQuality.isSelected());
                DPreferences.this.jlMinimumPasswordQuality.setEnabled(DPreferences.this.jcbEnablePasswordQuality.isSelected() && DPreferences.this.jcbEnforceMinimumPasswordQuality.isSelected());
                DPreferences.this.jsMinimumPasswordQuality.setEnabled(DPreferences.this.jcbEnablePasswordQuality.isSelected() && DPreferences.this.jcbEnforceMinimumPasswordQuality.isSelected());
            }
        });
        this.jcbEnforceMinimumPasswordQuality.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DPreferences.this.jlMinimumPasswordQuality.setEnabled(DPreferences.this.jcbEnablePasswordQuality.isSelected() && DPreferences.this.jcbEnforceMinimumPasswordQuality.isSelected());
                DPreferences.this.jsMinimumPasswordQuality.setEnabled(DPreferences.this.jcbEnablePasswordQuality.isSelected() && DPreferences.this.jcbEnforceMinimumPasswordQuality.isSelected());
            }
        });
    }

    private void initLookAndFeelSelection() {
        UIManager.LookAndFeelInfo[] lookFeelInfos = UIManager.getInstalledLookAndFeels();
        LookAndFeel currentLookAndFeel = UIManager.getLookAndFeel();
        TreeSet<String> lookFeelClasses = new TreeSet<String>();
        for (UIManager.LookAndFeelInfo lfi : lookFeelInfos) {
            if (lookFeelClasses.contains(lfi.getClassName())) continue;
            lookFeelClasses.add(lfi.getClassName());
            this.lookFeelInfoList.add(lfi);
            this.jcbLookFeel.addItem(lfi.getName());
            if (currentLookAndFeel == null || !currentLookAndFeel.getClass().getName().equals(lfi.getClassName())) continue;
            this.lookFeelInfo = lfi;
            this.jcbLookFeel.setSelectedIndex(this.jcbLookFeel.getItemCount() - 1);
        }
    }

    private void initLanguageSelection() {
        LanguageItem[] languageItems;
        for (LanguageItem languageItem : languageItems = new LanguageItem[]{new LanguageItem("System", "system"), new LanguageItem("English", "en"), new LanguageItem("German", "de"), new LanguageItem("French", "fr")}) {
            this.jcbLanguage.addItem(languageItem);
            if (!languageItem.getIsoCode().equals(this.language)) continue;
            this.jcbLanguage.setSelectedItem(languageItem);
        }
    }

    private void initInternetProxyTab() {
        this.jrbNoProxy = new JRadioButton(res.getString("DPreferences.jrbNoProxy.text"));
        this.jrbNoProxy.setToolTipText(res.getString("DPreferences.jrbNoProxy.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jrbNoProxy, res.getString("DPreferences.jrbNoProxy.mnemonic").charAt(0));
        this.jrbSystemProxySettings = new JRadioButton(res.getString("DPreferences.jrbSystemProxySettings.text"), true);
        this.jrbSystemProxySettings.setToolTipText(res.getString("DPreferences.jrbSystemProxySettings.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jrbSystemProxySettings, res.getString("DPreferences.jrbSystemProxySettings.mnemonic").charAt(0));
        this.jrbManualProxyConfig = new JRadioButton(res.getString("DPreferences.jrbManualProxyConfig.text"));
        this.jrbManualProxyConfig.setToolTipText(res.getString("DPreferences.jrbManualProxyConfig.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jrbManualProxyConfig, res.getString("DPreferences.jrbManualProxyConfig.mnemonic").charAt(0));
        this.jlHttpHost = new JLabel(res.getString("DPreferences.jlHttpHost.text"));
        this.jtfHttpHost = new JTextField(20);
        this.jtfHttpHost.setToolTipText(res.getString("DPreferences.jtfHttpHost.tooltip"));
        this.jtfHttpHost.setEnabled(false);
        this.jlHttpPort = new JLabel(res.getString("DPreferences.jlHttpPort.text"));
        this.jtfHttpPort = new JTextField(5);
        this.jtfHttpPort.setToolTipText(res.getString("DPreferences.jtfHttpPort.tooltip"));
        this.jtfHttpPort.setEnabled(false);
        this.jlHttpsHost = new JLabel(res.getString("DPreferences.jlHttpsHost.text"));
        this.jtfHttpsHost = new JTextField(20);
        this.jtfHttpsHost.setToolTipText(res.getString("DPreferences.jtfHttpsHost.tooltip"));
        this.jtfHttpsHost.setEnabled(false);
        this.jlHttpsPort = new JLabel(res.getString("DPreferences.jlHttpsPort.text"));
        this.jtfHttpsPort = new JTextField(5);
        this.jtfHttpsPort.setToolTipText(res.getString("DPreferences.jtfHttpsPort.tooltip"));
        this.jtfHttpsPort.setEnabled(false);
        this.jlSocksHost = new JLabel(res.getString("DPreferences.jlSocksHost.text"));
        this.jtfSocksHost = new JTextField(20);
        this.jtfSocksHost.setToolTipText(res.getString("DPreferences.jtfSocksHost.tooltip"));
        this.jtfSocksHost.setEnabled(false);
        this.jlSocksPort = new JLabel(res.getString("DPreferences.jlSocksPort.text"));
        this.jtfSocksPort = new JTextField(5);
        this.jtfSocksPort.setToolTipText(res.getString("DPreferences.jtfSocksPort.tooltip"));
        this.jtfSocksPort.setEnabled(false);
        this.jrbAutomaticProxyConfig = new JRadioButton(res.getString("DPreferences.jrbAutomaticProxyConfig.text"));
        this.jrbAutomaticProxyConfig.setToolTipText(res.getString("DPreferences.jrbAutomaticProxyConfig.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jrbAutomaticProxyConfig, res.getString("DPreferences.jrbAutomaticProxyConfig.mnemonic").charAt(0));
        this.jlPacUrl = new JLabel(res.getString("DPreferences.jlPacUrl.text"));
        this.jtfPacUrl = new JTextField(30);
        this.jtfPacUrl.setToolTipText(res.getString("DPreferences.jtfPacUrl.tooltip"));
        this.jtfPacUrl.setEnabled(false);
        ButtonGroup bgProxies = new ButtonGroup();
        bgProxies.add(this.jrbNoProxy);
        bgProxies.add(this.jrbSystemProxySettings);
        bgProxies.add(this.jrbManualProxyConfig);
        bgProxies.add(this.jrbAutomaticProxyConfig);
        this.jpInternetProxy = new JPanel();
        this.jpInternetProxy.setLayout((LayoutManager)new MigLayout("insets dialog", "20lp[][]", "20lp[][]"));
        this.jpInternetProxy.add((Component)this.jrbNoProxy, "left, span, wrap");
        this.jpInternetProxy.add((Component)this.jrbSystemProxySettings, "left, span, wrap");
        this.jpInternetProxy.add((Component)this.jrbManualProxyConfig, "left, span, wrap");
        this.jpInternetProxy.add((Component)this.jlHttpHost, "gap unrel, skip, right");
        this.jpInternetProxy.add((Component)this.jtfHttpHost, "");
        this.jpInternetProxy.add((Component)this.jlHttpPort, "gap unrel, right");
        this.jpInternetProxy.add((Component)this.jtfHttpPort, "wrap");
        this.jpInternetProxy.add((Component)this.jlHttpsHost, "gap unrel, skip, right");
        this.jpInternetProxy.add((Component)this.jtfHttpsHost, "");
        this.jpInternetProxy.add((Component)this.jlHttpsPort, "gap unrel, right");
        this.jpInternetProxy.add((Component)this.jtfHttpsPort, "wrap");
        this.jpInternetProxy.add((Component)this.jlSocksHost, "gap unrel, skip, right");
        this.jpInternetProxy.add((Component)this.jtfSocksHost, "");
        this.jpInternetProxy.add((Component)this.jlSocksPort, "gap unrel, right");
        this.jpInternetProxy.add((Component)this.jtfSocksPort, "wrap");
        this.jpInternetProxy.add((Component)this.jrbAutomaticProxyConfig, "left, span, wrap");
        this.jpInternetProxy.add((Component)this.jlPacUrl, "gap unrel, skip, right");
        this.jpInternetProxy.add((Component)this.jtfPacUrl, "span, wrap push");
        this.jrbAutomaticProxyConfig.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DPreferences.this.updateProxyControls();
            }
        });
        this.jrbManualProxyConfig.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DPreferences.this.updateProxyControls();
            }
        });
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (proxySelector instanceof SystemProxySelector) {
            this.jrbSystemProxySettings.setSelected(true);
        } else if (proxySelector instanceof PacProxySelector) {
            this.jrbAutomaticProxyConfig.setSelected(true);
            PacProxySelector pacProxySelector = (PacProxySelector)proxySelector;
            this.jtfPacUrl.setText(pacProxySelector.getPacUrl());
        } else if (proxySelector instanceof ManualProxySelector) {
            this.jrbManualProxyConfig.setSelected(true);
            ManualProxySelector manualProxySelector = (ManualProxySelector)proxySelector;
            ProxyAddress httpProxy = manualProxySelector.getHttpProxyAddress();
            ProxyAddress httpsProxy = manualProxySelector.getHttpsProxyAddress();
            ProxyAddress socksProxy = manualProxySelector.getSocksProxyAddress();
            if (httpProxy != null) {
                this.jtfHttpHost.setText(httpProxy.getHost());
                this.jtfHttpHost.setCaretPosition(0);
                this.jtfHttpPort.setText("" + httpProxy.getPort());
                this.jtfHttpPort.setCaretPosition(0);
            }
            if (httpsProxy != null) {
                this.jtfHttpsHost.setText(httpsProxy.getHost());
                this.jtfHttpsHost.setCaretPosition(0);
                this.jtfHttpsPort.setText("" + httpsProxy.getPort());
                this.jtfHttpsPort.setCaretPosition(0);
            }
            if (socksProxy != null) {
                this.jtfSocksHost.setText(socksProxy.getHost());
                this.jtfSocksHost.setCaretPosition(0);
                this.jtfSocksPort.setText("" + socksProxy.getPort());
                this.jtfSocksPort.setCaretPosition(0);
            }
        } else {
            this.jrbNoProxy.setSelected(true);
        }
    }

    private void initDefaultNameTab() {
        this.distinguishedNameChooser = new DistinguishedNameChooser(this.distinguishedName, true, this.defaultDN);
        this.jpDefaultName = new JPanel();
        this.jpDefaultName.setLayout((LayoutManager)new MigLayout("insets dialog, fill", "[]", "[]"));
        this.jpDefaultName.add((Component)this.distinguishedNameChooser, "left, spanx, wrap para");
    }

    private void initDisplayColumnsTab() {
        this.bColumnsChanged = false;
        this.jpDisplayColumns = new JPanel();
        this.jlDisplayColumns = new JLabel(res.getString("DPreferences.jlDisplayColumns.text"));
        this.bEnableEntryName = this.kstColumns.getEnableEntryName();
        this.jcbEnableEntryName = new JCheckBox(res.getString("DPreferences.jcbEnableEntryName.text"), this.bEnableEntryName);
        this.jcbEnableEntryName.setSelected(true);
        this.jcbEnableEntryName.setEnabled(false);
        this.bEnableAlgorithm = this.kstColumns.getEnableAlgorithm();
        this.jcbEnableAlgorithm = new JCheckBox(res.getString("DPreferences.jcbEnableAlgorithm.text"), this.bEnableAlgorithm);
        this.bEnableKeySize = this.kstColumns.getEnableKeySize();
        this.jcbEnableKeySize = new JCheckBox(res.getString("DPreferences.jcbEnableKeySize.text"), this.bEnableKeySize);
        this.jcbEnableKeySize.setSelected(this.bEnableKeySize);
        this.bEnableCurve = this.kstColumns.getEnableCurve();
        this.jcbEnableCurve = new JCheckBox(res.getString("DPreferences.jcbEnableCurve.text"), this.bEnableCurve);
        this.jcbEnableCurve.setSelected(this.bEnableCurve);
        this.bEnableCertificateExpiry = this.kstColumns.getEnableCertificateExpiry();
        this.jcbEnableCertificateExpiry = new JCheckBox(res.getString("DPreferences.jcbEnableCertificateExpiry.text"), this.bEnableCertificateExpiry);
        this.jcbEnableCertificateExpiry.setSelected(this.bEnableCertificateExpiry);
        this.bEnableLastModified = this.kstColumns.getEnableLastModified();
        this.jcbEnableLastModified = new JCheckBox(res.getString("DPreferences.jcbEnableLastModified.text"), this.bEnableLastModified);
        this.jcbEnableLastModified.setSelected(this.bEnableLastModified);
        this.bEnableSKI = this.kstColumns.getEnableSKI();
        this.jcbEnableSKI = new JCheckBox(res.getString("DPreferences.jcbEnableSKI.text"), this.bEnableSKI);
        this.jcbEnableSKI.setSelected(this.bEnableSKI);
        this.bEnableAKI = this.kstColumns.getEnableAKI();
        this.jcbEnableAKI = new JCheckBox(res.getString("DPreferences.jcbEnableAKI.text"), this.bEnableAKI);
        this.jcbEnableAKI.setSelected(this.bEnableAKI);
        this.bEnableIssuerDN = this.kstColumns.getEnableIssuerDN();
        this.jcbEnableIssuerDN = new JCheckBox(res.getString("DPreferences.jcbEnableIssuerDN.text"), this.bEnableIssuerDN);
        this.jcbEnableIssuerDN.setSelected(this.bEnableIssuerDN);
        this.bEnableSubjectDN = this.kstColumns.getEnableSubjectDN();
        this.jcbEnableSubjectDN = new JCheckBox(res.getString("DPreferences.jcbEnableSubjectDN.text"), this.bEnableSubjectDN);
        this.jcbEnableSubjectDN.setSelected(this.bEnableSubjectDN);
        this.bEnableIssuerCN = this.kstColumns.getEnableIssuerCN();
        this.jcbEnableIssuerCN = new JCheckBox(res.getString("DPreferences.jcbEnableIssuerCN.text"), this.bEnableIssuerCN);
        this.jcbEnableIssuerCN.setSelected(this.bEnableIssuerCN);
        this.bEnableSubjectCN = this.kstColumns.getEnableSubjectCN();
        this.jcbEnableSubjectCN = new JCheckBox(res.getString("DPreferences.jcbEnableSubjectCN.text"), this.bEnableSubjectCN);
        this.jcbEnableSubjectCN.setSelected(this.bEnableSubjectCN);
        this.bEnableIssuerO = this.kstColumns.getEnableIssuerO();
        this.jcbEnableIssuerO = new JCheckBox(res.getString("DPreferences.jcbEnableIssuerO.text"), this.bEnableIssuerO);
        this.jcbEnableIssuerO.setSelected(this.bEnableIssuerO);
        this.bEnableSubjectO = this.kstColumns.getEnableSubjectO();
        this.jcbEnableSubjectO = new JCheckBox(res.getString("DPreferences.jcbEnableSubjectO.text"), this.bEnableSubjectO);
        this.jcbEnableSubjectO.setSelected(this.bEnableSubjectO);
        this.jlExpirationWarnDays = new JLabel(res.getString("DPreferences.jlExpiryWarning.text"));
        this.jtfExpirationWarnDays = new JTextField();
        this.jtfExpirationWarnDays.setColumns(3);
        this.jtfExpirationWarnDays.setText(Integer.toString(this.expiryWarnDays));
        this.jpDisplayColumns.setLayout((LayoutManager)new MigLayout("insets dialog, fill", "[][]", ""));
        this.jpDisplayColumns.add((Component)this.jlDisplayColumns, "left, wrap");
        this.jpDisplayColumns.add((Component)this.jcbEnableEntryName, "left");
        this.jpDisplayColumns.add((Component)this.jcbEnableAlgorithm, "left, wrap");
        this.jpDisplayColumns.add((Component)this.jcbEnableKeySize, "left");
        this.jpDisplayColumns.add((Component)this.jcbEnableCurve, "left, wrap");
        this.jpDisplayColumns.add((Component)this.jcbEnableCertificateExpiry, "left");
        this.jpDisplayColumns.add((Component)this.jcbEnableLastModified, "left, wrap");
        this.jpDisplayColumns.add((Component)this.jcbEnableSKI, "left");
        this.jpDisplayColumns.add((Component)this.jcbEnableAKI, "left, wrap");
        this.jpDisplayColumns.add((Component)this.jcbEnableIssuerDN, "left");
        this.jpDisplayColumns.add((Component)this.jcbEnableSubjectDN, "left, wrap");
        this.jpDisplayColumns.add((Component)this.jcbEnableIssuerCN, "left");
        this.jpDisplayColumns.add((Component)this.jcbEnableSubjectCN, "left, wrap");
        this.jpDisplayColumns.add((Component)this.jcbEnableIssuerO, "left");
        this.jpDisplayColumns.add((Component)this.jcbEnableSubjectO, "left, wrap");
        this.jpDisplayColumns.add((Component)this.jlExpirationWarnDays, "left, spanx, split");
        this.jpDisplayColumns.add((Component)this.jtfExpirationWarnDays, "wrap");
    }

    private void updateProxyControls() {
        if (this.jrbManualProxyConfig.isSelected()) {
            this.jtfHttpHost.setEnabled(true);
            this.jtfHttpPort.setEnabled(true);
            this.jtfHttpsHost.setEnabled(true);
            this.jtfHttpsPort.setEnabled(true);
            this.jtfSocksHost.setEnabled(true);
            this.jtfSocksPort.setEnabled(true);
            this.jtfPacUrl.setEnabled(false);
        } else if (this.jrbAutomaticProxyConfig.isSelected()) {
            this.jtfHttpHost.setEnabled(false);
            this.jtfHttpPort.setEnabled(false);
            this.jtfHttpsHost.setEnabled(false);
            this.jtfHttpsPort.setEnabled(false);
            this.jtfSocksHost.setEnabled(false);
            this.jtfSocksPort.setEnabled(false);
            this.jtfPacUrl.setEnabled(true);
        } else {
            this.jtfHttpHost.setEnabled(false);
            this.jtfHttpPort.setEnabled(false);
            this.jtfHttpsHost.setEnabled(false);
            this.jtfHttpsPort.setEnabled(false);
            this.jtfSocksHost.setEnabled(false);
            this.jtfSocksPort.setEnabled(false);
            this.jtfPacUrl.setEnabled(false);
        }
    }

    private boolean storePreferences() {
        this.caCertificatesFile = new File(this.jtfCaCertificatesFile.getText());
        this.useCaCertificates = this.jcbUseCaCertificates.isSelected();
        if (Security.getProvider(SecurityProvider.MS_CAPI.jce()) != null) {
            this.useWinTrustRootCertificates = this.jcbUseWinTrustedRootCertificates.isSelected();
        }
        this.enableImportTrustedCertTrustCheck = this.jcbEnableImportTrustedCertTrustCheck.isSelected();
        this.enableImportCaReplyTrustCheck = this.jcbEnableImportCaReplyTrustCheck.isSelected();
        this.passwordQualityConfig.setEnabled(this.jcbEnablePasswordQuality.isSelected());
        this.passwordQualityConfig.setMinimumQuality(this.jsMinimumPasswordQuality.getValue());
        this.passwordQualityConfig.setEnforced(this.jcbEnforceMinimumPasswordQuality.isSelected());
        int selectedIndex = this.jcbLookFeel.getSelectedIndex();
        this.lookFeelInfo = this.lookFeelInfoList.get(selectedIndex);
        this.lookFeelDecorated = this.jcbLookFeelDecorated.isSelected();
        this.storeColumns();
        this.language = ((LanguageItem)this.jcbLanguage.getSelectedItem()).getIsoCode();
        this.autoUpdateChecksEnabled = this.jcbEnableAutoUpdateChecks.isSelected();
        this.autoUpdateChecksInterval = ((Number)this.jspAutoUpdateCheckInterval.getValue()).intValue();
        boolean returnValue = this.storeDefaultDN();
        return returnValue &= this.storeProxyPreferences();
    }

    private boolean storeDefaultDN() {
        X500Name dn = this.distinguishedNameChooser.getDNWithEmptyRdns();
        this.defaultDN = dn.toString();
        return true;
    }

    private boolean storeProxyPreferences() {
        ProxySelector defaultProxySelector = ProxySelector.getDefault();
        if (this.jrbNoProxy.isSelected()) {
            NoProxySelector noProxySelector = new NoProxySelector();
            if (!noProxySelector.equals(defaultProxySelector)) {
                ProxySelector.setDefault(noProxySelector);
            }
        } else if (this.jrbSystemProxySettings.isSelected()) {
            SystemProxySelector systemProxySelector = new SystemProxySelector();
            if (!systemProxySelector.equals(defaultProxySelector)) {
                ProxySelector.setDefault(systemProxySelector);
            }
        } else if (this.jrbManualProxyConfig.isSelected()) {
            ManualProxySelector manualProxySelector;
            String httpHost = this.jtfHttpHost.getText().trim();
            String httpPortStr = this.jtfHttpPort.getText().trim();
            String httpsHost = this.jtfHttpsHost.getText().trim();
            String httpsPortStr = this.jtfHttpsPort.getText().trim();
            String socksHost = this.jtfSocksHost.getText().trim();
            String socksPortStr = this.jtfSocksPort.getText().trim();
            ProxyAddress httpProxyAddress = null;
            ProxyAddress httpsProxyAddress = null;
            ProxyAddress socksProxyAddress = null;
            if (httpHost.length() == 0 && httpsHost.length() == 0 && socksHost.length() == 0) {
                this.jtpPreferences.setSelectedIndex(3);
                JOptionPane.showMessageDialog(this, res.getString("DPreferences.ManualConfigReq.message"), this.getTitle(), 2);
                return false;
            }
            if (httpHost.length() > 0) {
                if (httpPortStr.length() == 0) {
                    this.jtpPreferences.setSelectedIndex(3);
                    JOptionPane.showMessageDialog(this, res.getString("DPreferences.PortReqHttp.message"), this.getTitle(), 2);
                    return false;
                }
                try {
                    int httpPort = Integer.parseInt(httpPortStr);
                    if (httpPort < 1) {
                        throw new NumberFormatException();
                    }
                    httpProxyAddress = new ProxyAddress(httpHost, httpPort);
                }
                catch (NumberFormatException ex) {
                    this.jtpPreferences.setSelectedIndex(3);
                    JOptionPane.showMessageDialog(this, res.getString("DPreferences.IntegerPortReqHttp.message"), this.getTitle(), 2);
                    return false;
                }
            }
            if (httpsHost.length() > 0) {
                if (httpsPortStr.length() == 0) {
                    this.jtpPreferences.setSelectedIndex(3);
                    JOptionPane.showMessageDialog(this, res.getString("DPreferences.PortReqHttps.message"), this.getTitle(), 2);
                    return false;
                }
                try {
                    int httpsPort = Integer.parseInt(httpsPortStr);
                    if (httpsPort < 1) {
                        throw new NumberFormatException();
                    }
                    httpsProxyAddress = new ProxyAddress(httpsHost, httpsPort);
                }
                catch (NumberFormatException ex) {
                    this.jtpPreferences.setSelectedIndex(3);
                    JOptionPane.showMessageDialog(this, res.getString("DPreferences.IntegerPortReqHttps.message"), this.getTitle(), 2);
                    return false;
                }
            }
            if (socksHost.length() > 0) {
                if (socksPortStr.length() == 0) {
                    this.jtpPreferences.setSelectedIndex(3);
                    JOptionPane.showMessageDialog(this, res.getString("DPreferences.PortReqSocks.message"), this.getTitle(), 2);
                    return false;
                }
                try {
                    int socksPort = Integer.parseInt(socksPortStr);
                    if (socksPort < 1) {
                        throw new NumberFormatException();
                    }
                    socksProxyAddress = new ProxyAddress(socksHost, socksPort);
                }
                catch (NumberFormatException ex) {
                    this.jtpPreferences.setSelectedIndex(3);
                    JOptionPane.showMessageDialog(this, res.getString("DPreferences.IntegerPortReqSocks.message"), this.getTitle(), 2);
                    return false;
                }
            }
            if (!(manualProxySelector = new ManualProxySelector(httpProxyAddress, httpsProxyAddress, null, socksProxyAddress)).equals(defaultProxySelector)) {
                ProxySelector.setDefault(manualProxySelector);
            }
        } else if (this.jrbAutomaticProxyConfig.isSelected()) {
            String pacUrl = this.jtfPacUrl.getText().trim();
            if (pacUrl.length() == 0) {
                this.jtpPreferences.setSelectedIndex(3);
                JOptionPane.showMessageDialog(this, res.getString("DPreferences.PacUrlReq.message"), this.getTitle(), 2);
                return false;
            }
            PacProxySelector pacProxySelector = new PacProxySelector(pacUrl);
            if (!pacProxySelector.equals(defaultProxySelector)) {
                ProxySelector.setDefault(pacProxySelector);
            }
        }
        return true;
    }

    public boolean getUseCaCertificates() {
        return this.useCaCertificates;
    }

    public File getCaCertificatesFile() {
        return this.caCertificatesFile;
    }

    public boolean getUseWinTrustRootCertificates() {
        return this.useWinTrustRootCertificates;
    }

    public boolean getEnableImportTrustedCertTrustCheck() {
        return this.enableImportTrustedCertTrustCheck;
    }

    public boolean getEnableImportCaReplyTrustCheck() {
        return this.enableImportCaReplyTrustCheck;
    }

    public PasswordQualityConfig getPasswordQualityConfig() {
        return this.passwordQualityConfig;
    }

    public UIManager.LookAndFeelInfo getLookFeelInfo() {
        return this.lookFeelInfo;
    }

    public boolean getLookFeelDecoration() {
        return this.lookFeelDecorated;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isAutoUpdateChecksEnabled() {
        return this.autoUpdateChecksEnabled;
    }

    public int getAutoUpdateChecksInterval() {
        return this.autoUpdateChecksInterval;
    }

    public String getDefaultDN() {
        return this.defaultDN;
    }

    public KeyStoreTableColumns getColumns() {
        return this.kstColumns;
    }

    public boolean columnsChanged() {
        return this.bColumnsChanged;
    }

    private void storeColumns() {
        int ist = this.kstColumns.getColumns();
        this.bEnableEntryName = this.jcbEnableEntryName.isSelected();
        this.bEnableAlgorithm = this.jcbEnableAlgorithm.isSelected();
        this.bEnableKeySize = this.jcbEnableKeySize.isSelected();
        this.bEnableCertificateExpiry = this.jcbEnableCertificateExpiry.isSelected();
        this.bEnableLastModified = this.jcbEnableLastModified.isSelected();
        this.bEnableCurve = this.jcbEnableCurve.isSelected();
        this.bEnableSKI = this.jcbEnableSKI.isSelected();
        this.bEnableAKI = this.jcbEnableAKI.isSelected();
        this.bEnableIssuerDN = this.jcbEnableIssuerDN.isSelected();
        this.bEnableSubjectDN = this.jcbEnableSubjectDN.isSelected();
        this.bEnableIssuerCN = this.jcbEnableIssuerCN.isSelected();
        this.bEnableSubjectCN = this.jcbEnableSubjectCN.isSelected();
        this.bEnableIssuerO = this.jcbEnableIssuerO.isSelected();
        this.bEnableSubjectO = this.jcbEnableSubjectO.isSelected();
        try {
            this.expiryWarnDays = Integer.parseInt(this.jtfExpirationWarnDays.getText());
        }
        catch (Exception e) {
            this.expiryWarnDays = 0;
        }
        this.kstColumns.setColumns(this.bEnableEntryName, this.bEnableAlgorithm, this.bEnableKeySize, this.bEnableCertificateExpiry, this.bEnableLastModified, this.bEnableSKI, this.bEnableAKI, this.bEnableIssuerDN, this.bEnableSubjectDN, this.bEnableIssuerCN, this.bEnableSubjectCN, this.bEnableIssuerO, this.bEnableSubjectO, this.bEnableCurve, this.expiryWarnDays);
        this.bColumnsChanged = this.kstColumns.getColumns() != ist;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    private void browsePressed() {
        JFileChooser chooser = FileChooserFactory.getKeyStoreFileChooser();
        if (this.caCertificatesFile.getParentFile() != null && this.caCertificatesFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(this.caCertificatesFile.getParentFile());
        } else {
            chooser.setCurrentDirectory(CurrentDirectory.get());
        }
        chooser.setDialogTitle(res.getString("DPreferences.ChooseCACertificatesKeyStore.Title"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonText(res.getString("DPreferences.CaCertificatesKeyStoreFileChooser.button"));
        int rtnValue = chooser.showOpenDialog(this);
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            this.jtfCaCertificatesFile.setText(chosenFile.toString());
            this.jtfCaCertificatesFile.setCaretPosition(0);
        }
    }

    private void okPressed() {
        if (this.storePreferences()) {
            this.closeDialog();
        }
    }

    private void cancelPressed() {
        this.cancelled = true;
        this.bColumnsChanged = false;
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        DPreferences dialog = new DPreferences(new JFrame(), true, new File(""), true, true, true, new PasswordQualityConfig(true, true, 100), "", "en", true, 14, new KeyStoreTableColumns());
        DialogViewer.run(dialog);
    }

    private static class LanguageItem {
        private String displayName;
        private String isoCode;

        public LanguageItem(String displayName, String isoCode) {
            this.displayName = displayName;
            this.isoCode = isoCode;
        }

        public String getIsoCode() {
            return this.isoCode;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

