/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.kse.crypto.csr.spkac.Spkac;
import org.kse.crypto.x509.X509Ext;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscFrame;
import org.kse.gui.LnfUtil;
import org.kse.gui.PlatformUtil;
import org.kse.utilities.asn1.Asn1Dump;
import org.kse.utilities.asn1.Asn1Exception;

public class DViewAsn1Dump
extends JEscFrame {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private JPanel jpButtons;
    private JButton jbCopy;
    private JButton jbOK;
    private JPanel jpAsn1Dump;
    private JScrollPane jspAsn1Dump;
    private JTextArea jtaAsn1Dump;
    private X509Certificate certificate;
    private X509CRL crl;
    private X509Ext extension;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private PKCS10CertificationRequest pkcs10Csr;
    private Spkac spkac;

    public DViewAsn1Dump(JDialog parent, X509Certificate cert) throws Asn1Exception, IOException {
        super(res.getString("DViewAsn1Dump.Certificate.Title"));
        this.certificate = cert;
        this.initComponents();
    }

    public DViewAsn1Dump(JDialog parent, X509CRL crl) throws Asn1Exception, IOException {
        super(res.getString("DViewAsn1Dump.Crl.Title"));
        this.crl = crl;
        this.initComponents();
    }

    public DViewAsn1Dump(JDialog parent, X509Ext extension) throws Asn1Exception, IOException {
        super(res.getString("DViewAsn1Dump.Extension.Title"));
        this.extension = extension;
        this.initComponents();
    }

    public DViewAsn1Dump(JDialog parent, PrivateKey privateKey) throws Asn1Exception, IOException {
        super(res.getString("DViewAsn1Dump.PrivateKey.Title"));
        this.privateKey = privateKey;
        this.initComponents();
    }

    public DViewAsn1Dump(JDialog parent, PublicKey publicKey) throws Asn1Exception, IOException {
        super(res.getString("DViewAsn1Dump.PublicKey.Title"));
        this.publicKey = publicKey;
        this.initComponents();
    }

    public DViewAsn1Dump(JDialog parent, PKCS10CertificationRequest pkcs10Csr) throws Asn1Exception, IOException {
        super(res.getString("DViewAsn1Dump.Csr.Title"));
        this.pkcs10Csr = pkcs10Csr;
        this.initComponents();
    }

    public DViewAsn1Dump(JDialog parent, Spkac spkac) throws Asn1Exception, IOException {
        super(res.getString("DViewAsn1Dump.Csr.Title"));
        this.spkac = spkac;
        this.initComponents();
    }

    private void initComponents() throws Asn1Exception, IOException {
        this.jbCopy = new JButton(res.getString("DViewAsn1Dump.jbCopy.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbCopy, res.getString("DViewAsn1Dump.jbCopy.mnemonic").charAt(0));
        this.jbCopy.setToolTipText(res.getString("DViewAsn1Dump.jbCopy.tooltip"));
        this.jbCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewAsn1Dump.this);
                    DViewAsn1Dump.this.copyPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewAsn1Dump.this);
                }
            }
        });
        this.jbOK = new JButton(res.getString("DViewAsn1Dump.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DViewAsn1Dump.this.okPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, null, this.jbCopy);
        this.jpAsn1Dump = new JPanel(new BorderLayout());
        this.jpAsn1Dump.setBorder(new EmptyBorder(5, 5, 5, 5));
        Asn1Dump asn1Dump = new Asn1Dump();
        this.jtaAsn1Dump = this.certificate != null ? new JTextArea(asn1Dump.dump(this.certificate)) : (this.crl != null ? new JTextArea(asn1Dump.dump(this.crl)) : (this.extension != null ? new JTextArea(asn1Dump.dump(this.extension)) : (this.privateKey != null ? new JTextArea(asn1Dump.dump(this.privateKey)) : (this.publicKey != null ? new JTextArea(asn1Dump.dump(this.publicKey)) : (this.pkcs10Csr != null ? new JTextArea(asn1Dump.dump(this.pkcs10Csr.getEncoded())) : new JTextArea(asn1Dump.dump(this.spkac.getEncoded())))))));
        this.jtaAsn1Dump.setCaretPosition(0);
        this.jtaAsn1Dump.setEditable(false);
        this.jtaAsn1Dump.setFont(new Font("Monospaced", 0, LnfUtil.getDefaultFontSize()));
        this.jtaAsn1Dump.putClientProperty("JTextArea.infoBackground", Boolean.TRUE);
        this.jspAsn1Dump = PlatformUtil.createScrollPane(this.jtaAsn1Dump, 22, 32);
        this.jspAsn1Dump.setPreferredSize(new Dimension(500, 300));
        this.jpAsn1Dump.add((Component)this.jspAsn1Dump, "Center");
        this.getContentPane().add((Component)this.jpAsn1Dump, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DViewAsn1Dump.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DViewAsn1Dump.this.jbOK.requestFocus();
            }
        });
    }

    private void copyPressed() {
        String policy = this.jtaAsn1Dump.getText();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection copy = new StringSelection(policy);
        clipboard.setContents(copy, copy);
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

