/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigInteger;
import java.security.Key;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.LnfUtil;
import org.kse.gui.PlatformUtil;

public class DViewAsymmetricKeyFields
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private JPanel jpFields;
    private JPanel jpFieldsList;
    private JLabel jlFields;
    private JList<Field> jltFields;
    private JPanel jpFieldValue;
    private JLabel jlFieldValue;
    private JPanel jpFieldValueTextArea;
    private JScrollPane jspFieldValue;
    private JTextArea jtaFieldValue;
    private JPanel jpOK;
    private JButton jbOK;
    private Key key;

    public DViewAsymmetricKeyFields(JDialog parent, String title, RSAPublicKey rsaPublicKey) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.key = rsaPublicKey;
        this.initFields();
    }

    public DViewAsymmetricKeyFields(JDialog parent, String title, DSAPublicKey dsaPublicKey) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.key = dsaPublicKey;
        this.initFields();
    }

    public DViewAsymmetricKeyFields(JDialog parent, String title, RSAPrivateKey rsaPrivateKey) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.key = rsaPrivateKey;
        this.initFields();
    }

    public DViewAsymmetricKeyFields(JDialog parent, String title, DSAPrivateKey dsaPrivateKey) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.key = dsaPrivateKey;
        this.initFields();
    }

    private void initFields() {
        this.jlFields = new JLabel(res.getString("DViewAsymmetricKeyFields.jlFields.text"));
        this.jltFields = new JList();
        this.jltFields.setToolTipText(res.getString("DViewAsymmetricKeyFields.jltFields.tooltip"));
        this.jltFields.setSelectionMode(0);
        this.jltFields.setBorder(new EtchedBorder());
        this.jltFields.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewAsymmetricKeyFields.this);
                    DViewAsymmetricKeyFields.this.updateFieldValue();
                }
                finally {
                    CursorUtil.setCursorFree(DViewAsymmetricKeyFields.this);
                }
            }
        });
        this.jpFieldsList = new JPanel(new BorderLayout(5, 5));
        this.jpFieldsList.add((Component)this.jlFields, "North");
        this.jpFieldsList.add(this.jltFields, "Center");
        this.jpFieldValue = new JPanel(new BorderLayout(5, 5));
        this.jlFieldValue = new JLabel(res.getString("DViewAsymmetricKeyFields.jlFieldValue.text"));
        this.jpFieldValue.add((Component)this.jlFieldValue, "North");
        this.jtaFieldValue = new JTextArea();
        this.jtaFieldValue.setFont(new Font("Monospaced", 0, LnfUtil.getDefaultFontSize()));
        this.jtaFieldValue.setEditable(false);
        this.jtaFieldValue.setToolTipText(res.getString("DViewAsymmetricKeyFields.jtaFieldValue.tooltip"));
        this.jtaFieldValue.putClientProperty("JTextArea.infoBackground", Boolean.TRUE);
        this.jspFieldValue = PlatformUtil.createScrollPane(this.jtaFieldValue, 20, 30);
        this.jpFieldValueTextArea = new JPanel(new BorderLayout(10, 10));
        this.jpFieldValueTextArea.setPreferredSize(new Dimension(275, 200));
        this.jpFieldValueTextArea.add((Component)this.jspFieldValue, "Center");
        this.jpFieldValue.add((Component)this.jpFieldValueTextArea, "Center");
        this.jpFields = new JPanel(new BorderLayout(5, 5));
        this.jpFields.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpFields.add((Component)this.jpFieldsList, "West");
        this.jpFields.add((Component)this.jpFieldValue, "Center");
        this.jbOK = new JButton(res.getString("DViewAsymmetricKeyFields.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DViewAsymmetricKeyFields.this.okPressed();
            }
        });
        this.jpOK = PlatformUtil.createDialogButtonPanel(this.jbOK);
        this.populateFields();
        this.getContentPane().add((Component)this.jpFields, "Center");
        this.getContentPane().add((Component)this.jpOK, "South");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DViewAsymmetricKeyFields.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DViewAsymmetricKeyFields.this.jbOK.requestFocus();
            }
        });
    }

    private void populateFields() {
        Field[] fields = null;
        if (this.key instanceof RSAPublicKey) {
            RSAPublicKey rsaPub = (RSAPublicKey)this.key;
            fields = new Field[]{new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PubRsaPublicExponent.text"), rsaPub.getPublicExponent()), new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PubRsaModulus.text"), rsaPub.getModulus())};
        } else if (this.key instanceof DSAPublicKey) {
            DSAPublicKey dsaPub = (DSAPublicKey)this.key;
            DSAParams dsaParams = dsaPub.getParams();
            fields = new Field[]{new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PubDsaPrimeModulusP.text"), dsaParams.getP()), new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PubDsaPrimeQ.text"), dsaParams.getQ()), new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PubDsaGeneratorG.text"), dsaParams.getG()), new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PubDsaPublicKeyY.text"), dsaPub.getY())};
        } else if (this.key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsaPvk = (RSAPrivateCrtKey)this.key;
            fields = new Field[]{new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PrivRsaPublicExponent.text"), rsaPvk.getPublicExponent()), new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PrivRsaModulus.text"), rsaPvk.getModulus()), new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PrivRsaPrimeP.text"), rsaPvk.getPrimeP()), new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PrivRsaPrimeQ.text"), rsaPvk.getPrimeQ()), new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PrivRsaPrimeExponentP.text"), rsaPvk.getPrimeExponentP()), new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PrivRsaPrimeExponentQ.text"), rsaPvk.getPrimeExponentQ()), new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PrivRsaCrtCoefficient.text"), rsaPvk.getCrtCoefficient()), new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PrivRsaPrivateExponent.text"), rsaPvk.getPrivateExponent())};
        } else if (this.key instanceof RSAPrivateKey) {
            RSAPrivateKey rsaPvk = (RSAPrivateKey)this.key;
            fields = new Field[]{new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PrivRsaModulus.text"), rsaPvk.getModulus()), new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PrivRsaPrivateExponent.text"), rsaPvk.getPrivateExponent())};
        } else if (this.key instanceof DSAPrivateKey) {
            DSAPrivateKey dsaPvk = (DSAPrivateKey)this.key;
            DSAParams dsaParams = dsaPvk.getParams();
            fields = new Field[]{new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PrivDsaPrimeModulusP.text"), dsaParams.getP()), new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PrivDsaPrimeQ.text"), dsaParams.getQ()), new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PrivDsaGeneratorG.text"), dsaParams.getG()), new Field(res.getString("DViewAsymmetricKeyFields.jltFields.PrivDsaSecretExponentX.text"), dsaPvk.getX())};
        }
        if (fields != null) {
            this.jltFields.setListData(fields);
            this.jltFields.setSelectedIndex(0);
        }
    }

    private void updateFieldValue() {
        int selectedRow = this.jltFields.getSelectedIndex();
        if (selectedRow == -1) {
            this.jtaFieldValue.setText("");
        } else {
            Field field = this.jltFields.getSelectedValue();
            this.jtaFieldValue.setText(field.getFormattedValue());
            this.jtaFieldValue.setCaretPosition(0);
        }
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private class Field {
        private static final int FORMATTED_FIELD_LINE_MAX_LENGTH = 32;
        private String name;
        private BigInteger value;

        public Field(String name, BigInteger value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public BigInteger getValue() {
            return this.value;
        }

        public String getFormattedValue() {
            String value = "0x" + this.getValue().toString(16).toUpperCase();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < value.length(); ++i) {
                sb.append(value.charAt(i));
                if ((i + 1) % 32 != 0) continue;
                sb.append('\n');
            }
            return sb.toString();
        }

        public String toString() {
            return this.getName();
        }
    }
}

