/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.JKeyIdentifier;
import org.kse.gui.crypto.generalname.JGeneralNames;
import org.kse.gui.dialogs.extensions.DExtension;
import org.kse.gui.error.DError;

public class DAuthorityKeyIdentifier
extends DExtension {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpAuthorityKeyIdentifier;
    private JLabel jlKeyIdentifier;
    private JKeyIdentifier jkiKeyIdentifier;
    private JLabel jlAuthorityCertIssuer;
    private JGeneralNames jgnAuthorityCertIssuer;
    private JLabel jlAuthorityCertSerialNumber;
    private JTextField jtfAuthorityCertSerialNumber;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private byte[] value;
    private PublicKey authorityPublicKey;

    public DAuthorityKeyIdentifier(JDialog parent, PublicKey authorityPublicKey, X500Name authorityCertName, BigInteger authorityCertSerialNumber) {
        super(parent);
        this.setTitle(res.getString("DAuthorityKeyIdentifier.Title"));
        this.authorityPublicKey = authorityPublicKey;
        this.initComponents();
        this.prepopulateWithAuthorityCertDetails(authorityCertName, authorityCertSerialNumber);
    }

    public DAuthorityKeyIdentifier(JDialog parent, byte[] value, PublicKey authorityPublicKey) throws IOException {
        super(parent);
        this.setTitle(res.getString("DAuthorityKeyIdentifier.Title"));
        this.authorityPublicKey = authorityPublicKey;
        this.initComponents();
        this.prepopulateWithValue(value);
    }

    private void initComponents() {
        this.jlKeyIdentifier = new JLabel(res.getString("DAuthorityKeyIdentifier.jlKeyIdentifer.text"));
        GridBagConstraints gbc_jlKeyIdentifier = new GridBagConstraints();
        gbc_jlKeyIdentifier.gridx = 0;
        gbc_jlKeyIdentifier.gridy = 0;
        gbc_jlKeyIdentifier.gridwidth = 1;
        gbc_jlKeyIdentifier.gridheight = 1;
        gbc_jlKeyIdentifier.insets = new Insets(5, 5, 5, 5);
        gbc_jlKeyIdentifier.anchor = 13;
        this.jkiKeyIdentifier = new JKeyIdentifier(res.getString("DAuthorityKeyIdentifier.KeyIdentifier.Title"), this.authorityPublicKey);
        GridBagConstraints gbc_jkiKeyIdentifier = new GridBagConstraints();
        gbc_jkiKeyIdentifier.gridx = 1;
        gbc_jkiKeyIdentifier.gridy = 0;
        gbc_jkiKeyIdentifier.gridwidth = 1;
        gbc_jkiKeyIdentifier.gridheight = 1;
        gbc_jkiKeyIdentifier.insets = new Insets(5, 5, 5, 5);
        gbc_jkiKeyIdentifier.anchor = 17;
        this.jlAuthorityCertIssuer = new JLabel(res.getString("DAuthorityKeyIdentifier.jlAuthorityCertIssuer.text"));
        GridBagConstraints gbc_jlAuthorityCertIssuer = new GridBagConstraints();
        gbc_jlAuthorityCertIssuer.gridx = 0;
        gbc_jlAuthorityCertIssuer.gridy = 1;
        gbc_jlAuthorityCertIssuer.gridwidth = 1;
        gbc_jlAuthorityCertIssuer.gridheight = 1;
        gbc_jlAuthorityCertIssuer.insets = new Insets(0, 5, 0, 5);
        gbc_jlAuthorityCertIssuer.anchor = 12;
        this.jgnAuthorityCertIssuer = new JGeneralNames(res.getString("DAuthorityKeyIdentifier.AuthorityCertIssuer.Title"));
        this.jgnAuthorityCertIssuer.setPreferredSize(new Dimension(400, 150));
        GridBagConstraints gbc_jgnAuthorityCertIssuer = new GridBagConstraints();
        gbc_jgnAuthorityCertIssuer.gridx = 1;
        gbc_jgnAuthorityCertIssuer.gridy = 1;
        gbc_jgnAuthorityCertIssuer.gridwidth = 1;
        gbc_jgnAuthorityCertIssuer.gridheight = 1;
        gbc_jgnAuthorityCertIssuer.insets = new Insets(0, 5, 0, 5);
        gbc_jgnAuthorityCertIssuer.anchor = 17;
        this.jlAuthorityCertSerialNumber = new JLabel(res.getString("DAuthorityKeyIdentifier.jlAuthorityCertSerialNumber.text"));
        GridBagConstraints gbc_jlAuthorityCertSerialNumber = new GridBagConstraints();
        gbc_jlAuthorityCertSerialNumber.gridx = 0;
        gbc_jlAuthorityCertSerialNumber.gridy = 2;
        gbc_jlAuthorityCertSerialNumber.gridwidth = 1;
        gbc_jlAuthorityCertSerialNumber.gridheight = 1;
        gbc_jlAuthorityCertSerialNumber.insets = new Insets(5, 5, 5, 5);
        gbc_jlAuthorityCertSerialNumber.anchor = 13;
        this.jtfAuthorityCertSerialNumber = new JTextField(20);
        GridBagConstraints gbc_jtfAuthorityCertSerialNumber = new GridBagConstraints();
        gbc_jtfAuthorityCertSerialNumber.gridx = 1;
        gbc_jtfAuthorityCertSerialNumber.gridy = 2;
        gbc_jtfAuthorityCertSerialNumber.gridwidth = 1;
        gbc_jtfAuthorityCertSerialNumber.gridheight = 1;
        gbc_jtfAuthorityCertSerialNumber.insets = new Insets(5, 5, 5, 5);
        gbc_jtfAuthorityCertSerialNumber.anchor = 17;
        this.jpAuthorityKeyIdentifier = new JPanel(new GridBagLayout());
        this.jpAuthorityKeyIdentifier.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()));
        this.jpAuthorityKeyIdentifier.add((Component)this.jlKeyIdentifier, gbc_jlKeyIdentifier);
        this.jpAuthorityKeyIdentifier.add((Component)this.jkiKeyIdentifier, gbc_jkiKeyIdentifier);
        this.jpAuthorityKeyIdentifier.add((Component)this.jlAuthorityCertIssuer, gbc_jlAuthorityCertIssuer);
        this.jpAuthorityKeyIdentifier.add((Component)this.jgnAuthorityCertIssuer, gbc_jgnAuthorityCertIssuer);
        this.jpAuthorityKeyIdentifier.add((Component)this.jlAuthorityCertSerialNumber, gbc_jlAuthorityCertSerialNumber);
        this.jpAuthorityKeyIdentifier.add((Component)this.jtfAuthorityCertSerialNumber, gbc_jtfAuthorityCertSerialNumber);
        this.jbOK = new JButton(res.getString("DAuthorityKeyIdentifier.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAuthorityKeyIdentifier.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DAuthorityKeyIdentifier.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAuthorityKeyIdentifier.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAuthorityKeyIdentifier.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpAuthorityKeyIdentifier, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DAuthorityKeyIdentifier.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void prepopulateWithAuthorityCertDetails(X500Name authorityCertName, BigInteger authorityCertSerialNumber) {
        if (authorityCertName != null) {
            try {
                GeneralName generalName = new GeneralName(4, (ASN1Encodable)authorityCertName);
                GeneralNames generalNames = new GeneralNames(generalName);
                this.jgnAuthorityCertIssuer.setGeneralNames(generalNames);
            }
            catch (Exception e) {
                DError.displayError(this, (Throwable)e);
                return;
            }
        }
        if (authorityCertSerialNumber != null) {
            this.jtfAuthorityCertSerialNumber.setText("" + authorityCertSerialNumber.toString());
            this.jtfAuthorityCertSerialNumber.setCaretPosition(0);
        }
    }

    private void prepopulateWithValue(byte[] value) throws IOException {
        BigInteger authorityCertSerialNumber;
        GeneralNames authorityCertIssuer;
        AuthorityKeyIdentifier authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance((Object)value);
        if (authorityKeyIdentifier.getKeyIdentifier() != null) {
            this.jkiKeyIdentifier.setKeyIdentifier(authorityKeyIdentifier.getKeyIdentifier());
        }
        if ((authorityCertIssuer = authorityKeyIdentifier.getAuthorityCertIssuer()) != null) {
            this.jgnAuthorityCertIssuer.setGeneralNames(authorityCertIssuer);
        }
        if ((authorityCertSerialNumber = authorityKeyIdentifier.getAuthorityCertSerialNumber()) != null) {
            this.jtfAuthorityCertSerialNumber.setText("" + authorityCertSerialNumber.longValue());
            this.jtfAuthorityCertSerialNumber.setCaretPosition(0);
        }
    }

    private void okPressed() {
        byte[] keyIdentifier = this.jkiKeyIdentifier.getKeyIdentifier();
        GeneralNames authorityCertIssuer = this.jgnAuthorityCertIssuer.getGeneralNames();
        BigInteger authorityCertSerialNumber = null;
        String authorityCertSerialNumberStr = this.jtfAuthorityCertSerialNumber.getText().trim();
        if (authorityCertSerialNumberStr.length() != 0) {
            try {
                authorityCertSerialNumber = new BigInteger(authorityCertSerialNumberStr);
                if (authorityCertSerialNumber.compareTo(BigInteger.ONE) < 0) {
                    JOptionPane.showMessageDialog(this, res.getString("DAuthorityKeyIdentifier.AuthorityCertSerialNumberNonZero.message"), this.getTitle(), 2);
                    return;
                }
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, res.getString("DAuthorityKeyIdentifier.AuthorityCertSerialNumberNotInteger.message"), this.getTitle(), 2);
                return;
            }
        }
        if (keyIdentifier == null && (authorityCertIssuer.getNames().length == 0 || authorityCertSerialNumber == null)) {
            JOptionPane.showMessageDialog(this, res.getString("DAuthorityKeyIdentifier.ValueReq.message"), this.getTitle(), 2);
            return;
        }
        AuthorityKeyIdentifier authorityKeyIdentifier = keyIdentifier != null && authorityCertSerialNumber == null ? new AuthorityKeyIdentifier(keyIdentifier) : (keyIdentifier == null ? new AuthorityKeyIdentifier(authorityCertIssuer, authorityCertSerialNumber) : new AuthorityKeyIdentifier(keyIdentifier, authorityCertIssuer, authorityCertSerialNumber));
        try {
            this.value = authorityKeyIdentifier.getEncoded("DER");
        }
        catch (IOException e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.closeDialog();
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

