/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.DERIA5String;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dialogs.extensions.DExtension;
import org.kse.gui.error.DError;

public class DNetscapeCaPolicyUrl
extends DExtension {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpNetscapeCaPolicyUrl;
    private JLabel jlNetscapeCaPolicyUrl;
    private JTextField jtfNetscapeCaPolicyUrl;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private byte[] value;

    public DNetscapeCaPolicyUrl(JDialog parent) {
        super(parent);
        this.setTitle(res.getString("DNetscapeCaPolicyUrl.Title"));
        this.initComponents();
    }

    public DNetscapeCaPolicyUrl(JDialog parent, byte[] value) throws IOException {
        super(parent);
        this.setTitle(res.getString("DNetscapeCaPolicyUrl.Title"));
        this.initComponents();
        this.prepopulateWithValue(value);
    }

    private void initComponents() {
        this.jlNetscapeCaPolicyUrl = new JLabel(res.getString("DNetscapeCaPolicyUrl.jlNetscapeCaPolicyUrl.text"));
        this.jtfNetscapeCaPolicyUrl = new JTextField(40);
        this.jpNetscapeCaPolicyUrl = new JPanel(new BorderLayout(5, 5));
        this.jpNetscapeCaPolicyUrl.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpNetscapeCaPolicyUrl.add((Component)this.jlNetscapeCaPolicyUrl, "North");
        this.jpNetscapeCaPolicyUrl.add((Component)this.jtfNetscapeCaPolicyUrl, "Center");
        this.jbOK = new JButton(res.getString("DNetscapeCaPolicyUrl.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DNetscapeCaPolicyUrl.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DNetscapeCaPolicyUrl.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DNetscapeCaPolicyUrl.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DNetscapeCaPolicyUrl.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpNetscapeCaPolicyUrl, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DNetscapeCaPolicyUrl.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void prepopulateWithValue(byte[] value) throws IOException {
        DERIA5String netscapeCaPolicyUrl = DERIA5String.getInstance((Object)value);
        this.jtfNetscapeCaPolicyUrl.setText(netscapeCaPolicyUrl.getString());
        this.jtfNetscapeCaPolicyUrl.setCaretPosition(0);
    }

    private void okPressed() {
        String netscapeCaPolicyUrlStr = this.jtfNetscapeCaPolicyUrl.getText().trim();
        if (netscapeCaPolicyUrlStr.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DNetscapeCaPolicyUrl.ValueReq.message"), this.getTitle(), 2);
            return;
        }
        DERIA5String netscapeCaPolicyUrl = new DERIA5String(netscapeCaPolicyUrlStr);
        try {
            this.value = netscapeCaPolicyUrl.getEncoded("DER");
        }
        catch (IOException e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.closeDialog();
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

