/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.misc.NetscapeCertType;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dialogs.extensions.DExtension;
import org.kse.gui.error.DError;

public class DNetscapeCertificateType
extends DExtension {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpNetscapeCertificateType;
    private JLabel jlNetscapeCertificateType;
    private JPanel jpNetscapeCertificateTypes;
    private JCheckBox jcbObjectSigning;
    private JCheckBox jcbObjectSigningCa;
    private JCheckBox jcbReserved;
    private JCheckBox jcbSmime;
    private JCheckBox jcbSmimeCa;
    private JCheckBox jcbSslCa;
    private JCheckBox jcbSslClient;
    private JCheckBox jcbSslServer;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private byte[] value;

    public DNetscapeCertificateType(JDialog parent) {
        super(parent);
        this.setTitle(res.getString("DNetscapeCertificateType.Title"));
        this.initComponents();
    }

    public DNetscapeCertificateType(JDialog parent, byte[] value) throws IOException {
        super(parent);
        this.setTitle(res.getString("DNetscapeCertificateType.Title"));
        this.initComponents();
        this.prepopulateWithValue(value);
    }

    private void initComponents() {
        this.jlNetscapeCertificateType = new JLabel(res.getString("DNetscapeCertificateType.jlNetscapeCertificateType.text"));
        this.jlNetscapeCertificateType.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.jcbObjectSigning = new JCheckBox(res.getString("DNetscapeCertificateType.jcbObjectSigning.text"));
        this.jcbObjectSigningCa = new JCheckBox(res.getString("DNetscapeCertificateType.jcbObjectSigningCa.text"));
        this.jcbReserved = new JCheckBox(res.getString("DNetscapeCertificateType.jcbReserved.text"));
        this.jcbSmime = new JCheckBox(res.getString("DNetscapeCertificateType.jcbSmime.text"));
        this.jcbSmimeCa = new JCheckBox(res.getString("DNetscapeCertificateType.jcbSmimeCa.text"));
        this.jcbSslCa = new JCheckBox(res.getString("DNetscapeCertificateType.jcbSslCa.text"));
        this.jcbSslClient = new JCheckBox(res.getString("DNetscapeCertificateType.jcbSslClient.text"));
        this.jcbSslServer = new JCheckBox(res.getString("DNetscapeCertificateType.jcbSslServer.text"));
        JPanel jpFirstColumn = new JPanel();
        jpFirstColumn.setLayout(new BoxLayout(jpFirstColumn, 1));
        jpFirstColumn.add(this.jcbObjectSigning);
        jpFirstColumn.add(this.jcbObjectSigningCa);
        jpFirstColumn.add(this.jcbReserved);
        JPanel jpSecondColumn = new JPanel();
        jpSecondColumn.setLayout(new BoxLayout(jpSecondColumn, 1));
        jpSecondColumn.add(this.jcbSmime);
        jpSecondColumn.add(this.jcbSmimeCa);
        jpSecondColumn.add(this.jcbSslCa);
        JPanel jpThirdColumn = new JPanel();
        jpThirdColumn.setLayout(new BoxLayout(jpThirdColumn, 1));
        jpThirdColumn.add(this.jcbSslClient);
        jpThirdColumn.add(this.jcbSslServer);
        jpThirdColumn.add(Box.createVerticalGlue());
        this.jpNetscapeCertificateTypes = new JPanel();
        this.jpNetscapeCertificateTypes.setLayout(new BoxLayout(this.jpNetscapeCertificateTypes, 0));
        this.jpNetscapeCertificateTypes.add(jpFirstColumn);
        this.jpNetscapeCertificateTypes.add(jpSecondColumn);
        this.jpNetscapeCertificateTypes.add(jpThirdColumn);
        this.jpNetscapeCertificateType = new JPanel(new BorderLayout(5, 5));
        this.jpNetscapeCertificateType.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpNetscapeCertificateType.add((Component)this.jlNetscapeCertificateType, "North");
        this.jpNetscapeCertificateType.add((Component)this.jpNetscapeCertificateTypes, "Center");
        this.jbOK = new JButton(res.getString("DNetscapeCertificateType.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DNetscapeCertificateType.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DNetscapeCertificateType.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DNetscapeCertificateType.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DNetscapeCertificateType.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpNetscapeCertificateType, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DNetscapeCertificateType.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void prepopulateWithValue(byte[] value) throws IOException {
        try (ASN1InputStream asn1InputStream = new ASN1InputStream(value);){
            DERBitString netscapeCertType = DERBitString.getInstance((Object)asn1InputStream.readObject());
            int netscapeCertTypes = netscapeCertType.intValue();
            this.jcbSslClient.setSelected(this.isCertType(netscapeCertTypes, 128));
            this.jcbSslServer.setSelected(this.isCertType(netscapeCertTypes, 64));
            this.jcbSmime.setSelected(this.isCertType(netscapeCertTypes, 32));
            this.jcbObjectSigning.setSelected(this.isCertType(netscapeCertTypes, 16));
            this.jcbReserved.setSelected(this.isCertType(netscapeCertTypes, 8));
            this.jcbSslCa.setSelected(this.isCertType(netscapeCertTypes, 4));
            this.jcbSmimeCa.setSelected(this.isCertType(netscapeCertTypes, 2));
            this.jcbObjectSigningCa.setSelected(this.isCertType(netscapeCertTypes, 1));
        }
    }

    private boolean isCertType(int netscapeCertTypes, int certType) {
        return (netscapeCertTypes & certType) == certType;
    }

    private void okPressed() {
        if (!(this.jcbSslClient.isSelected() || this.jcbSslServer.isSelected() || this.jcbSmime.isSelected() || this.jcbObjectSigning.isSelected() || this.jcbReserved.isSelected() || this.jcbSslCa.isSelected() || this.jcbSmimeCa.isSelected() || this.jcbObjectSigningCa.isSelected())) {
            JOptionPane.showMessageDialog(this, res.getString("DNetscapeCertificateType.ValueReq.message"), this.getTitle(), 2);
            return;
        }
        int netscapeCertTypeIntValue = 0;
        netscapeCertTypeIntValue |= this.jcbSslClient.isSelected() ? 128 : 0;
        netscapeCertTypeIntValue |= this.jcbSslServer.isSelected() ? 64 : 0;
        netscapeCertTypeIntValue |= this.jcbSmime.isSelected() ? 32 : 0;
        netscapeCertTypeIntValue |= this.jcbObjectSigning.isSelected() ? 16 : 0;
        netscapeCertTypeIntValue |= this.jcbReserved.isSelected() ? 8 : 0;
        netscapeCertTypeIntValue |= this.jcbSslCa.isSelected() ? 4 : 0;
        netscapeCertTypeIntValue |= this.jcbSmimeCa.isSelected() ? 2 : 0;
        NetscapeCertType netscapeCertType = new NetscapeCertType(netscapeCertTypeIntValue |= this.jcbObjectSigningCa.isSelected() ? 1 : 0);
        try {
            this.value = netscapeCertType.getEncoded("DER");
        }
        catch (IOException e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.closeDialog();
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

