/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.DERIA5String;
import org.kse.gui.LnfUtil;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dialogs.extensions.DExtension;
import org.kse.gui.error.DError;

public class DNetscapeComment
extends DExtension {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpNetscapeComment;
    private JLabel jlNetscapeComment;
    private JScrollPane jspNetscapeComment;
    private JTextArea jtaNetscapeComment;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private byte[] value;

    public DNetscapeComment(JDialog parent) {
        super(parent);
        this.setTitle(res.getString("DNetscapeComment.Title"));
        this.initComponents();
    }

    public DNetscapeComment(JDialog parent, byte[] value) throws IOException {
        super(parent);
        this.setTitle(res.getString("DNetscapeComment.Title"));
        this.initComponents();
        this.prepopulateWithValue(value);
    }

    private void initComponents() {
        this.jlNetscapeComment = new JLabel(res.getString("DNetscapeComment.jlNetscapeComment.text"));
        this.jtaNetscapeComment = new JTextArea();
        this.jtaNetscapeComment.setFont(new Font("Monospaced", 0, LnfUtil.getDefaultFontSize()));
        this.jspNetscapeComment = PlatformUtil.createScrollPane(this.jtaNetscapeComment, 22, 32);
        this.jspNetscapeComment.setPreferredSize(new Dimension(300, 200));
        this.jpNetscapeComment = new JPanel(new BorderLayout(5, 5));
        this.jpNetscapeComment.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpNetscapeComment.add((Component)this.jlNetscapeComment, "North");
        this.jpNetscapeComment.add((Component)this.jspNetscapeComment, "Center");
        this.jbOK = new JButton(res.getString("DNetscapeComment.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DNetscapeComment.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DNetscapeComment.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DNetscapeComment.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DNetscapeComment.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpNetscapeComment, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DNetscapeComment.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void prepopulateWithValue(byte[] value) throws IOException {
        DERIA5String netscapeComment = DERIA5String.getInstance((Object)value);
        this.jtaNetscapeComment.setText(netscapeComment.getString());
        this.jtaNetscapeComment.setCaretPosition(0);
    }

    private void okPressed() {
        String netscapeCommentStr = this.jtaNetscapeComment.getText().trim();
        if (netscapeCommentStr.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DNetscapeComment.ValueReq.message"), this.getTitle(), 2);
            return;
        }
        DERIA5String netscapeComment = new DERIA5String(netscapeCommentStr);
        try {
            this.value = netscapeComment.getEncoded("DER");
        }
        catch (IOException e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.closeDialog();
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

