/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.PolicyMappings;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.policymapping.JPolicyMappings;
import org.kse.gui.dialogs.extensions.DExtension;
import org.kse.gui.error.DError;

public class DPolicyMappings
extends DExtension {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpPolicyMappings;
    private JLabel jlPolicyMappings;
    private JPolicyMappings jpmPolicyMappings;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private byte[] value;

    public DPolicyMappings(JDialog parent) {
        super(parent);
        this.setTitle(res.getString("DPolicyMappings.Title"));
        this.initComponents();
    }

    public DPolicyMappings(JDialog parent, byte[] value) throws IOException {
        super(parent);
        this.setTitle(res.getString("DPolicyMappings.Title"));
        this.initComponents();
        this.prepopulateWithValue(value);
    }

    private void initComponents() {
        this.jlPolicyMappings = new JLabel(res.getString("DPolicyMappings.jlPolicyMappings.text"));
        GridBagConstraints gbc_jlPolicyMappings = new GridBagConstraints();
        gbc_jlPolicyMappings.gridx = 0;
        gbc_jlPolicyMappings.gridy = 0;
        gbc_jlPolicyMappings.gridwidth = 1;
        gbc_jlPolicyMappings.gridheight = 1;
        gbc_jlPolicyMappings.insets = new Insets(5, 5, 5, 5);
        gbc_jlPolicyMappings.anchor = 12;
        this.jpmPolicyMappings = new JPolicyMappings(res.getString("DPolicyMappings.PolicyMapping.Title"));
        GridBagConstraints gbc_jadPolicyMappings = new GridBagConstraints();
        gbc_jadPolicyMappings.gridx = 1;
        gbc_jadPolicyMappings.gridy = 0;
        gbc_jadPolicyMappings.gridwidth = 1;
        gbc_jadPolicyMappings.gridheight = 1;
        gbc_jadPolicyMappings.insets = new Insets(5, 5, 5, 5);
        gbc_jadPolicyMappings.anchor = 17;
        this.jpPolicyMappings = new JPanel(new GridBagLayout());
        this.jpPolicyMappings.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpPolicyMappings.add((Component)this.jlPolicyMappings, gbc_jlPolicyMappings);
        this.jpPolicyMappings.add((Component)this.jpmPolicyMappings, gbc_jadPolicyMappings);
        this.jbOK = new JButton(res.getString("DPolicyMappings.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPolicyMappings.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DPolicyMappings.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPolicyMappings.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPolicyMappings.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpPolicyMappings, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DPolicyMappings.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void prepopulateWithValue(byte[] value) throws IOException {
        PolicyMappings policyMappings = PolicyMappings.getInstance((Object)value);
        this.jpmPolicyMappings.setPolicyMappings(policyMappings);
    }

    private void okPressed() {
        PolicyMappings policyMappings = this.jpmPolicyMappings.getPolicyMappings();
        ASN1Sequence policyMappingsSeq = (ASN1Sequence)policyMappings.toASN1Primitive();
        if (policyMappingsSeq.size() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DPolicyMappings.ValueReq.message"), this.getTitle(), 2);
            return;
        }
        try {
            this.value = policyMappings.getEncoded("DER");
        }
        catch (IOException e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.closeDialog();
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

