/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.importexport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.kse.crypto.Password;
import org.kse.crypto.keypair.KeyPairUtil;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.crypto.keystore.KeyStoreUtil;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.CursorUtil;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dialogs.DViewKeyPair;
import org.kse.gui.error.DError;
import org.kse.gui.error.DProblem;
import org.kse.gui.error.Problem;

public class DImportKeyPairPkcs12
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/importexport/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpKeyPair;
    private JLabel jlPassword;
    private JPasswordField jpfPassword;
    private JLabel jlPkcs12Path;
    private JTextField jtfPkcs12Path;
    private JButton jbBrowse;
    private JButton jbDetails;
    private JPanel jpButtons;
    private JButton jbImport;
    private JButton jbCancel;
    private PrivateKey privateKey;
    private X509Certificate[] certificateChain;

    public DImportKeyPairPkcs12(JFrame parent) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents();
    }

    private void initComponents() {
        GridBagConstraints gbcLbl = new GridBagConstraints();
        gbcLbl.gridx = 0;
        gbcLbl.gridwidth = 3;
        gbcLbl.gridheight = 1;
        gbcLbl.insets = new Insets(5, 5, 5, 5);
        gbcLbl.anchor = 13;
        GridBagConstraints gbcEdCtrl = new GridBagConstraints();
        gbcEdCtrl.gridx = 3;
        gbcEdCtrl.gridwidth = 3;
        gbcEdCtrl.gridheight = 1;
        gbcEdCtrl.insets = new Insets(5, 5, 5, 5);
        gbcEdCtrl.anchor = 17;
        this.jlPassword = new JLabel(res.getString("DImportKeyPairPkcs12.jlPassword.text"));
        GridBagConstraints gbc_jlPassword = (GridBagConstraints)gbcLbl.clone();
        gbc_jlPassword.gridy = 0;
        this.jpfPassword = new JPasswordField(15);
        this.jpfPassword.setToolTipText(res.getString("DImportKeyPairPkcs12.jpfPassword.tooltip"));
        GridBagConstraints gbc_jpfPassword = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jpfPassword.gridy = 0;
        this.jlPkcs12Path = new JLabel(res.getString("DImportKeyPairPkcs12.jlPkcs12Path.text"));
        GridBagConstraints gbc_jlPkcs12 = (GridBagConstraints)gbcLbl.clone();
        gbc_jlPkcs12.gridy = 1;
        this.jtfPkcs12Path = new JTextField(30);
        this.jtfPkcs12Path.setToolTipText(res.getString("DImportKeyPairPkcs12.jtfPkcs12Path.tooltip"));
        GridBagConstraints gbc_jtfPkcs12Path = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jtfPkcs12Path.gridy = 1;
        gbc_jtfPkcs12Path.gridwidth = 6;
        this.jbBrowse = new JButton(res.getString("DImportKeyPairPkcs12.jbBrowse.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbBrowse, res.getString("DImportKeyPairPkcs12.jbBrowse.mnemonic").charAt(0));
        this.jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DImportKeyPairPkcs12.this);
                    DImportKeyPairPkcs12.this.browsePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DImportKeyPairPkcs12.this);
                }
            }
        });
        this.jbBrowse.setToolTipText(res.getString("DImportKeyPairPkcs12.jbBrowse.tooltip"));
        GridBagConstraints gbc_jbPkcs12Browse = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jbPkcs12Browse.gridy = 1;
        gbc_jbPkcs12Browse.gridx = 9;
        this.jbDetails = new JButton(res.getString("DImportKeyPairPkcs12.jbDetails.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbDetails, res.getString("DImportKeyPairPkcs12.jbDetails.mnemonic").charAt(0));
        this.jbDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DImportKeyPairPkcs12.this);
                    DImportKeyPairPkcs12.this.detailsPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DImportKeyPairPkcs12.this);
                }
            }
        });
        this.jbDetails.setToolTipText(res.getString("DImportKeyPairPkcs12.jbDetails.tooltip"));
        GridBagConstraints gbc_jbKeyPairDetails = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jbKeyPairDetails.gridy = 1;
        gbc_jbKeyPairDetails.gridx = 12;
        this.jpKeyPair = new JPanel(new GridBagLayout());
        this.jpKeyPair.setBorder(new CompoundBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()), new EmptyBorder(5, 5, 5, 5)));
        this.jpKeyPair.add((Component)this.jlPassword, gbc_jlPassword);
        this.jpKeyPair.add((Component)this.jpfPassword, gbc_jpfPassword);
        this.jpKeyPair.add((Component)this.jlPkcs12Path, gbc_jlPkcs12);
        this.jpKeyPair.add((Component)this.jtfPkcs12Path, gbc_jtfPkcs12Path);
        this.jpKeyPair.add((Component)this.jbBrowse, gbc_jbPkcs12Browse);
        this.jpKeyPair.add((Component)this.jbDetails, gbc_jbKeyPairDetails);
        this.jbImport = new JButton(res.getString("DImportKeyPairPkcs12.jbImport.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbImport, res.getString("DImportKeyPairPkcs12.jbImport.mnemonic").charAt(0));
        this.jbImport.setToolTipText(res.getString("DImportKeyPairPkcs12.jbImport.tooltip"));
        this.jbImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DImportKeyPairPkcs12.this);
                    DImportKeyPairPkcs12.this.importPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DImportKeyPairPkcs12.this);
                }
            }
        });
        this.jbCancel = new JButton(res.getString("DImportKeyPairPkcs12.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DImportKeyPairPkcs12.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DImportKeyPairPkcs12.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbImport, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpKeyPair, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DImportKeyPairPkcs12.this.closeDialog();
            }
        });
        this.setTitle(res.getString("DImportKeyPairPkcs12.Title"));
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbImport);
        this.pack();
    }

    private void browsePressed() {
        JFileChooser chooser = FileChooserFactory.getPkcs12FileChooser();
        File currentFile = new File(this.jtfPkcs12Path.getText());
        if (currentFile.getParentFile() != null && currentFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(currentFile.getParentFile());
        } else {
            chooser.setCurrentDirectory(CurrentDirectory.get());
        }
        chooser.setDialogTitle(res.getString("DImportKeyPairPkcs12.ChooseKeyPair.Title"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonText(res.getString("DImportKeyPairPkcs12.KeyPairFileChooser.button"));
        int rtnValue = chooser.showOpenDialog(this);
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            this.jtfPkcs12Path.setText(chosenFile.toString());
            this.jtfPkcs12Path.setCaretPosition(0);
        }
    }

    private void detailsPressed() {
        String path = new File(this.jtfPkcs12Path.getText()).getName();
        Keypair keypair = this.loadKeyPair();
        if (keypair != null) {
            DViewKeyPair dViewKeyPair = new DViewKeyPair(this, MessageFormat.format(res.getString("DImportKeyPairPkcs12.ViewKeyPairDetails.Title"), path), keypair.getPrivateKey(), keypair.getCertificateChain());
            dViewKeyPair.setLocationRelativeTo(this);
            dViewKeyPair.setVisible(true);
        }
    }

    private Keypair loadKeyPair() {
        String pkcs12Path = this.jtfPkcs12Path.getText().trim();
        if (pkcs12Path.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DImportKeyPairPkcs12.KeyPairRequired.message"), this.getTitle(), 2);
            return null;
        }
        File pkcs12File = new File(pkcs12Path);
        try {
            String alias;
            Password pkcs12Password = new Password(this.jpfPassword.getPassword());
            KeyStore pkcs12 = KeyStoreUtil.load(pkcs12File, pkcs12Password, KeyStoreType.PKCS12);
            PrivateKey privKey = null;
            ArrayList<Certificate> certsList = new ArrayList<Certificate>();
            Enumeration<String> aliases = pkcs12.aliases();
            while (aliases.hasMoreElements()) {
                alias = aliases.nextElement();
                if (!pkcs12.isKeyEntry(alias)) continue;
                privKey = (PrivateKey)pkcs12.getKey(alias, pkcs12Password.toCharArray());
                Certificate[] certs = pkcs12.getCertificateChain(alias);
                if (certs == null || certs.length <= 0) continue;
                Collections.addAll(certsList, certs);
                break;
            }
            if (privKey == null || certsList.isEmpty()) {
                aliases = pkcs12.aliases();
                while (aliases.hasMoreElements()) {
                    alias = aliases.nextElement();
                    certsList.add(pkcs12.getCertificate(alias));
                }
            }
            if (privKey == null || certsList.size() == 0) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(res.getString("DImportKeyPairPkcs12.NoKeyPairPkcs12File.message"), pkcs12File.getName()), this.getTitle(), 1);
                return null;
            }
            X509Certificate[] certs = X509CertUtil.convertCertificates(certsList.toArray(new Certificate[certsList.size()]));
            return new Keypair(privKey, certs);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(res.getString("DImportKeyPairPkcs12.NoReadFile.message"), pkcs12File), this.getTitle(), 2);
            return null;
        }
        catch (Exception ex) {
            Problem problem = this.createLoadPkcs12Problem(ex, pkcs12File);
            DProblem dProblem = new DProblem(this, res.getString("DImportKeyPairPkcs12.ProblemLoadingPkcs12.Title"), problem);
            dProblem.setLocationRelativeTo(this);
            dProblem.setVisible(true);
            return null;
        }
    }

    private Problem createLoadPkcs12Problem(Exception exception, File pkcs12File) {
        String problemStr = MessageFormat.format(res.getString("DImportKeyPairPkcs12.NoLoadPkcs12.Problem"), pkcs12File.getName());
        String[] causes = new String[]{res.getString("DImportKeyPairPkcs12.PasswordIncorrectPkcs12.Cause"), res.getString("DImportKeyPairPkcs12.NotPkcs12.Cause"), res.getString("DImportKeyPairPkcs12.CorruptedPkcs12.Cause")};
        Problem problem = new Problem(problemStr, causes, exception);
        return problem;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    private void importPressed() {
        try {
            Keypair keypair = this.loadKeyPair();
            if (keypair == null) {
                return;
            }
            if (!KeyPairUtil.validKeyPair(keypair.getPrivateKey(), X509CertUtil.orderX509CertChain(keypair.getCertificateChain())[0].getPublicKey())) {
                JOptionPane.showMessageDialog(this, res.getString("DImportKeyPairPkcs12.KeyPairInvalid.message"), this.getTitle(), 2);
                return;
            }
            this.privateKey = keypair.getPrivateKey();
            this.certificateChain = keypair.getCertificateChain();
            this.closeDialog();
        }
        catch (Exception ex) {
            DError.displayError(this, (Throwable)ex);
        }
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private class Keypair {
        private PrivateKey privateKey;
        private X509Certificate[] certificateChain;

        public Keypair(PrivateKey privateKey, X509Certificate[] certificateChain) {
            this.privateKey = privateKey;
            this.certificateChain = certificateChain;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public X509Certificate[] getCertificateChain() {
            return this.certificateChain;
        }
    }
}

