/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.sign;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.kse.crypto.CryptoException;
import org.kse.crypto.KeyInfo;
import org.kse.crypto.csr.pkcs10.Pkcs10Util;
import org.kse.crypto.csr.spkac.Spkac;
import org.kse.crypto.csr.spkac.SpkacSubject;
import org.kse.crypto.keypair.KeyPairType;
import org.kse.crypto.keypair.KeyPairUtil;
import org.kse.crypto.signing.SignatureType;
import org.kse.crypto.x509.X500NameUtils;
import org.kse.crypto.x509.X509CertificateVersion;
import org.kse.crypto.x509.X509ExtensionSet;
import org.kse.crypto.x509.X509ExtensionSetUpdater;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.CursorUtil;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.JEscDialog;
import org.kse.gui.JavaFXFileChooser;
import org.kse.gui.MiGUtil;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.JDistinguishedName;
import org.kse.gui.crypto.JValidityPeriod;
import org.kse.gui.datetime.JDateTime;
import org.kse.gui.dialogs.DViewAsn1Dump;
import org.kse.gui.dialogs.DViewPem;
import org.kse.gui.dialogs.DViewPublicKey;
import org.kse.gui.dialogs.DialogHelper;
import org.kse.gui.dialogs.extensions.DAddExtensions;
import org.kse.gui.dialogs.extensions.DViewExtensions;
import org.kse.gui.error.DError;
import org.kse.utilities.DialogViewer;
import org.kse.utilities.asn1.Asn1Exception;
import org.kse.utilities.io.FileNameUtil;

public class DSignCsr
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/sign/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JLabel jlCsrFormat;
    private JTextField jtfCsrFormat;
    private JLabel jlCsrSubject;
    private JDistinguishedName jdnCsrSubject;
    private JLabel jlCsrPublicKey;
    private JTextField jtfCsrPublicKey;
    private JButton jbViewCsrPublicKeyDetails;
    private JLabel jlCsrSignatureAlgorithm;
    private JTextField jtfCsrSignatureAlgorithm;
    private JLabel jlCsrChallenge;
    private JTextField jtfCsrChallenge;
    private JButton jbCsrExtensions;
    private JButton jbCsrPem;
    private JButton jbCsrAsn1;
    private JLabel jlVersion;
    private JRadioButton jrbVersion1;
    private JRadioButton jrbVersion3;
    private JLabel jlSignatureAlgorithm;
    private JComboBox<SignatureType> jcbSignatureAlgorithm;
    private JLabel jlSubjectDN;
    private JDistinguishedName jdnSubjectDN;
    private JLabel jlValidityStart;
    private JDateTime jdtValidityStart;
    private JLabel jlValidityEnd;
    private JDateTime jdtValidityEnd;
    private JLabel jlValidityPeriod;
    private JValidityPeriod jvpValidityPeriod;
    private JLabel jlSerialNumber;
    private JTextField jtfSerialNumber;
    private JLabel jlCaReplyFile;
    private JTextField jtfCaReplyFile;
    private JButton jbBrowse;
    private JButton jbTransferExtensions;
    private JButton jbAddExtensions;
    private JButton jbOK;
    private JButton jbCancel;
    private PrivateKey signPrivateKey;
    private KeyPairType signKeyPairType;
    private X509Certificate issuerCertificate;
    private PKCS10CertificationRequest pkcs10Csr;
    private Spkac spkacCsr;
    private File csrFile;
    private PublicKey csrPublicKey;
    private X509CertificateVersion version;
    private SignatureType signatureType;
    private Date validityStart;
    private Date validityEnd;
    private BigInteger serialNumber;
    private X500Name subjectDN;
    private File caReplyFile;
    private X509ExtensionSet extensions = new X509ExtensionSet();

    public DSignCsr(JFrame parent, PKCS10CertificationRequest pkcs10Csr, File csrFile, PrivateKey signPrivateKey, KeyPairType signKeyPairType, X509Certificate issuerCertificate) throws CryptoException {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.pkcs10Csr = pkcs10Csr;
        this.csrFile = csrFile;
        this.signPrivateKey = signPrivateKey;
        this.signKeyPairType = signKeyPairType;
        this.issuerCertificate = issuerCertificate;
        this.setTitle(res.getString("DSignCsr.Title"));
        this.initComponents();
    }

    public DSignCsr(JFrame parent, Spkac spkacCsr, File csrFile, PrivateKey signPrivateKey, KeyPairType signKeyPairType, X509Certificate issuerCertificate) throws CryptoException {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.spkacCsr = spkacCsr;
        this.csrFile = csrFile;
        this.signPrivateKey = signPrivateKey;
        this.signKeyPairType = signKeyPairType;
        this.issuerCertificate = issuerCertificate;
        this.setTitle(res.getString("DSignCsr.Title"));
        this.initComponents();
    }

    private void initComponents() throws CryptoException {
        this.jlCsrFormat = new JLabel(res.getString("DSignCsr.jlCsrFormat.text"));
        this.jtfCsrFormat = new JTextField(15);
        this.jtfCsrFormat.setEditable(false);
        this.jtfCsrFormat.setToolTipText(res.getString("DSignCsr.jtfCsrFormat.tooltip"));
        this.jlCsrSubject = new JLabel(res.getString("DSignCsr.jlCsrSubject.text"));
        this.jdnCsrSubject = new JDistinguishedName(res.getString("DSignCsr.Subject.Title"), 40, false);
        this.jdnCsrSubject.setToolTipText(res.getString("DSignCsr.jdnCsrSubject.tooltip"));
        this.jlCsrPublicKey = new JLabel(res.getString("DSignCsr.jlCsrPublicKey.text"));
        this.jtfCsrPublicKey = new JTextField(15);
        this.jtfCsrPublicKey.setEditable(false);
        this.jtfCsrPublicKey.setToolTipText(res.getString("DSignCsr.jtfCsrPublicKey.tooltip"));
        this.jbViewCsrPublicKeyDetails = new JButton();
        this.jbViewCsrPublicKeyDetails.setToolTipText(res.getString("DSignCsr.jbViewCsrPublicKeyDetails.tooltip"));
        this.jbViewCsrPublicKeyDetails.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/viewpubkey.png"))));
        this.jlCsrSignatureAlgorithm = new JLabel(res.getString("DSignCsr.jlCsrSignatureAlgorithm.text"));
        this.jtfCsrSignatureAlgorithm = new JTextField(15);
        this.jtfCsrSignatureAlgorithm.setEditable(false);
        this.jtfCsrSignatureAlgorithm.setToolTipText(res.getString("DSignCsr.jtfCsrSignatureAlgorithm.tooltip"));
        this.jlCsrChallenge = new JLabel(res.getString("DSignCsr.jlCsrChallenge.text"));
        this.jtfCsrChallenge = new JTextField(15);
        this.jtfCsrChallenge.setEditable(false);
        this.jtfCsrChallenge.setToolTipText(res.getString("DSignCsr.jtfCsrChallenge.tooltip"));
        this.jbCsrExtensions = new JButton(res.getString("DSignCsr.jbCsrExtensions.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbCsrExtensions, res.getString("DSignCsr.jbCsrExtensions.mnemonic").charAt(0));
        this.jbCsrExtensions.setToolTipText(res.getString("DSignCsr.jbCsrExtensions.tooltip"));
        this.jbCsrPem = new JButton(res.getString("DSignCsr.jbCsrPem.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbCsrPem, res.getString("DSignCsr.jbCsrPem.mnemonic").charAt(0));
        this.jbCsrPem.setToolTipText(res.getString("DSignCsr.jbCsrPem.tooltip"));
        this.jbCsrAsn1 = new JButton(res.getString("DSignCsr.jbCsrAsn1.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbCsrAsn1, res.getString("DSignCsr.jbCsrAsn1.mnemonic").charAt(0));
        this.jbCsrAsn1.setToolTipText(res.getString("DSignCsr.jbCsrAsn1.tooltip"));
        this.jlVersion = new JLabel(res.getString("DSignCsr.jlVersion.text"));
        this.jrbVersion1 = new JRadioButton(res.getString("DSignCsr.jrbVersion1.text"));
        this.jrbVersion1.setToolTipText(res.getString("DSignCsr.jrbVersion1.tooltip"));
        this.jrbVersion3 = new JRadioButton(res.getString("DSignCsr.jrbVersion3.text"));
        this.jrbVersion3.setToolTipText(res.getString("DSignCsr.jrbVersion3.tooltip"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jrbVersion1);
        buttonGroup.add(this.jrbVersion3);
        this.jrbVersion3.setSelected(true);
        this.jlSignatureAlgorithm = new JLabel(res.getString("DSignCsr.jlSignatureAlgorithm.text"));
        this.jcbSignatureAlgorithm = new JComboBox();
        this.jcbSignatureAlgorithm.setMaximumRowCount(10);
        DialogHelper.populateSigAlgs(this.signKeyPairType, this.signPrivateKey, this.jcbSignatureAlgorithm);
        this.jcbSignatureAlgorithm.setToolTipText(res.getString("DSignCsr.jcbSignatureAlgorithm.tooltip"));
        this.jlSubjectDN = new JLabel(res.getString("DSignCsr.jlCsrSubject.text"));
        this.jdnSubjectDN = new JDistinguishedName(res.getString("DSignCsr.Subject.Title"), 40, true);
        this.jdnSubjectDN.setToolTipText(res.getString("DSignCsr.jdnCsrSubject.tooltip"));
        Date now = new Date();
        this.jlValidityStart = new JLabel(res.getString("DSignCsr.jlValidityStart.text"));
        this.jdtValidityStart = new JDateTime(res.getString("DSignCsr.jdtValidityStart.text"), false);
        this.jdtValidityStart.setDateTime(now);
        this.jdtValidityStart.setToolTipText(res.getString("DSignCsr.jdtValidityStart.tooltip"));
        this.jlValidityEnd = new JLabel(res.getString("DSignCsr.jlValidityEnd.text"));
        this.jdtValidityEnd = new JDateTime(res.getString("DSignCsr.jdtValidityEnd.text"), false);
        this.jdtValidityEnd.setDateTime(new Date(now.getTime() + TimeUnit.DAYS.toMillis(365L)));
        this.jdtValidityEnd.setToolTipText(res.getString("DSignCsr.jdtValidityEnd.tooltip"));
        this.jlValidityPeriod = new JLabel(res.getString("DSignCsr.jlValidityPeriod.text"));
        this.jvpValidityPeriod = new JValidityPeriod(0);
        this.jvpValidityPeriod.setToolTipText(res.getString("DSignCsr.jvpValidityPeriod.tooltip"));
        this.jlSerialNumber = new JLabel(res.getString("DSignCsr.jlSerialNumber.text"));
        this.jtfSerialNumber = new JTextField("" + this.generateSerialNumber(), 15);
        this.jtfSerialNumber.setToolTipText(res.getString("DSignCsr.jtfSerialNumber.tooltip"));
        this.jlCaReplyFile = new JLabel(res.getString("DSignCsr.jlCaReplyFile.text"));
        this.jtfCaReplyFile = new JTextField(40);
        this.jtfCaReplyFile.setToolTipText(res.getString("DSignCsr.jtfCaReplyFile.tooltip"));
        this.jbBrowse = new JButton(res.getString("DSignCsr.jbBrowse.text"));
        this.jbBrowse.setToolTipText(res.getString("DSignCsr.jbBrowse.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbBrowse, res.getString("DSignCsr.jbBrowse.mnemonic").charAt(0));
        this.jbTransferExtensions = new JButton(res.getString("DSignCsr.jbTransferExtensions.text"));
        this.jbTransferExtensions.setMnemonic(res.getString("DSignCsr.jbTransferExtensions.mnemonic").charAt(0));
        this.jbTransferExtensions.setToolTipText(res.getString("DSignCsr.jbTransferExtensions.tooltip"));
        this.jbAddExtensions = new JButton(res.getString("DSignCsr.jbAddExtensions.text"));
        this.jbAddExtensions.setMnemonic(res.getString("DSignCsr.jbAddExtensions.mnemonic").charAt(0));
        this.jbAddExtensions.setToolTipText(res.getString("DSignCsr.jbAddExtensions.tooltip"));
        this.jbOK = new JButton(res.getString("DSignCsr.jbOK.text"));
        this.jbCancel = new JButton(res.getString("DSignCsr.jbCancel.text"));
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        JPanel jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        Container pane = this.getContentPane();
        pane.setLayout((LayoutManager)new MigLayout("fill", "[right]unrel[]", "[]unrel[]"));
        MiGUtil.addSeparator(pane, res.getString("DSignCsr.jpCsrDetails.text"));
        pane.add((Component)this.jlCsrFormat, "");
        pane.add((Component)this.jtfCsrFormat, "wrap");
        pane.add((Component)this.jlCsrSubject, "");
        pane.add((Component)this.jdnCsrSubject, "wrap");
        pane.add((Component)this.jlCsrPublicKey, "");
        pane.add((Component)this.jtfCsrPublicKey, "split 2");
        pane.add((Component)this.jbViewCsrPublicKeyDetails, "wrap");
        pane.add((Component)this.jlCsrSignatureAlgorithm, "");
        pane.add((Component)this.jtfCsrSignatureAlgorithm, "wrap");
        pane.add((Component)this.jlCsrChallenge, "");
        pane.add((Component)this.jtfCsrChallenge, "wrap");
        pane.add((Component)this.jbCsrExtensions, "right, spanx, split");
        pane.add((Component)this.jbCsrPem, "");
        pane.add((Component)this.jbCsrAsn1, "wrap");
        MiGUtil.addSeparator(pane, res.getString("DSignCsr.jpSigningOptions.text"));
        pane.add((Component)this.jlVersion, "");
        pane.add((Component)this.jrbVersion1, "split 2");
        pane.add((Component)this.jrbVersion3, "wrap");
        pane.add((Component)this.jlSignatureAlgorithm, "");
        pane.add(this.jcbSignatureAlgorithm, "wrap");
        pane.add((Component)this.jlSubjectDN, "");
        pane.add((Component)this.jdnSubjectDN, "wrap");
        pane.add((Component)this.jlValidityStart, "");
        pane.add((Component)this.jdtValidityStart, "wrap");
        pane.add((Component)this.jlValidityPeriod, "");
        pane.add((Component)this.jvpValidityPeriod, "wrap");
        pane.add((Component)this.jlValidityEnd, "");
        pane.add((Component)this.jdtValidityEnd, "wrap");
        pane.add((Component)this.jlSerialNumber, "");
        pane.add((Component)this.jtfSerialNumber, "wrap");
        pane.add((Component)this.jlCaReplyFile, "");
        pane.add((Component)this.jtfCaReplyFile, "split 2");
        pane.add((Component)this.jbBrowse, "wrap");
        pane.add((Component)this.jbTransferExtensions, "spanx, split 2");
        pane.add((Component)this.jbAddExtensions, "wrap");
        pane.add((Component)new JSeparator(), "spanx, growx, wrap");
        pane.add((Component)jpButtons, "right, spanx");
        this.populateFields();
        this.jbViewCsrPublicKeyDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DSignCsr.this);
                    DSignCsr.this.pubKeyDetailsPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DSignCsr.this);
                }
            }
        });
        this.jbCsrExtensions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DSignCsr.this);
                    DSignCsr.this.extensionsPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DSignCsr.this);
                }
            }
        });
        this.jbCsrPem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DSignCsr.this);
                    DSignCsr.this.pemEncodingPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DSignCsr.this);
                }
            }
        });
        this.jbCsrAsn1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DSignCsr.this);
                    DSignCsr.this.asn1DumpPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DSignCsr.this);
                }
            }
        });
        this.jvpValidityPeriod.addApplyActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date startDate = DSignCsr.this.jdtValidityStart.getDateTime();
                if (startDate == null) {
                    startDate = new Date();
                    DSignCsr.this.jdtValidityStart.setDateTime(startDate);
                }
                Date validityEnd = DSignCsr.this.jvpValidityPeriod.getValidityEnd(startDate);
                DSignCsr.this.jdtValidityEnd.setDateTime(validityEnd);
            }
        });
        this.jrbVersion3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DSignCsr.this.jbAddExtensions.setEnabled(DSignCsr.this.jrbVersion3.isSelected());
            }
        });
        this.jbTransferExtensions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DSignCsr.this);
                    DSignCsr.this.transferExtensionsPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DSignCsr.this);
                }
            }
        });
        this.jbAddExtensions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DSignCsr.this);
                    DSignCsr.this.addExtensionsPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DSignCsr.this);
                }
            }
        });
        this.jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DSignCsr.this);
                    DSignCsr.this.browsePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DSignCsr.this);
                }
            }
        });
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSignCsr.this.okPressed();
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSignCsr.this.cancelPressed();
            }
        });
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSignCsr.this.cancelPressed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DSignCsr.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void populateFields() throws CryptoException {
        if (this.pkcs10Csr != null) {
            this.populatePkcs10CsrDetails();
        } else {
            this.populateSpkacCsrDetails();
        }
        this.jdnSubjectDN.setDistinguishedName(this.pkcs10Csr.getSubject());
        this.populateCaReplyFileName();
    }

    private void populatePkcs10CsrDetails() throws CryptoException {
        this.jtfCsrFormat.setText(res.getString("DSignCsr.jtfCsrFormat.Pkcs10.text"));
        this.jtfCsrFormat.setCaretPosition(0);
        this.jdnCsrSubject.setDistinguishedName(this.pkcs10Csr.getSubject());
        try {
            this.csrPublicKey = new JcaPKCS10CertificationRequest(this.pkcs10Csr).getPublicKey();
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(res.getString("DSignCsr.NoGetCsrPublicKey.message"), ex);
        }
        this.populatePublicKey();
        String sigAlgId = this.pkcs10Csr.getSignatureAlgorithm().getAlgorithm().getId();
        SignatureType sigAlg = SignatureType.resolveOid(sigAlgId);
        if (sigAlg != null) {
            this.jtfCsrSignatureAlgorithm.setText(sigAlg.friendly());
        } else {
            this.jtfCsrSignatureAlgorithm.setText(sigAlgId);
        }
        this.jtfCsrSignatureAlgorithm.setCaretPosition(0);
        DialogHelper.populatePkcs10Challenge(this.pkcs10Csr.getAttributes(), this.jtfCsrChallenge);
        Attribute[] extReqAttr = this.pkcs10Csr.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest);
        if (extReqAttr != null && extReqAttr.length > 0) {
            this.jbCsrExtensions.setEnabled(true);
            this.jbTransferExtensions.setEnabled(true);
        } else {
            this.jbCsrExtensions.setEnabled(false);
            this.jbTransferExtensions.setEnabled(false);
        }
    }

    private void populateSpkacCsrDetails() throws CryptoException {
        this.jtfCsrFormat.setText(res.getString("DSignCsr.jtfCsrFormat.Spkac.text"));
        this.jtfCsrFormat.setCaretPosition(0);
        SpkacSubject subject = this.spkacCsr.getSubject();
        this.jdnCsrSubject.setDistinguishedName(subject.getName());
        this.csrPublicKey = this.spkacCsr.getPublicKey();
        this.populatePublicKey();
        this.jtfCsrSignatureAlgorithm.setText(this.spkacCsr.getSignatureAlgorithm().friendly());
        this.jtfCsrSignatureAlgorithm.setCaretPosition(0);
        this.jtfCsrChallenge.setText(this.spkacCsr.getChallenge());
        this.jtfCsrChallenge.setCaretPosition(0);
    }

    private void populatePublicKey() throws CryptoException {
        KeyInfo keyInfo = KeyPairUtil.getKeyInfo(this.csrPublicKey);
        this.jtfCsrPublicKey.setText(keyInfo.getAlgorithm());
        Integer keySize = keyInfo.getSize();
        if (keySize != null) {
            this.jtfCsrPublicKey.setText(MessageFormat.format(res.getString("DSignCsr.jtfCsrPublicKey.text"), this.jtfCsrPublicKey.getText(), "" + keySize));
        } else {
            this.jtfCsrPublicKey.setText(MessageFormat.format(res.getString("DSignCsr.jtfCsrPublicKey.text"), this.jtfCsrPublicKey.getText(), "?"));
        }
        this.jtfCsrPublicKey.setCaretPosition(0);
    }

    private long generateSerialNumber() {
        return System.currentTimeMillis() / 1000L;
    }

    private void populateCaReplyFileName() {
        String replyFileName = FileNameUtil.removeExtension(this.csrFile.getName()) + ".p7r";
        File replyFile = new File(this.csrFile.getParentFile(), replyFileName);
        this.jtfCaReplyFile.setText(replyFile.getPath());
    }

    private void extensionsPressed() {
        X509ExtensionSet x509ExtensionSet = Pkcs10Util.getExtensions(this.pkcs10Csr);
        DViewExtensions dViewExtensions = new DViewExtensions(this, res.getString("DSignCsr.Extensions.Title"), (X509Extension)x509ExtensionSet);
        dViewExtensions.setLocationRelativeTo(this);
        dViewExtensions.setVisible(true);
    }

    private void pemEncodingPressed() {
        try {
            DViewPem dViewCsrPem = new DViewPem((JDialog)this, res.getString("DSignCsr.Pem.Title"), this.pkcs10Csr);
            dViewCsrPem.setLocationRelativeTo(this);
            dViewCsrPem.setVisible(true);
        }
        catch (CryptoException e) {
            DError.displayError(this, (Throwable)e);
        }
    }

    private void asn1DumpPressed() {
        try {
            DViewAsn1Dump dViewAsn1Dump = this.pkcs10Csr != null ? new DViewAsn1Dump((JDialog)this, this.pkcs10Csr) : new DViewAsn1Dump((JDialog)this, this.spkacCsr);
            dViewAsn1Dump.setLocationRelativeTo(this);
            dViewAsn1Dump.setVisible(true);
        }
        catch (IOException | Asn1Exception e) {
            DError.displayError(this, (Throwable)e);
        }
    }

    public X509CertificateVersion getVersion() {
        return this.version;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public Date getValidityStart() {
        return this.validityStart;
    }

    public Date getValidityEnd() {
        return this.validityEnd;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public X500Name getSubjectDN() {
        return this.subjectDN;
    }

    public PublicKey getPublicKey() {
        return this.csrPublicKey;
    }

    public File getCaReplyFile() {
        return this.caReplyFile;
    }

    public X509ExtensionSet getExtensions() {
        return this.extensions;
    }

    protected void transferExtensionsPressed() {
        this.extensions = Pkcs10Util.getExtensions(this.pkcs10Csr);
        try {
            X509ExtensionSetUpdater.update(this.extensions, this.csrPublicKey, this.issuerCertificate.getPublicKey(), X500NameUtils.x500PrincipalToX500Name(this.issuerCertificate.getSubjectX500Principal()), this.issuerCertificate.getSerialNumber());
        }
        catch (IOException | CryptoException e) {
            DError.displayError(this, (Throwable)e);
        }
    }

    private void addExtensionsPressed() {
        DAddExtensions dAddExtensions = new DAddExtensions(this, this.extensions, this.issuerCertificate.getPublicKey(), X500NameUtils.x500PrincipalToX500Name(this.issuerCertificate.getSubjectX500Principal()), this.issuerCertificate.getSerialNumber(), this.csrPublicKey);
        dAddExtensions.setLocationRelativeTo(this);
        dAddExtensions.setVisible(true);
        if (dAddExtensions.getExtensions() != null) {
            this.extensions = dAddExtensions.getExtensions();
        }
    }

    private void browsePressed() {
        int rtnValue;
        JFileChooser chooser = FileChooserFactory.getCaReplyFileChooser();
        File currentExportFile = new File(this.jtfCaReplyFile.getText().trim());
        if (currentExportFile.getParentFile() != null && currentExportFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(currentExportFile.getParentFile());
            chooser.setSelectedFile(currentExportFile);
        } else {
            chooser.setCurrentDirectory(CurrentDirectory.get());
        }
        chooser.setDialogTitle(res.getString("DSignCsr.SaveCaReply.Title"));
        chooser.setMultiSelectionEnabled(false);
        int n = rtnValue = JavaFXFileChooser.isFxAvailable() ? chooser.showSaveDialog(this) : chooser.showDialog(this, res.getString("DSignCsr.SaveCaReply.button"));
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            this.jtfCaReplyFile.setText(chosenFile.toString());
            this.jtfCaReplyFile.setCaretPosition(0);
        }
    }

    private void pubKeyDetailsPressed() {
        try {
            DViewPublicKey dViewPublicKey = new DViewPublicKey(this, res.getString("DSignCsr.PubKeyDetails.Title"), this.csrPublicKey);
            dViewPublicKey.setLocationRelativeTo(this);
            dViewPublicKey.setVisible(true);
        }
        catch (CryptoException e) {
            DError.displayError(this, (Throwable)e);
        }
    }

    private void okPressed() {
        String message;
        int selected;
        if (this.jdnSubjectDN.getDistinguishedName().toString().isEmpty()) {
            JOptionPane.showMessageDialog(this, res.getString("DSignCsr.InvalidDN.message"), this.getTitle(), 2);
            return;
        }
        String serialNumberStr = this.jtfSerialNumber.getText().trim();
        if (serialNumberStr.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DSignCsr.ValReqSerialNumber.message"), this.getTitle(), 2);
            return;
        }
        try {
            this.serialNumber = new BigInteger(serialNumberStr);
            if (this.serialNumber.compareTo(BigInteger.ONE) < 0) {
                JOptionPane.showMessageDialog(this, res.getString("DSignCsr.SerialNumberNonZero.message"), this.getTitle(), 2);
                return;
            }
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, res.getString("DSignCsr.SerialNumberNotInteger.message"), this.getTitle(), 2);
            return;
        }
        String exportFileStr = this.jtfCaReplyFile.getText().trim();
        if (exportFileStr.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DSignCsr.CaReplyFileRequired.message"), this.getTitle(), 2);
            return;
        }
        File caReplyFile = new File(exportFileStr);
        if (caReplyFile.isFile() && (selected = JOptionPane.showConfirmDialog(this, message = MessageFormat.format(res.getString("DSignCsr.OverWriteCaReplyFile.message"), caReplyFile), this.getTitle(), 0)) != 0) {
            return;
        }
        this.caReplyFile = caReplyFile;
        if (this.jrbVersion1.isSelected()) {
            this.version = X509CertificateVersion.VERSION1;
            this.extensions = null;
        } else {
            this.version = X509CertificateVersion.VERSION3;
        }
        this.signatureType = (SignatureType)((Object)this.jcbSignatureAlgorithm.getSelectedItem());
        this.validityStart = this.jdtValidityStart.getDateTime();
        this.validityEnd = this.jdtValidityEnd.getDateTime();
        this.subjectDN = this.jdnSubjectDN.getDistinguishedName();
        this.closeDialog();
    }

    private void cancelPressed() {
        this.extensions = null;
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", "BC");
        keyGen.initialize(1024);
        KeyPair keyPair = keyGen.genKeyPair();
        JcaPKCS10CertificationRequestBuilder csrBuilder = new JcaPKCS10CertificationRequestBuilder(new X500Name("cn=test"), keyPair.getPublic());
        PKCS10CertificationRequest csr = csrBuilder.build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(keyPair.getPrivate()));
        DSignCsr dialog = new DSignCsr(new JFrame(), csr, new File(System.getProperty("user.dir"), "test.csr"), keyPair.getPrivate(), KeyPairType.RSA, null);
        DialogViewer.run(dialog);
    }
}

