/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.SwingUtilities;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.ExamineFileAction;
import org.kse.gui.error.DError;

public class DroppedFileHandler {
    private DroppedFileHandler() {
    }

    public static void drop(DropTargetDropEvent evt, final KseFrame kseFrame) {
        evt.acceptDrop(2);
        Transferable trans = evt.getTransferable();
        try {
            if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                final List droppedFiles = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DroppedFileHandler.openFiles(kseFrame, droppedFiles);
                    }
                });
            }
        }
        catch (UnsupportedFlavorException | IOException e) {
            DError.displayError(kseFrame.getUnderlyingFrame(), (Throwable)e);
        }
    }

    public static void openFiles(KseFrame kseFrame, List<File> droppedFiles) {
        ExamineFileAction examineFileAction = new ExamineFileAction(kseFrame);
        for (File droppedFile : droppedFiles) {
            try {
                examineFileAction.openFile(droppedFile);
            }
            catch (Exception e) {
                DError.displayError(kseFrame.getUnderlyingFrame(), (Throwable)e);
            }
        }
    }
}

