/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.error;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.LnfUtil;
import org.kse.gui.PlatformUtil;
import org.kse.gui.error.DError;
import org.kse.gui.error.Problem;

public class DProblem
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/error/resources");
    private JPanel jpProblem;
    private JPanel jpProblemHeader;
    private JLabel jlProblemHeader;
    private JPanel jpCauses;
    private JLabel jlCauses;
    private JPanel jpButtons;
    private JButton jbDisplayError;
    private JButton jbOK;
    private Problem problem;

    public DProblem(JFrame parent, String title, Problem problem) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setTitle(title);
        this.problem = problem;
        this.initComponents();
    }

    public DProblem(JDialog parent, String title, Problem problem) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setTitle(title);
        this.problem = problem;
        this.initComponents();
    }

    private void initComponents() {
        this.jpProblemHeader = new JPanel(new FlowLayout(0));
        this.jpProblemHeader.setBorder(new EmptyBorder(5, 5, 5, 5));
        if (!LnfUtil.isDarkLnf()) {
            this.jpProblemHeader.setBackground(Color.WHITE);
        }
        this.jpProblemHeader.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 0, Color.WHITE), new CompoundBorder(new MatteBorder(0, 0, 1, 0, Color.GRAY), new EmptyBorder(10, 10, 10, 10))));
        ImageIcon icon = new ImageIcon(this.getClass().getResource("images/problem.png"));
        this.jlProblemHeader = new JLabel(this.formatProblem());
        this.jlProblemHeader.setIconTextGap(15);
        this.jlProblemHeader.setIcon(icon);
        this.jpProblemHeader.add(this.jlProblemHeader);
        this.jpCauses = new JPanel(new FlowLayout(0));
        this.jlCauses = new JLabel(this.formatCauses());
        this.jpCauses.add(this.jlCauses);
        this.jpCauses.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 0, Color.WHITE), new CompoundBorder(new MatteBorder(0, 0, 1, 0, Color.GRAY), new EmptyBorder(0, 5, 5, 10))));
        this.jpProblem = new JPanel(new BorderLayout(0, 0));
        this.jpProblem.add((Component)this.jpProblemHeader, "North");
        this.jpProblem.add((Component)this.jpCauses, "Center");
        this.jbDisplayError = new JButton(res.getString("DProblem.jbDisplayError.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbDisplayError, res.getString("DProblem.jbDisplayError.mnemonic").charAt(0));
        this.jbDisplayError.setToolTipText(res.getString("DProblem.jbDisplayError.tooltip"));
        this.jbDisplayError.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DProblem.this);
                    DProblem.this.showError();
                }
                finally {
                    CursorUtil.setCursorFree(DProblem.this);
                }
            }
        });
        this.jbOK = new JButton(res.getString("DProblem.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DProblem.this.okPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, null, this.jbDisplayError);
        this.getContentPane().add((Component)this.jpProblem, "North");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DProblem.this.closeDialog();
            }
        });
        this.pack();
        this.getRootPane().setDefaultButton(this.jbOK);
        this.jbOK.requestFocusInWindow();
    }

    private String formatProblem() {
        return MessageFormat.format("<html>{0}</html>", this.breakLine(this.problem.getProblem(), 50));
    }

    private String formatCauses() {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append(res.getString("DProblem.PossibleReasons.text"));
        sb.append("<ul style='margin-left:20'>");
        for (String solution : this.problem.getCauses()) {
            sb.append("<li style='padding-top:5; padding-botton:5'>");
            sb.append(this.breakLine(solution, 55));
            sb.append("</li>");
        }
        sb.append("</ul>");
        sb.append("</html>");
        return sb.toString();
    }

    private String breakLine(String line, int maxLineLength) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer strTok = new StringTokenizer(line, " ");
        String currentLine = "";
        while (strTok.hasMoreTokens()) {
            String word = strTok.nextToken();
            if (currentLine.length() == 0) {
                currentLine = currentLine + word;
                continue;
            }
            if (currentLine.length() + word.length() + 1 <= maxLineLength) {
                currentLine = currentLine + " ";
                currentLine = currentLine + word;
                continue;
            }
            if (sb.length() > 0) {
                sb.append("<br>");
            }
            sb.append(currentLine);
            currentLine = word;
        }
        if (sb.length() > 0) {
            sb.append("<br>");
        }
        sb.append(currentLine);
        return sb.toString();
    }

    private void showError() {
        DError dError = new DError(this, res.getString("DProblem.CauseError.Title"), this.problem.getError());
        dError.setLocationRelativeTo(this);
        dError.setVisible(true);
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

