/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.quickstart;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.kse.gui.KseFrame;
import org.kse.gui.LnfUtil;
import org.kse.gui.actions.ExamineFileAction;
import org.kse.gui.actions.HelpAction;
import org.kse.gui.actions.NewAction;
import org.kse.gui.actions.OpenAction;
import org.kse.gui.actions.OpenCaCertificatesAction;
import org.kse.gui.actions.OpenDefaultAction;
import org.kse.gui.dnd.DroppedFileHandler;
import org.kse.gui.gradient.JGradientPanel;
import org.kse.gui.quickstart.JQuickStartButton;
import org.kse.gui.quickstart.JQuickStartLabel;

public class JQuickStartPane
extends JGradientPanel
implements DropTargetListener {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/quickstart/resources");
    private static final boolean IS_DARK_LAF = LnfUtil.isDarkLnf();
    private static final Color GRADIENT_COLOR_1 = IS_DARK_LAF ? new Color(85, 85, 85) : Color.WHITE;
    private static final Color GRADIENT_COLOR_2 = IS_DARK_LAF ? new Color(60, 63, 65) : Color.LIGHT_GRAY;
    private static final Color TEXT_COLOR = IS_DARK_LAF ? new Color(116, 131, 141) : new Color(0, 134, 201);
    private static final Color TEXT_ROLLOVER_COLOR = IS_DARK_LAF ? new Color(141, 141, 124) : new Color(135, 31, 120);
    private KseFrame kseFrame;
    private JPanel jpQuickStart;
    private JQuickStartLabel jqslHeading;
    private JQuickStartButton jqsbNewKeyStore;
    private JQuickStartButton jqsbOpenKeyStore;
    private JQuickStartButton jqsbOpenDefaultKeyStore;
    private JQuickStartButton jqsbOpenCaCertificatesKeyStore;
    private JQuickStartButton jqsbExamineCertificate;
    private JQuickStartButton jqsbHelp;
    private JPanel jpNonResizeCenterHorizontally;

    public JQuickStartPane(KseFrame kseFrame) {
        super(GRADIENT_COLOR_1, GRADIENT_COLOR_2);
        this.kseFrame = kseFrame;
        new DropTarget(this, this);
        this.initComponents();
    }

    private void initComponents() {
        this.jqslHeading = new JQuickStartLabel(res.getString("JQuickStartPane.jqslHeading.text"));
        this.jqslHeading.setForeground(TEXT_COLOR);
        this.jqslHeading.setFont(this.jqslHeading.getFont().deriveFont(20.0f));
        Toolkit toolKit = Toolkit.getDefaultToolkit();
        ImageIcon newImage = new ImageIcon(toolKit.createImage(this.getClass().getResource("images/new.png")));
        ImageIcon newImageRollOver = new ImageIcon(toolKit.createImage(this.getClass().getResource("images/new_rollover.png")));
        this.jqsbNewKeyStore = new JQuickStartButton(new NewAction(this.kseFrame), res.getString("JQuickStartPane.jqsbNewKeyStore.text"), newImage, newImageRollOver, TEXT_COLOR, TEXT_ROLLOVER_COLOR);
        this.jqsbNewKeyStore.setOpaque(false);
        ImageIcon openImage = new ImageIcon(toolKit.createImage(this.getClass().getResource("images/open.png")));
        ImageIcon openImageRollOver = new ImageIcon(toolKit.createImage(this.getClass().getResource("images/open_rollover.png")));
        this.jqsbOpenKeyStore = new JQuickStartButton(new OpenAction(this.kseFrame), res.getString("JQuickStartPane.jqsbOpenKeyStore.text"), openImage, openImageRollOver, TEXT_COLOR, TEXT_ROLLOVER_COLOR);
        this.jqsbOpenKeyStore.setOpaque(false);
        ImageIcon openDefaultImage = new ImageIcon(toolKit.createImage(this.getClass().getResource("images/opendefault.png")));
        ImageIcon openDefaultImageRollOver = new ImageIcon(toolKit.createImage(this.getClass().getResource("images/opendefault_rollover.png")));
        this.jqsbOpenDefaultKeyStore = new JQuickStartButton(new OpenDefaultAction(this.kseFrame), res.getString("JQuickStartPane.jqsbOpenDefaultKeyStore.text"), openDefaultImage, openDefaultImageRollOver, TEXT_COLOR, TEXT_ROLLOVER_COLOR);
        this.jqsbOpenDefaultKeyStore.setOpaque(false);
        ImageIcon openCaCertificatesImage = new ImageIcon(toolKit.createImage(this.getClass().getResource("images/opencacerts.png")));
        ImageIcon openCaCertificatesImageRollOver = new ImageIcon(toolKit.createImage(this.getClass().getResource("images/opencacerts_rollover.png")));
        this.jqsbOpenCaCertificatesKeyStore = new JQuickStartButton(new OpenCaCertificatesAction(this.kseFrame), res.getString("JQuickStartPane.jqsbOpenCaCertificatesKeyStore.text"), openCaCertificatesImage, openCaCertificatesImageRollOver, TEXT_COLOR, TEXT_ROLLOVER_COLOR);
        this.jqsbOpenCaCertificatesKeyStore.setOpaque(false);
        ImageIcon examineCertificateImage = new ImageIcon(toolKit.createImage(this.getClass().getResource("images/examinecert.png")));
        ImageIcon examineCertificateImageRollOver = new ImageIcon(toolKit.createImage(this.getClass().getResource("images/examinecert_rollover.png")));
        this.jqsbExamineCertificate = new JQuickStartButton(new ExamineFileAction(this.kseFrame), res.getString("JQuickStartPane.jqsbExamineCertificate.text"), examineCertificateImage, examineCertificateImageRollOver, TEXT_COLOR, TEXT_ROLLOVER_COLOR);
        this.jqsbExamineCertificate.setOpaque(false);
        ImageIcon helpImage = new ImageIcon(toolKit.createImage(this.getClass().getResource("images/help.png")));
        ImageIcon helpImageRollOver = new ImageIcon(toolKit.createImage(this.getClass().getResource("images/help_rollover.png")));
        this.jqsbHelp = new JQuickStartButton(new HelpAction(this.kseFrame), res.getString("JQuickStartPane.jqsbHelp.text"), helpImage, helpImageRollOver, TEXT_COLOR, TEXT_ROLLOVER_COLOR);
        this.jqsbHelp.setOpaque(false);
        GridBagConstraints gbc_jqslHeading = new GridBagConstraints();
        gbc_jqslHeading.gridheight = 1;
        gbc_jqslHeading.gridwidth = 3;
        gbc_jqslHeading.gridx = 0;
        gbc_jqslHeading.gridy = 0;
        gbc_jqslHeading.insets = new Insets(0, 0, 20, 0);
        GridBagConstraints gbc_jqsbNewKeyStore = new GridBagConstraints();
        gbc_jqsbNewKeyStore.gridheight = 1;
        gbc_jqsbNewKeyStore.gridwidth = 1;
        gbc_jqsbNewKeyStore.gridx = 0;
        gbc_jqsbNewKeyStore.gridy = 1;
        gbc_jqsbNewKeyStore.insets = new Insets(0, 0, 10, 10);
        GridBagConstraints gbc_jqsbOpenKeyStore = new GridBagConstraints();
        gbc_jqsbOpenKeyStore.gridheight = 1;
        gbc_jqsbOpenKeyStore.gridwidth = 1;
        gbc_jqsbOpenKeyStore.gridx = 1;
        gbc_jqsbOpenKeyStore.gridy = 1;
        gbc_jqsbOpenKeyStore.insets = new Insets(0, 10, 10, 10);
        GridBagConstraints gbc_jqsbOpenDefaultKeyStore = new GridBagConstraints();
        gbc_jqsbOpenDefaultKeyStore.gridheight = 1;
        gbc_jqsbOpenDefaultKeyStore.gridwidth = 1;
        gbc_jqsbOpenDefaultKeyStore.gridx = 2;
        gbc_jqsbOpenDefaultKeyStore.gridy = 1;
        gbc_jqsbOpenDefaultKeyStore.insets = new Insets(0, 10, 10, 10);
        GridBagConstraints gbc_jqsbOpenCaCertificatesKeyStore = new GridBagConstraints();
        gbc_jqsbOpenCaCertificatesKeyStore.gridheight = 1;
        gbc_jqsbOpenCaCertificatesKeyStore.gridwidth = 1;
        gbc_jqsbOpenCaCertificatesKeyStore.gridx = 0;
        gbc_jqsbOpenCaCertificatesKeyStore.gridy = 2;
        gbc_jqsbOpenCaCertificatesKeyStore.insets = new Insets(10, 0, 0, 10);
        GridBagConstraints gbc_jqsbExamineCertificate = new GridBagConstraints();
        gbc_jqsbExamineCertificate.gridheight = 1;
        gbc_jqsbExamineCertificate.gridwidth = 1;
        gbc_jqsbExamineCertificate.gridx = 1;
        gbc_jqsbExamineCertificate.gridy = 2;
        gbc_jqsbExamineCertificate.insets = new Insets(10, 10, 0, 10);
        GridBagConstraints gbc_jqsbHelp = new GridBagConstraints();
        gbc_jqsbHelp.gridheight = 1;
        gbc_jqsbHelp.gridwidth = 1;
        gbc_jqsbHelp.gridx = 2;
        gbc_jqsbHelp.gridy = 2;
        gbc_jqsbHelp.insets = new Insets(10, 10, 0, 0);
        this.jpQuickStart = new JPanel(new GridBagLayout());
        this.jpQuickStart.setOpaque(false);
        this.jpQuickStart.add((Component)this.jqslHeading, gbc_jqslHeading);
        this.jpQuickStart.add((Component)this.jqsbNewKeyStore, gbc_jqsbNewKeyStore);
        this.jpQuickStart.add((Component)this.jqsbOpenKeyStore, gbc_jqsbOpenKeyStore);
        this.jpQuickStart.add((Component)this.jqsbOpenDefaultKeyStore, gbc_jqsbOpenDefaultKeyStore);
        this.jpQuickStart.add((Component)this.jqsbOpenCaCertificatesKeyStore, gbc_jqsbOpenCaCertificatesKeyStore);
        this.jpQuickStart.add((Component)this.jqsbExamineCertificate, gbc_jqsbExamineCertificate);
        this.jpQuickStart.add((Component)this.jqsbHelp, gbc_jqsbHelp);
        this.jpNonResizeCenterHorizontally = new JPanel(new FlowLayout(1, 0, 0));
        this.jpNonResizeCenterHorizontally.setOpaque(false);
        this.jpNonResizeCenterHorizontally.add(this.jpQuickStart);
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalGlue());
        this.add(this.jpNonResizeCenterHorizontally);
    }

    @Override
    public void drop(DropTargetDropEvent evt) {
        DroppedFileHandler.drop(evt, this.kseFrame);
    }

    @Override
    public void dragEnter(DropTargetDragEvent evt) {
    }

    @Override
    public void dragExit(DropTargetEvent evt) {
    }

    @Override
    public void dragOver(DropTargetDragEvent evt) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent evt) {
    }
}

