/*
 * Decompiled with CFR 0.152.
 */
package org.kse.utilities.asn1;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERVisibleString;
import org.kse.crypto.x509.X509Ext;
import org.kse.utilities.asn1.Asn1Exception;
import org.kse.utilities.io.HexUtil;
import org.kse.utilities.io.IndentChar;
import org.kse.utilities.io.IndentSequence;
import org.kse.utilities.oid.ObjectIdUtil;

public class Asn1Dump {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/utilities/asn1/resources");
    private IndentSequence indentSequence;
    private int indentLevel = -1;
    private static final String NEWLINE = "\n";

    public Asn1Dump() {
        this.indentSequence = new IndentSequence(IndentChar.SPACE, 4);
    }

    public Asn1Dump(IndentSequence indentSequence) {
        this.indentSequence = indentSequence;
    }

    public String dump(X509Certificate certificate) throws Asn1Exception, IOException {
        try {
            return this.dump(certificate.getEncoded());
        }
        catch (IOException | CertificateEncodingException ex) {
            throw new Asn1Exception(res.getString("NoAsn1DumpObject.exception.message"), ex);
        }
    }

    public String dump(X509CRL crl) throws Asn1Exception, IOException {
        try {
            return this.dump(crl.getEncoded());
        }
        catch (IOException | CRLException ex) {
            throw new Asn1Exception(res.getString("NoAsn1DumpObject.exception.message"), ex);
        }
    }

    public String dump(X509Ext extension) throws Asn1Exception, IOException {
        try {
            ASN1OctetString octetString = ASN1OctetString.getInstance((Object)extension.getValue());
            byte[] octets = octetString.getOctets();
            return this.dump(octets);
        }
        catch (IOException ex) {
            throw new Asn1Exception(res.getString("NoAsn1DumpObject.exception.message"), ex);
        }
    }

    public String dump(PrivateKey privateKey) throws Asn1Exception, IOException {
        return this.dump(privateKey.getEncoded());
    }

    public String dump(PublicKey publicKey) throws Asn1Exception, IOException {
        return this.dump(publicKey.getEncoded());
    }

    public String dump(byte[] der) throws Asn1Exception, IOException {
        try {
            ASN1Primitive derObject = ASN1Primitive.fromByteArray((byte[])der);
            if (derObject.getEncoded().length < der.length) {
                throw new Asn1Exception(res.getString("NoAsn1DumpObject.exception.message"));
            }
            return this.dump(derObject);
        }
        catch (IOException ex) {
            throw new Asn1Exception(res.getString("NoAsn1DumpObject.exception.message"), ex);
        }
    }

    public String dump(ASN1Primitive asn1Object) throws Asn1Exception, IOException {
        try {
            ++this.indentLevel;
            if (asn1Object instanceof DERBitString) {
                String string = this.dumpBitString((DERBitString)asn1Object);
                return string;
            }
            if (asn1Object instanceof ASN1String) {
                String string = this.dumpString((ASN1String)asn1Object);
                return string;
            }
            if (asn1Object instanceof ASN1UTCTime) {
                String string = this.dumpUTCTime((ASN1UTCTime)asn1Object);
                return string;
            }
            if (asn1Object instanceof ASN1GeneralizedTime) {
                String string = this.dumpGeneralizedTime((ASN1GeneralizedTime)asn1Object);
                return string;
            }
            if (asn1Object instanceof ASN1Sequence || asn1Object instanceof ASN1Set) {
                String string = this.dumpSetOrSequence((ASN1Encodable)asn1Object);
                return string;
            }
            if (asn1Object instanceof ASN1TaggedObject) {
                String string = this.dumpTaggedObject((ASN1TaggedObject)asn1Object);
                return string;
            }
            if (asn1Object instanceof ASN1Boolean) {
                String string = this.dumpBoolean((ASN1Boolean)asn1Object);
                return string;
            }
            if (asn1Object instanceof ASN1Enumerated) {
                String string = this.dumpEnumerated((ASN1Enumerated)asn1Object);
                return string;
            }
            if (asn1Object instanceof ASN1Integer) {
                String string = this.dumpInteger((ASN1Integer)asn1Object);
                return string;
            }
            if (asn1Object instanceof ASN1Null) {
                String string = this.dumpNull();
                return string;
            }
            if (asn1Object instanceof ASN1ObjectIdentifier) {
                String string = this.dumpObjectIdentifier((ASN1ObjectIdentifier)asn1Object);
                return string;
            }
            if (asn1Object instanceof ASN1OctetString) {
                String string = this.dumpOctetString((ASN1OctetString)asn1Object);
                return string;
            }
            throw new Asn1Exception("Unknown ASN.1 object: " + asn1Object.toString());
        }
        finally {
            --this.indentLevel;
        }
    }

    private String dumpTaggedObject(ASN1TaggedObject o) throws Asn1Exception, IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.indentSequence.toString(this.indentLevel));
        if (o instanceof BERTaggedObject) {
            sb.append("BER TAGGED [");
        } else {
            sb.append("TAGGED [");
        }
        sb.append(Integer.toString(o.getTagNo()));
        sb.append(']');
        if (!o.isExplicit()) {
            sb.append(" IMPLICIT ");
        }
        sb.append(":");
        sb.append(NEWLINE);
        sb.append(this.dump(o.getObject()));
        return sb.toString();
    }

    private String dumpOctetString(ASN1OctetString asn1OctetString) throws IOException {
        StringBuilder sb = new StringBuilder();
        byte[] bytes = asn1OctetString.getOctets();
        sb.append(this.indentSequence.toString(this.indentLevel));
        sb.append("OCTET STRING");
        try {
            String encapsulated = this.dump(bytes);
            sb.append(", encapsulates:");
            sb.append(NEWLINE);
            sb.append(encapsulated);
        }
        catch (Exception e) {
            sb.append("=");
            if (bytes.length < 8) {
                sb.append(HexUtil.getHexString(bytes));
            }
            sb.append(NEWLINE);
            sb.append(this.dumpHexClear(bytes));
        }
        sb.append(NEWLINE);
        return sb.toString();
    }

    private String dumpBitString(DERBitString asn1BitString) throws IOException {
        StringBuilder sb = new StringBuilder();
        byte[] bytes = asn1BitString.getBytes();
        sb.append(this.indentSequence.toString(this.indentLevel));
        sb.append("BIT STRING");
        try {
            String dump = this.dump(bytes);
            sb.append(", encapsulates:");
            sb.append(NEWLINE);
            sb.append(dump);
        }
        catch (Exception e) {
            sb.append("=");
            if (bytes.length < 8) {
                sb.append(new BigInteger(1, bytes).toString(2));
            }
            sb.append(NEWLINE);
            sb.append(this.dumpHexClear(bytes));
        }
        sb.append(NEWLINE);
        return sb.toString();
    }

    private String dumpObjectIdentifier(ASN1ObjectIdentifier asn1ObjectIdentifier) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.indentSequence.toString(this.indentLevel));
        sb.append("OBJECT IDENTIFIER=");
        sb.append(ObjectIdUtil.toString(asn1ObjectIdentifier));
        sb.append(NEWLINE);
        return sb.toString();
    }

    private String dumpNull() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.indentSequence.toString(this.indentLevel));
        sb.append("NULL");
        sb.append(NEWLINE);
        return sb.toString();
    }

    private String dumpInteger(ASN1Integer asn1Integer) throws IOException {
        StringBuilder sb = new StringBuilder();
        BigInteger value = asn1Integer.getValue();
        sb.append(this.indentSequence.toString(this.indentLevel));
        sb.append("INTEGER=");
        if (value.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) == -1) {
            sb.append(value.toString(10));
            if (value.longValue() >= 10L) {
                sb.append(" (0x").append(value.toString(16)).append(")");
            }
        } else {
            sb.append(NEWLINE);
            sb.append(this.dumpHexClear(value.toByteArray()));
        }
        sb.append(NEWLINE);
        return sb.toString();
    }

    private String dumpEnumerated(ASN1Enumerated asn1Enumerated) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.indentSequence.toString(this.indentLevel));
        sb.append("ENUMERATED=");
        sb.append(asn1Enumerated.getValue());
        sb.append(NEWLINE);
        return sb.toString();
    }

    private String dumpBoolean(ASN1Boolean asn1Boolean) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.indentSequence.toString(this.indentLevel));
        sb.append("BOOLEAN=");
        sb.append(asn1Boolean.isTrue());
        sb.append(NEWLINE);
        return sb.toString();
    }

    private String dumpSetOrSequence(ASN1Encodable asn1ConstructedType) throws Asn1Exception, IOException {
        Enumeration components;
        StringBuilder sb = new StringBuilder();
        sb.append(this.indentSequence.toString(this.indentLevel));
        if (asn1ConstructedType instanceof ASN1Sequence) {
            sb.append("SEQUENCE");
            ASN1Sequence sequence = (ASN1Sequence)asn1ConstructedType;
            components = sequence.getObjects();
        } else {
            sb.append("SET");
            ASN1Set set = (ASN1Set)asn1ConstructedType;
            components = set.getObjects();
        }
        sb.append(NEWLINE);
        sb.append(this.indentSequence.toString(this.indentLevel));
        sb.append("{");
        sb.append(NEWLINE);
        while (components.hasMoreElements()) {
            ASN1Primitive component = (ASN1Primitive)components.nextElement();
            sb.append(this.dump(component));
        }
        sb.append(this.indentSequence.toString(this.indentLevel));
        sb.append("}");
        sb.append(NEWLINE);
        return sb.toString();
    }

    private String dumpUTCTime(ASN1UTCTime asn1Time) {
        Date date;
        StringBuilder sb = new StringBuilder();
        sb.append(this.indentSequence.toString(this.indentLevel));
        sb.append("UTC TIME=");
        try {
            date = asn1Time.getDate();
        }
        catch (ParseException e) {
            throw new RuntimeException("Cannot parse utc time");
        }
        String formattedDate = new SimpleDateFormat("dd/MMM/yyyy HH:mm:ss z").format(date);
        sb.append(formattedDate);
        sb.append(" (");
        sb.append(asn1Time.getTime());
        sb.append(")");
        sb.append(NEWLINE);
        return sb.toString();
    }

    private String dumpGeneralizedTime(ASN1GeneralizedTime asn1Time) {
        Date date;
        StringBuilder sb = new StringBuilder();
        sb.append(this.indentSequence.toString(this.indentLevel));
        sb.append("GENERALIZED TIME=");
        try {
            date = asn1Time.getDate();
        }
        catch (ParseException e) {
            throw new RuntimeException("Cannot parse generalized time");
        }
        String formattedDate = new SimpleDateFormat("dd/MMM/yyyy HH:mm:ss.SSS z").format(date);
        sb.append(formattedDate);
        sb.append(" (");
        sb.append(asn1Time.getTime());
        sb.append(")");
        sb.append(NEWLINE);
        return sb.toString();
    }

    private String dumpString(ASN1String asn1String) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.indentSequence.toString(this.indentLevel));
        if (asn1String instanceof DERBMPString) {
            sb.append("BMP STRING=");
        } else if (asn1String instanceof DERGeneralString) {
            sb.append("GENERAL STRING=");
        } else if (asn1String instanceof DERIA5String) {
            sb.append("IA5 STRING=");
        } else if (asn1String instanceof DERNumericString) {
            sb.append("NUMERIC STRING=");
        } else if (asn1String instanceof DERPrintableString) {
            sb.append("PRINTABLE STRING=");
        } else if (asn1String instanceof DERT61String) {
            sb.append("TELETEX STRING=");
        } else if (asn1String instanceof DERUniversalString) {
            sb.append("UNIVERSAL STRING=");
        } else if (asn1String instanceof DERUTF8String) {
            sb.append("UTF8 STRING=");
        } else if (asn1String instanceof DERVisibleString) {
            sb.append("VISIBLE STRING=");
        } else {
            sb.append("UNKNOWN STRING=");
        }
        sb.append("'");
        sb.append(asn1String.getString());
        sb.append("'");
        sb.append(NEWLINE);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dumpHexClear(byte[] der) throws IOException {
        try {
            ++this.indentLevel;
            String hexClearDump = HexUtil.getHexClearDump(der);
            LineNumberReader lnr = new LineNumberReader(new StringReader(hexClearDump));
            StringBuilder sb = new StringBuilder();
            String line = null;
            boolean firstLine = true;
            while ((line = lnr.readLine()) != null) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    sb.append(NEWLINE);
                }
                sb.append(this.indentSequence.toString(this.indentLevel));
                sb.append(line);
            }
            lnr.close();
            String string = sb.toString();
            return string;
        }
        finally {
            --this.indentLevel;
        }
    }
}

