/*
 * Decompiled with CFR 0.152.
 */
package org.kse.utilities.net;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.kse.utilities.net.PacProxyException;

public class PacProxySelector
extends ProxySelector {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/utilities/net/resources");
    private Invocable pacScript;
    private String pacUrl;

    public PacProxySelector(String pacUrl) {
        if (pacUrl == null) {
            throw new NullPointerException();
        }
        this.pacUrl = pacUrl;
    }

    @Override
    public List<Proxy> select(URI uri) {
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        if (this.pacScript == null) {
            try {
                this.pacScript = this.compilePacScript(this.loadPacScript(this.pacUrl));
            }
            catch (PacProxyException ex) {
                ex.printStackTrace();
                proxies.add(Proxy.NO_PROXY);
                return proxies;
            }
        }
        String pacFunctionReturn = null;
        try {
            pacFunctionReturn = (String)this.pacScript.invokeFunction("FindProxyForURL", uri.toString(), uri.getHost());
        }
        catch (NoSuchMethodException | ScriptException ex) {
            ex.printStackTrace();
            proxies.add(Proxy.NO_PROXY);
            return proxies;
        }
        if (pacFunctionReturn == null) {
            proxies.add(Proxy.NO_PROXY);
            return proxies;
        }
        proxies.addAll(this.parsePacProxies(pacFunctionReturn));
        if (proxies.isEmpty()) {
            proxies.add(Proxy.NO_PROXY);
        }
        return proxies;
    }

    /*
     * Exception decompiling
     */
    private String loadPacScript(String pacUrl) throws PacProxyException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Invocable compilePacScript(String pacScript) throws PacProxyException {
        try {
            ScriptEngineManager mgr = new ScriptEngineManager();
            ScriptEngine jsEngine = mgr.getEngineByName("JavaScript");
            Invocable invocale = (Invocable)((Object)jsEngine);
            jsEngine.eval(pacScript);
            jsEngine.eval(new InputStreamReader(PacProxySelector.class.getResourceAsStream("pacUtils.js")));
            return invocale;
        }
        catch (ScriptException ex) {
            throw new PacProxyException(res.getString("NoCompilePacScript.exception.message"), ex);
        }
    }

    private List<Proxy> parsePacProxies(String pacFunctionReturn) {
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        StringTokenizer strTok = new StringTokenizer(pacFunctionReturn, ";");
        while (strTok.hasMoreTokens()) {
            Proxy proxy;
            String pacFunctionReturnElement = strTok.nextToken().trim();
            if (pacFunctionReturnElement.length() <= 0 || (proxy = this.parsePacProxy(pacFunctionReturnElement)) == null) continue;
            proxies.add(proxy);
        }
        return proxies;
    }

    private Proxy parsePacProxy(String pacProxy) {
        if (pacProxy.equals("DIRECT")) {
            return Proxy.NO_PROXY;
        }
        String[] split = pacProxy.split(" ", 0);
        if (split.length != 2) {
            return null;
        }
        String proxyTypeStr = split[0];
        String address = split[1];
        Proxy.Type proxyType = null;
        if (proxyTypeStr.equals("PROXY")) {
            proxyType = Proxy.Type.HTTP;
        } else if (proxyTypeStr.equals("SOCKS")) {
            proxyType = Proxy.Type.SOCKS;
        }
        if (proxyType == null) {
            return null;
        }
        split = address.split(":", 0);
        String host = null;
        int port = 80;
        if (split.length == 1) {
            host = split[0];
        } else if (split.length == 2) {
            host = split[0];
            try {
                port = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        } else {
            return null;
        }
        return new Proxy(proxyType, new InetSocketAddress(host, port));
    }

    @Override
    public void connectFailed(URI uri, SocketAddress socketAddress, IOException ioException) {
    }

    public String getPacUrl() {
        return this.pacUrl;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PacProxySelector)) {
            return false;
        }
        PacProxySelector cmpPacProxySelector = (PacProxySelector)object;
        return this.getPacUrl().equals(cmpPacProxySelector.getPacUrl());
    }
}

