/*
 * Decompiled with CFR 0.152.
 */
package org.kse.utilities.ssl;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class CustomSslSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory sslSocketFactory;
    private HandshakeCompletedListener handshakeListener;
    private boolean sniEnabled;

    public CustomSslSocketFactory(SSLSocketFactory sslSocketFactory, HandshakeCompletedListener handshakeListener, boolean sniEnabled) {
        this.sslSocketFactory = sslSocketFactory;
        this.handshakeListener = handshakeListener;
        this.sniEnabled = sniEnabled;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocket socket = (SSLSocket)this.sslSocketFactory.createSocket(s, host, port, autoClose);
        if (!this.sniEnabled) {
            this.disableSNI(socket);
        }
        if (this.handshakeListener != null) {
            socket.addHandshakeCompletedListener(this.handshakeListener);
        }
        return socket;
    }

    private void disableSNI(SSLSocket socket) {
        SSLParameters sslParameters = socket.getSSLParameters();
        try {
            Method setServerNamesMethod = sslParameters.getClass().getMethod("setServerNames", List.class);
            setServerNamesMethod.invoke((Object)sslParameters, new ArrayList());
            socket.setSSLParameters(sslParameters);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Socket createSocket(String paramString, int paramInt) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.sslSocketFactory.createSocket(paramString, paramInt);
        if (this.handshakeListener != null) {
            socket.addHandshakeCompletedListener(this.handshakeListener);
        }
        return socket;
    }

    @Override
    public Socket createSocket(String paramString, int paramInt1, InetAddress paramInetAddress, int paramInt2) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.sslSocketFactory.createSocket(paramString, paramInt1, paramInetAddress, paramInt2);
        if (this.handshakeListener != null) {
            socket.addHandshakeCompletedListener(this.handshakeListener);
        }
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress paramInetAddress, int paramInt) throws IOException {
        SSLSocket socket = (SSLSocket)this.sslSocketFactory.createSocket(paramInetAddress, paramInt);
        if (this.handshakeListener != null) {
            socket.addHandshakeCompletedListener(this.handshakeListener);
        }
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress paramInetAddress1, int paramInt1, InetAddress paramInetAddress2, int paramInt2) throws IOException {
        SSLSocket socket = (SSLSocket)this.sslSocketFactory.createSocket(paramInetAddress1, paramInt1, paramInetAddress2, paramInt2);
        if (this.handshakeListener != null) {
            socket.addHandshakeCompletedListener(this.handshakeListener);
        }
        return socket;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslSocketFactory.getSupportedCipherSuites();
    }
}

