/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto;

import java.util.ResourceBundle;

public class Password {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/resources");
    private char[] wrappedPassword;
    private boolean nulled;

    public Password(char[] password) {
        this.wrappedPassword = password;
        this.nulled = false;
    }

    public Password(Password password) {
        if (password.isNulled()) {
            this.nulled = true;
            this.wrappedPassword = new char[]{'\u0000'};
        } else {
            char[] wrappedPwd = password.toCharArray();
            if (wrappedPwd != null) {
                this.wrappedPassword = new char[wrappedPwd.length];
                System.arraycopy(wrappedPwd, 0, this.wrappedPassword, 0, this.wrappedPassword.length);
            }
        }
    }

    public char[] toCharArray() throws IllegalStateException {
        if (this.nulled) {
            throw new IllegalStateException(res.getString("NoGetPasswordNulled.message"));
        }
        return this.wrappedPassword;
    }

    public byte[] toByteArray() throws IllegalStateException {
        if (this.nulled) {
            throw new IllegalStateException(res.getString("NoGetPasswordNulled.message"));
        }
        if (this.wrappedPassword == null) {
            return null;
        }
        byte[] passwordBytes = new byte[this.wrappedPassword.length];
        for (int i = 0; i < this.wrappedPassword.length; ++i) {
            passwordBytes[i] = (byte)this.wrappedPassword[i];
        }
        return passwordBytes;
    }

    public void nullPassword() {
        if (this.wrappedPassword == null) {
            return;
        }
        for (int i = 0; i < this.wrappedPassword.length; ++i) {
            this.wrappedPassword[i] = '\u0000';
        }
        this.nulled = true;
    }

    public boolean isNulled() {
        return this.nulled;
    }

    public boolean isEmpty() {
        return this.wrappedPassword.length == 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Password)) {
            return false;
        }
        Password password = (Password)object;
        if (password.wrappedPassword == null) {
            return this.wrappedPassword == null;
        }
        if (this.wrappedPassword.length != password.wrappedPassword.length) {
            return false;
        }
        for (int i = 0; i < this.wrappedPassword.length; ++i) {
            if (this.wrappedPassword[i] == password.wrappedPassword[i]) continue;
            return false;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.nullPassword();
    }
}

