/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.ecc;

import java.io.IOException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.kse.crypto.ecc.CurveSet;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.version.JavaVersion;

public class EccUtil {
    private static boolean sunECProviderAvailable = true;
    private static String[] availableSunCurves = new String[0];

    private EccUtil() {
    }

    public static String getNamedCurve(Key key) {
        if (!(key instanceof ECKey)) {
            throw new InvalidParameterException("Not a EC private key.");
        }
        ECKey ecKey = (ECKey)((Object)key);
        ECParameterSpec params = ecKey.getParams();
        if (!(params instanceof ECNamedCurveSpec)) {
            return "";
        }
        ECNamedCurveSpec ecPrivateKeySpec = (ECNamedCurveSpec)params;
        String namedCurve = ecPrivateKeySpec.getName();
        return namedCurve;
    }

    public static boolean isECAvailable(KeyStoreType keyStoreType) {
        return JavaVersion.getJreVersion().isAtLeast(JavaVersion.JRE_VERSION_170) && sunECProviderAvailable || EccUtil.isBouncyCastleKeyStore(keyStoreType);
    }

    public static boolean isBouncyCastleKeyStore(KeyStoreType keyStoreType) {
        return keyStoreType == KeyStoreType.BKS || keyStoreType == KeyStoreType.BKS_V1 || keyStoreType == KeyStoreType.UBER || keyStoreType == KeyStoreType.BCFKS;
    }

    public static boolean isCurveAvailable(String curveName, KeyStoreType keyStoreType) {
        if (EccUtil.isBouncyCastleKeyStore(keyStoreType)) {
            return true;
        }
        if (availableSunCurves.length == 0) {
            return false;
        }
        for (String curve : availableSunCurves) {
            if (!curve.contains(curveName)) continue;
            return true;
        }
        return false;
    }

    public static String findLongestCurveName() {
        String longestCurveName = "";
        for (CurveSet curveSet : CurveSet.values()) {
            List<String> curveNames = curveSet.getAllCurveNames();
            for (String curveName : curveNames) {
                if (curveName.length() <= longestCurveName.length()) continue;
                longestCurveName = curveName;
            }
        }
        return longestCurveName;
    }

    public static ECPrivateKey convertToECPrivateKeyStructure(java.security.interfaces.ECPrivateKey ecPrivateKey) throws IOException {
        byte[] encoded = ecPrivateKey.getEncoded();
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)encoded);
        ASN1Encodable privateKey = privateKeyInfo.parsePrivateKey();
        return ECPrivateKey.getInstance((Object)privateKey);
    }

    static {
        Provider sunECProvider = Security.getProvider("SunEC");
        if (sunECProvider != null) {
            availableSunCurves = sunECProvider.getProperty("AlgorithmParameters.EC SupportedCurves").split("\\|");
        } else {
            sunECProviderAvailable = false;
        }
    }
}

