/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.keystore;

import java.util.ResourceBundle;
import org.kse.crypto.ecc.EccUtil;
import org.kse.crypto.filetype.CryptoFileType;

public enum KeyStoreType {
    JKS("JKS", "KeyStoreType.Jks", true, CryptoFileType.JKS_KS),
    JCEKS("JCEKS", "KeyStoreType.Jceks", true, CryptoFileType.JCEKS_KS),
    PKCS12("PKCS12", "KeyStoreType.Pkcs12", true, CryptoFileType.PKCS12_KS),
    BKS_V1("BKS-V1", "KeyStoreType.BksV1", true, CryptoFileType.BKS_V1_KS),
    BKS("BKS", "KeyStoreType.Bks", true, CryptoFileType.BKS_KS),
    UBER("UBER", "KeyStoreType.Uber", true, CryptoFileType.UBER_KS),
    KEYCHAIN("KeychainStore", "KeyStoreType.AppleKeyChain", false, null),
    MS_CAPI_PERSONAL("Windows-MY", "KeyStoreType.MscapiPersonalCerts", false, null),
    MS_CAPI_ROOT("Windows-ROOT", "Windows Root Certificates", false, null),
    PKCS11("PKCS11", "KeyStoreType.Pkcs11", false, null),
    BCFKS("BCFKS", "KeyStoreType.Bcfks", true, CryptoFileType.BCFKS_KS),
    UNKNOWN("UNKNOWN", "KeyStoreType.Unknown", false, null);

    private static ResourceBundle res;
    private String jce;
    private String friendlyKey;
    private boolean fileBased;
    private CryptoFileType cryptoFileType;

    private KeyStoreType(String jce, String friendlyKey, boolean fileBased, CryptoFileType cryptoFileType) {
        this.jce = jce;
        this.friendlyKey = friendlyKey;
        this.fileBased = fileBased;
        this.cryptoFileType = cryptoFileType;
    }

    public String jce() {
        return this.jce;
    }

    public String friendly() {
        return res.getString(this.friendlyKey);
    }

    public boolean isFileBased() {
        return this.fileBased;
    }

    public boolean hasEntryPasswords() {
        return this != PKCS11 && this != MS_CAPI_PERSONAL;
    }

    public boolean hasExportablePrivateKeys() {
        return this != PKCS11 && this != MS_CAPI_PERSONAL;
    }

    public boolean supportsKeyEntries() {
        return this == JCEKS || this == BKS || this == BKS_V1 || this == UBER || this == BCFKS || this == PKCS12;
    }

    public boolean supportsECC() {
        return EccUtil.isECAvailable(this);
    }

    public boolean supportsNamedCurve(String curveName) {
        return EccUtil.isCurveAvailable(curveName, this);
    }

    public static KeyStoreType resolveJce(String jce) {
        for (KeyStoreType keyStoreType : KeyStoreType.values()) {
            if (!jce.equals(keyStoreType.jce())) continue;
            return keyStoreType;
        }
        return UNKNOWN;
    }

    public CryptoFileType getCryptoFileType() {
        return this.cryptoFileType;
    }

    public String toString() {
        return this.jce();
    }

    static {
        res = ResourceBundle.getBundle("org/kse/crypto/keystore/resources");
    }
}

