/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.privatekey;

import java.util.ResourceBundle;
import org.kse.crypto.privatekey.PbeType;

public enum OpenSslPbeType implements PbeType
{
    DES_CBC("DES-CBC", "DES/CBC/PKCS5Padding", 64, 64, "OpenSslPbeType.PbeWithDesCbc"),
    DESEDE_CBC("DES-EDE3-CBC", "DESede/CBC/PKCS5Padding", 192, 64, "OpenSslPbeType.PbeWithDesedeCbc"),
    AES_128BIT_CBC("AES-128-CBC", "AES/CBC/PKCS5Padding", 128, 128, "OpenSslPbeType.PbeWith128BitAesCbc"),
    AES_192BIT_CBC("AES-192-CBC", "AES/CBC/PKCS5Padding", 192, 128, "OpenSslPbeType.PbeWith192BitAesCbc"),
    AES_256BIT_CBC("AES-256-CBC", "AES/CBC/PKCS5Padding", 256, 128, "OpenSslPbeType.PbeWith1256itAesCbc");

    private static ResourceBundle res;
    private String dekInfo;
    private String jceCipher;
    private int keySize;
    private int saltSize;
    private String friendlyKey;

    private OpenSslPbeType(String dekInfo, String jceCipher, int keySize, int saltSize, String friendlyKey) {
        this.dekInfo = dekInfo;
        this.jceCipher = jceCipher;
        this.keySize = keySize;
        this.saltSize = saltSize;
        this.friendlyKey = friendlyKey;
    }

    public String dekInfo() {
        return this.dekInfo;
    }

    public String jceCipher() {
        return this.jceCipher;
    }

    public int keySize() {
        return this.keySize;
    }

    public int saltSize() {
        return this.saltSize;
    }

    @Override
    public String friendly() {
        return res.getString(this.friendlyKey);
    }

    public static OpenSslPbeType resolveDekInfo(String dekInfo) {
        for (OpenSslPbeType pbeType : OpenSslPbeType.values()) {
            if (!dekInfo.equals(pbeType.dekInfo())) continue;
            return pbeType;
        }
        return null;
    }

    public String toString() {
        return this.friendly();
    }

    static {
        res = ResourceBundle.getBundle("org/kse/crypto/privatekey/resources");
    }
}

