/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.signing;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.kse.crypto.digest.DigestType;

public enum SignatureType {
    SHA1_DSA("SHA1withDSA", "1.2.840.10040.4.3", DigestType.SHA1, "SignatureType.Sha1WithDsa"),
    SHA224_DSA("SHA224withDSA", "2.16.840.1.101.3.4.3.1", DigestType.SHA224, "SignatureType.Sha224WithDsa"),
    SHA256_DSA("SHA256withDSA", "2.16.840.1.101.3.4.3.2", DigestType.SHA256, "SignatureType.Sha256WithDsa"),
    SHA384_DSA("SHA384withDSA", "2.16.840.1.101.3.4.3.3", DigestType.SHA384, "SignatureType.Sha384WithDsa"),
    SHA512_DSA("SHA512withDSA", "2.16.840.1.101.3.4.3.4", DigestType.SHA512, "SignatureType.Sha512WithDsa"),
    MD2_RSA("MD2withRSA", "1.2.840.113549.1.1.2", DigestType.MD2, "SignatureType.Md2WithRsa"),
    MD5_RSA("MD5withRSA", "1.2.840.113549.1.1.4", DigestType.MD5, "SignatureType.Md5WithRsa"),
    RIPEMD128_RSA("RIPEMD128withRSA", "1.3.36.3.3.1.3", DigestType.RIPEMD128, "SignatureType.Ripemd128WithRsa"),
    RIPEMD160_RSA("RIPEMD160withRSA", "1.3.36.3.3.1.2", DigestType.RIPEMD160, "SignatureType.Ripemd160WithRsa"),
    RIPEMD256_RSA("RIPEMD256withRSA", "1.3.36.3.3.1.4", DigestType.RIPEMD256, "SignatureType.Ripemd256WithRsa"),
    SHA1_RSA("SHA1withRSA", "1.2.840.113549.1.1.5", DigestType.SHA1, "SignatureType.Sha1WithRsa"),
    SHA224_RSA("SHA224withRSA", "1.2.840.113549.1.1.14", DigestType.SHA224, "SignatureType.Sha224WithRsa"),
    SHA256_RSA("SHA256withRSA", "1.2.840.113549.1.1.11", DigestType.SHA256, "SignatureType.Sha256WithRsa"),
    SHA384_RSA("SHA384withRSA", "1.2.840.113549.1.1.12", DigestType.SHA384, "SignatureType.Sha384WithRsa"),
    SHA512_RSA("SHA512withRSA", "1.2.840.113549.1.1.13", DigestType.SHA512, "SignatureType.Sha512WithRsa"),
    SHA1_ECDSA("SHA1withECDSA", "1.2.840.10045.4.1", DigestType.SHA1, "SignatureType.Sha1WithEcDsa"),
    SHA224_ECDSA("SHA224withECDSA", "1.2.840.10045.4.3.1", DigestType.SHA224, "SignatureType.Sha224WithEcDsa"),
    SHA256_ECDSA("SHA256withECDSA", "1.2.840.10045.4.3.2", DigestType.SHA256, "SignatureType.Sha256WithEcDsa"),
    SHA384_ECDSA("SHA384withECDSA", "1.2.840.10045.4.3.3", DigestType.SHA384, "SignatureType.Sha384WithEcDsa"),
    SHA512_ECDSA("SHA512withECDSA", "1.2.840.10045.4.3.4", DigestType.SHA512, "SignatureType.Sha512WithEcDsa");

    private static ResourceBundle res;
    private String jce;
    private String oid;
    private DigestType digestType;
    private String friendlyKey;

    private SignatureType(String jce, String oid, DigestType digestType, String friendlyKey) {
        this.jce = jce;
        this.oid = oid;
        this.digestType = digestType;
        this.friendlyKey = friendlyKey;
    }

    public String jce() {
        return this.jce;
    }

    public String oid() {
        return this.oid;
    }

    public DigestType digestType() {
        return this.digestType;
    }

    public String friendly() {
        return res.getString(this.friendlyKey);
    }

    public static List<SignatureType> dsaSignatureTypes() {
        ArrayList<SignatureType> signatureTypes = new ArrayList<SignatureType>();
        signatureTypes.add(SHA1_DSA);
        signatureTypes.add(SHA224_DSA);
        signatureTypes.add(SHA256_DSA);
        signatureTypes.add(SHA384_DSA);
        signatureTypes.add(SHA512_DSA);
        return signatureTypes;
    }

    public static List<SignatureType> ecdsaSignatureTypes() {
        ArrayList<SignatureType> signatureTypes = new ArrayList<SignatureType>();
        signatureTypes.add(SHA1_ECDSA);
        signatureTypes.add(SHA256_ECDSA);
        signatureTypes.add(SHA384_ECDSA);
        signatureTypes.add(SHA512_ECDSA);
        return signatureTypes;
    }

    public static List<SignatureType> rsaSignatureTypes() {
        ArrayList<SignatureType> signatureTypes = new ArrayList<SignatureType>();
        signatureTypes.add(MD2_RSA);
        signatureTypes.add(MD5_RSA);
        signatureTypes.add(RIPEMD128_RSA);
        signatureTypes.add(RIPEMD160_RSA);
        signatureTypes.add(RIPEMD256_RSA);
        signatureTypes.add(SHA1_RSA);
        signatureTypes.add(SHA224_RSA);
        signatureTypes.add(SHA256_RSA);
        signatureTypes.add(SHA384_RSA);
        signatureTypes.add(SHA512_RSA);
        return signatureTypes;
    }

    public static List<SignatureType> rsaSignatureTypes(int keySize) {
        List<SignatureType> signatureTypes = SignatureType.rsaSignatureTypes();
        if (keySize < 752) {
            signatureTypes.remove((Object)SHA512_RSA);
        }
        if (keySize < 624) {
            signatureTypes.remove((Object)SHA384_RSA);
        }
        return signatureTypes;
    }

    public static SignatureType resolveJce(String jce) {
        for (SignatureType signatureType : SignatureType.values()) {
            if (!jce.equals(signatureType.jce())) continue;
            return signatureType;
        }
        return null;
    }

    public static SignatureType resolveOid(String oid) {
        for (SignatureType signatureType : SignatureType.values()) {
            if (!oid.equals(signatureType.oid())) continue;
            return signatureType;
        }
        return null;
    }

    public String toString() {
        return this.friendly();
    }

    static {
        res = ResourceBundle.getBundle("org/kse/crypto/signing/resources");
    }
}

