/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.signing;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.encoders.Base64;
import org.kse.crypto.digest.DigestType;

public class TimeStampingClient {
    private TimeStampingClient() {
    }

    public static byte[] getTimeStampToken(String tsaUrl, byte[] data, DigestType hashAlg) throws IOException {
        TimeStampResponse response = null;
        try {
            int value;
            MessageDigest digest = MessageDigest.getInstance(hashAlg.jce());
            byte[] hashValue = digest.digest(data);
            TimeStampRequestGenerator tsqGenerator = new TimeStampRequestGenerator();
            tsqGenerator.setCertReq(true);
            BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
            TimeStampRequest request = tsqGenerator.generate(new ASN1ObjectIdentifier(hashAlg.oid()), hashValue, nonce);
            byte[] requestBytes = request.getEncoded();
            byte[] respBytes = TimeStampingClient.queryServer(tsaUrl, requestBytes);
            response = new TimeStampResponse(respBytes);
            response.validate(request);
            PKIFailureInfo failure = response.getFailInfo();
            int n = value = failure == null ? 0 : failure.intValue();
            if (value != 0) {
                throw new IOException("Server returned error code: " + value);
            }
        }
        catch (NoSuchAlgorithmException | TSPException e) {
            throw new IOException(e);
        }
        TimeStampToken tsToken = response.getTimeStampToken();
        if (tsToken == null) {
            throw new IOException("TSA returned no time stamp token: " + response.getStatusString());
        }
        return tsToken.getEncoded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] queryServer(String tsaUrl, byte[] requestBytes) throws IOException {
        SSLContext sc;
        try {
            sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }}, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        SSLSocketFactory defaultSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        try {
            URL url = new URL(tsaUrl);
            URLConnection con = url.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "application/timestamp-query");
            con.setRequestProperty("Content-Transfer-Encoding", "binary");
            OutputStream out = con.getOutputStream();
            out.write(requestBytes);
            out.close();
            InputStream is = con.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = is.read(buffer, 0, buffer.length)) >= 0) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] respBytes = baos.toByteArray();
            String encoding = con.getContentEncoding();
            if (encoding != null && encoding.equalsIgnoreCase("base64")) {
                respBytes = Base64.decode((String)new String(respBytes));
            }
            byte[] byArray = respBytes;
            return byArray;
        }
        finally {
            HttpsURLConnection.setDefaultSSLSocketFactory(defaultSSLSocketFactory);
        }
    }
}

