/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.x509;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.kse.crypto.x509.X500NameUtils;
import org.kse.utilities.io.HexUtil;
import org.kse.utilities.oid.ObjectIdUtil;

public class GeneralNameUtil {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/x509/resources");
    public static final String UPN_OID = "1.3.6.1.4.1.311.20.2.3";

    private GeneralNameUtil() {
    }

    public static GeneralName fromX500Principal(X500Principal x500Principal) {
        X500Name x500Name = X500NameUtils.x500PrincipalToX500Name(x500Principal);
        return new GeneralName(x500Name);
    }

    public static String safeToString(GeneralName generalName, boolean addLinkForURI) {
        if (generalName == null) {
            return "";
        }
        switch (generalName.getTagNo()) {
            case 4: {
                X500Name directoryName = (X500Name)generalName.getName();
                return MessageFormat.format(res.getString("GeneralNameUtil.DirectoryGeneralName"), directoryName.toString());
            }
            case 2: {
                DERIA5String dnsName = (DERIA5String)generalName.getName();
                return MessageFormat.format(res.getString("GeneralNameUtil.DnsGeneralName"), dnsName.getString());
            }
            case 7: {
                byte[] ipAddressBytes = ((ASN1OctetString)generalName.getName()).getOctets();
                String ipAddressString = "";
                try {
                    ipAddressString = InetAddress.getByAddress(ipAddressBytes).getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                return MessageFormat.format(res.getString("GeneralNameUtil.IpAddressGeneralName"), ipAddressString);
            }
            case 8: {
                ASN1ObjectIdentifier registeredId = (ASN1ObjectIdentifier)generalName.getName();
                return MessageFormat.format(res.getString("GeneralNameUtil.RegisteredIdGeneralName"), ObjectIdUtil.toString(registeredId));
            }
            case 1: {
                DERIA5String rfc822Name = (DERIA5String)generalName.getName();
                return MessageFormat.format(res.getString("GeneralNameUtil.Rfc822GeneralName"), rfc822Name.getString());
            }
            case 6: {
                DERIA5String uri = (DERIA5String)generalName.getName();
                String link = addLinkForURI ? "<a href=\"" + uri.getString() + "\">" + uri.getString() + "</a>" : uri.getString();
                return MessageFormat.format(res.getString("GeneralNameUtil.UriGeneralName"), link);
            }
            case 0: {
                return GeneralNameUtil.parseUPN(generalName);
            }
        }
        return "";
    }

    public static String parseUPN(GeneralName generalName) {
        ASN1Sequence otherName = (ASN1Sequence)generalName.getName();
        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)otherName.getObjectAt(0);
        if (UPN_OID.equals(oid.getId())) {
            ASN1TaggedObject asn1TaggedObject = (ASN1TaggedObject)otherName.getObjectAt(1);
            DERUTF8String upn = DERUTF8String.getInstance((Object)asn1TaggedObject.getObject());
            return MessageFormat.format(res.getString("GeneralNameUtil.OtherGeneralName"), "UPN", upn.getString());
        }
        ASN1Encodable value = otherName.getObjectAt(1);
        try {
            return MessageFormat.format(res.getString("GeneralNameUtil.OtherGeneralName"), ObjectIdUtil.toString(oid), HexUtil.getHexString(value.toASN1Primitive().getEncoded("DER")));
        }
        catch (IOException e) {
            return MessageFormat.format(res.getString("GeneralNameUtil.OtherGeneralName"), ObjectIdUtil.toString(oid), "");
        }
    }

    public static String toString(GeneralName generalName) throws IOException {
        if (generalName == null) {
            return "";
        }
        switch (generalName.getTagNo()) {
            case 5: {
                ASN1Sequence ediPartyName = (ASN1Sequence)generalName.getName();
                DirectoryString nameAssigner = DirectoryString.getInstance((Object)ediPartyName.getObjectAt(0));
                DirectoryString partyName = DirectoryString.getInstance((Object)ediPartyName.getObjectAt(1));
                String nameAssignerStr = null;
                if (nameAssigner != null) {
                    nameAssignerStr = nameAssigner.getString();
                }
                String partyNameStr = partyName.getString();
                if (nameAssignerStr != null) {
                    return MessageFormat.format(res.getString("GeneralNameUtil.EdiPartyGeneralName"), nameAssignerStr, partyNameStr);
                }
                return MessageFormat.format(res.getString("GeneralNameUtil.EdiPartyGeneralNameNoAssigner"), partyNameStr);
            }
            case 0: {
                return GeneralNameUtil.parseUPN(generalName);
            }
            case 3: {
                ASN1Encodable x400Address = generalName.getName();
                return MessageFormat.format(res.getString("GeneralNameUtil.X400AddressGeneralName"), HexUtil.getHexString(x400Address.toASN1Primitive().getEncoded("DER")));
            }
        }
        return GeneralNameUtil.safeToString(generalName, true);
    }
}

