/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.x509;

import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.kse.crypto.CryptoException;
import org.kse.crypto.signing.SignatureType;
import org.kse.crypto.x509.X509CertificateVersion;

public class X509CertificateGenerator {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/x509/resources");
    private X509CertificateVersion version;

    public X509CertificateGenerator(X509CertificateVersion version) {
        this.version = version;
    }

    public X509Certificate generate(X500Name subject, X500Name issuer, Date validityStart, Date validityEnd, PublicKey publicKey, PrivateKey privateKey, SignatureType signatureType, BigInteger serialNumber) throws CryptoException {
        return this.generate(subject, issuer, validityStart, validityEnd, publicKey, privateKey, signatureType, serialNumber, null, (Provider)new BouncyCastleProvider());
    }

    public X509Certificate generate(X500Name subject, X500Name issuer, Date validityStart, Date validityEnd, PublicKey publicKey, PrivateKey privateKey, SignatureType signatureType, BigInteger serialNumber, X509Extension extensions, Provider provider) throws CryptoException {
        if (this.version == X509CertificateVersion.VERSION1) {
            return this.generateVersion1(subject, issuer, validityStart, validityEnd, publicKey, privateKey, signatureType, serialNumber);
        }
        try {
            return this.generateVersion3(subject, issuer, validityStart, validityEnd, publicKey, privateKey, signatureType, serialNumber, extensions, provider);
        }
        catch (CertIOException e) {
            throw new CryptoException(e);
        }
    }

    public X509Certificate generateSelfSigned(X500Name name, long validity, PublicKey publicKey, PrivateKey privateKey, SignatureType signatureType, BigInteger serialNumber) throws CryptoException {
        Date validityStart = new Date();
        Date validityEnd = new Date(validityStart.getTime() + validity);
        return this.generateSelfSigned(name, validityStart, validityEnd, publicKey, privateKey, signatureType, serialNumber);
    }

    public X509Certificate generateSelfSigned(X500Name name, Date validityStart, Date validityEnd, PublicKey publicKey, PrivateKey privateKey, SignatureType signatureType, BigInteger serialNumber) throws CryptoException {
        return this.generateSelfSigned(name, validityStart, validityEnd, publicKey, privateKey, signatureType, serialNumber, null, (Provider)new BouncyCastleProvider());
    }

    public X509Certificate generateSelfSigned(X500Name name, Date validityStart, Date validityEnd, PublicKey publicKey, PrivateKey privateKey, SignatureType signatureType, BigInteger serialNumber, X509Extension extensions, Provider provider) throws CryptoException {
        return this.generate(name, name, validityStart, validityEnd, publicKey, privateKey, signatureType, serialNumber, extensions, provider);
    }

    private X509Certificate generateVersion1(X500Name subject, X500Name issuer, Date validityStart, Date validityEnd, PublicKey publicKey, PrivateKey privateKey, SignatureType signatureType, BigInteger serialNumber) throws CryptoException {
        Date notBefore = validityStart == null ? new Date() : validityStart;
        Date notAfter = validityEnd == null ? new Date(notBefore.getTime() + TimeUnit.DAYS.toMillis(365L)) : validityEnd;
        JcaX509v1CertificateBuilder certBuilder = new JcaX509v1CertificateBuilder(issuer, serialNumber, notBefore, notAfter, subject, publicKey);
        try {
            ContentSigner certSigner = new JcaContentSignerBuilder(signatureType.jce()).setProvider("BC").build(privateKey);
            return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certBuilder.build(certSigner));
        }
        catch (IllegalStateException | CertificateException | OperatorCreationException ex) {
            throw new CryptoException(res.getString("CertificateGenFailed.exception.message"), ex);
        }
    }

    private X509Certificate generateVersion3(X500Name subject, X500Name issuer, Date validityStart, Date validityEnd, PublicKey publicKey, PrivateKey privateKey, SignatureType signatureType, BigInteger serialNumber, X509Extension extensions, Provider provider) throws CryptoException, CertIOException {
        Date notBefore = validityStart == null ? new Date() : validityStart;
        Date notAfter = validityEnd == null ? new Date(notBefore.getTime() + TimeUnit.DAYS.toMillis(365L)) : validityEnd;
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(issuer, serialNumber, notBefore, notAfter, subject, publicKey);
        if (extensions != null) {
            for (String oid : extensions.getCriticalExtensionOIDs()) {
                certBuilder.addExtension(new ASN1ObjectIdentifier(oid), true, this.getExtensionValue(extensions, oid));
            }
            for (String oid : extensions.getNonCriticalExtensionOIDs()) {
                certBuilder.addExtension(new ASN1ObjectIdentifier(oid), false, this.getExtensionValue(extensions, oid));
            }
        }
        try {
            ContentSigner certSigner = null;
            certSigner = provider == null ? new JcaContentSignerBuilder(signatureType.jce()).setProvider("BC").build(privateKey) : new JcaContentSignerBuilder(signatureType.jce()).setProvider(provider).build(privateKey);
            return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certBuilder.build(certSigner));
        }
        catch (IllegalStateException | CertificateException | OperatorCreationException ex) {
            throw new CryptoException(res.getString("CertificateGenFailed.exception.message"), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ASN1Encodable getExtensionValue(X509Extension extensions, String oid) throws CryptoException {
        byte[] octets = ASN1OctetString.getInstance((Object)extensions.getExtensionValue(oid)).getOctets();
        try (ASN1InputStream ais = new ASN1InputStream(octets);){
            ASN1Primitive aSN1Primitive = ais.readObject();
            return aSN1Primitive;
        }
        catch (IOException ex) {
            throw new CryptoException(res.getString("CertificateGenFailed.exception.message"), ex);
        }
    }
}

