/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.x509;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.cert.X509Extension;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.Extension;
import org.kse.crypto.x509.X509ExtensionSetLoadException;

public class X509ExtensionSet
implements X509Extension,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/x509/resources");
    private Map<String, byte[]> criticalExtensions = new HashMap<String, byte[]>();
    private Map<String, byte[]> nonCriticalExtensions = new HashMap<String, byte[]>();
    private static final long FILE_MAGIC_NUMBER = 1200689457L;
    private static final int FILE_VERSION = 1;

    public X509ExtensionSet() {
    }

    public X509ExtensionSet(ASN1Sequence extensions) {
        ASN1Encodable[] asn1Encodables = extensions.toArray();
        for (int i = 0; i < asn1Encodables.length; ++i) {
            ASN1Encodable asn1Encodable = asn1Encodables[i];
            Extension ext = Extension.getInstance((Object)asn1Encodable);
            if (ext == null) continue;
            try {
                this.addExtension(ext.getExtnId().toString(), ext.isCritical(), ext.getExtnValue().getEncoded());
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public X509ExtensionSet(X509Extension extensions) {
        for (String oid : extensions.getCriticalExtensionOIDs()) {
            this.criticalExtensions.put(oid, extensions.getExtensionValue(oid));
        }
        for (String oid : extensions.getNonCriticalExtensionOIDs()) {
            this.nonCriticalExtensions.put(oid, extensions.getExtensionValue(oid));
        }
    }

    public void addExtension(String oid, boolean isCritical, byte[] value) {
        this.removeExtension(oid);
        if (isCritical) {
            this.criticalExtensions.put(oid, value);
        } else {
            this.nonCriticalExtensions.put(oid, value);
        }
    }

    public void removeExtension(String oid) {
        if (this.criticalExtensions.containsKey(oid)) {
            this.criticalExtensions.remove(oid);
        } else if (this.nonCriticalExtensions.containsKey(oid)) {
            this.nonCriticalExtensions.remove(oid);
        }
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        return this.criticalExtensions.keySet();
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        return this.nonCriticalExtensions.keySet();
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        if (this.criticalExtensions.containsKey(oid)) {
            return this.criticalExtensions.get(oid);
        }
        if (this.nonCriticalExtensions.containsKey(oid)) {
            return this.nonCriticalExtensions.get(oid);
        }
        return null;
    }

    public boolean isCritical(String oid) {
        return this.criticalExtensions.containsKey(oid);
    }

    public void toggleExtensionCriticality(String oid) {
        if (this.criticalExtensions.containsKey(oid)) {
            byte[] value = this.criticalExtensions.remove(oid);
            this.nonCriticalExtensions.put(oid, value);
        } else if (this.nonCriticalExtensions.containsKey(oid)) {
            byte[] value = this.nonCriticalExtensions.remove(oid);
            this.criticalExtensions.put(oid, value);
        }
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    public Object clone() {
        try {
            X509ExtensionSet x509ExtensionSet = (X509ExtensionSet)super.clone();
            x509ExtensionSet.criticalExtensions = (HashMap)((HashMap)this.criticalExtensions).clone();
            x509ExtensionSet.nonCriticalExtensions = (HashMap)((HashMap)this.nonCriticalExtensions).clone();
            return x509ExtensionSet;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509ExtensionSet load(InputStream is) throws X509ExtensionSetLoadException, IOException {
        try (DataInputStream dis = new DataInputStream(is);){
            long magicNumber = dis.readLong();
            if (magicNumber != 1200689457L) {
                throw new X509ExtensionSetLoadException(res.getString("NoLoadX509ExtensionSet.BadMagicNumber.exception.message"));
            }
            int version = dis.readInt();
            if (version != 1) {
                throw new X509ExtensionSetLoadException(res.getString("NoLoadX509ExtensionSet.WrongVersion.exception.message"));
            }
            X509ExtensionSet x509ExtensionSet = new X509ExtensionSet();
            x509ExtensionSet.criticalExtensions = X509ExtensionSet.loadExtensions(dis);
            x509ExtensionSet.nonCriticalExtensions = X509ExtensionSet.loadExtensions(dis);
            X509ExtensionSet x509ExtensionSet2 = x509ExtensionSet;
            return x509ExtensionSet2;
        }
        catch (EOFException ex) {
            throw new X509ExtensionSetLoadException(res.getString("NoLoadX509ExtensionSet.NotEnoughBytes.exception.message"));
        }
    }

    private static Map<String, byte[]> loadExtensions(DataInputStream dis) throws IOException {
        HashMap<String, byte[]> extensions = new HashMap<String, byte[]>();
        int extensionCnt = dis.readInt();
        for (int i = 0; i < extensionCnt; ++i) {
            int oidLen = dis.readInt();
            char[] oidChars = new char[oidLen];
            for (int j = 0; j < oidLen; ++j) {
                oidChars[j] = dis.readChar();
            }
            String oid = new String(oidChars);
            int valueLen = dis.readInt();
            byte[] value = new byte[valueLen];
            dis.readFully(value);
            extensions.put(oid, value);
        }
        return extensions;
    }

    public void save(OutputStream os) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(os);){
            dos.writeLong(1200689457L);
            dos.writeInt(1);
            this.saveExtensions(this.criticalExtensions, dos);
            this.saveExtensions(this.nonCriticalExtensions, dos);
        }
    }

    private void saveExtensions(Map<String, byte[]> extensions, DataOutputStream dos) throws IOException {
        dos.writeInt(extensions.size());
        for (String oid : extensions.keySet()) {
            dos.writeInt(oid.length());
            dos.writeChars(oid);
            byte[] value = extensions.get(oid);
            dos.writeInt(value.length);
            dos.write(value);
        }
    }
}

