/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.x509;

import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.HashSet;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.kse.crypto.CryptoException;
import org.kse.crypto.publickey.KeyIdentifierGenerator;
import org.kse.crypto.x509.X509Ext;
import org.kse.crypto.x509.X509ExtensionSet;
import org.kse.crypto.x509.X509ExtensionType;

public class X509ExtensionSetUpdater {
    private X509ExtensionSetUpdater() {
    }

    public static void update(X509ExtensionSet extensionSet, PublicKey subjectPublicKey, PublicKey issuerPublicKey, X500Name issuerCertName, BigInteger issuerCertSerialNumber) throws CryptoException, IOException {
        HashSet<String> allExtensions = new HashSet<String>(extensionSet.getCriticalExtensionOIDs());
        allExtensions.addAll(extensionSet.getNonCriticalExtensionOIDs());
        for (String extensionOid : allExtensions) {
            switch (X509ExtensionType.resolveOid(extensionOid)) {
                case AUTHORITY_KEY_IDENTIFIER: {
                    X509ExtensionSetUpdater.updateAKI(extensionSet, extensionOid, issuerPublicKey, issuerCertName, issuerCertSerialNumber);
                    break;
                }
                case SUBJECT_KEY_IDENTIFIER: {
                    X509ExtensionSetUpdater.updateSKI(extensionSet, extensionOid, subjectPublicKey);
                    break;
                }
            }
        }
    }

    private static void updateSKI(X509ExtensionSet extensionSet, String extensionOid, PublicKey subjectPublicKey) throws CryptoException, IOException {
        KeyIdentifierGenerator skiGenerator = new KeyIdentifierGenerator(subjectPublicKey);
        SubjectKeyIdentifier ski = new SubjectKeyIdentifier(skiGenerator.generate160BitHashId());
        byte[] skiEncoded = X509Ext.wrapInOctetString(ski.getEncoded("DER"));
        extensionSet.addExtension(extensionOid, extensionSet.isCritical(extensionOid), skiEncoded);
    }

    private static void updateAKI(X509ExtensionSet extensionSet, String extensionOid, PublicKey newIssuerPublicKey, X500Name newIssuerCertName, BigInteger newIssuerSerialNumber) throws CryptoException, IOException {
        byte[] extensionValue = X509Ext.unwrapExtension(extensionSet.getExtensionValue(extensionOid));
        AuthorityKeyIdentifier authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance((Object)extensionValue);
        byte[] keyIdentifier = authorityKeyIdentifier.getKeyIdentifier();
        BigInteger authorityCertSerialNumber = authorityKeyIdentifier.getAuthorityCertSerialNumber();
        byte[] newKeyIdentifier = new KeyIdentifierGenerator(newIssuerPublicKey).generate160BitHashId();
        GeneralNames newCertIssuer = new GeneralNames(new GeneralName[]{new GeneralName(newIssuerCertName)});
        authorityKeyIdentifier = keyIdentifier != null && authorityCertSerialNumber == null ? new AuthorityKeyIdentifier(newKeyIdentifier) : (keyIdentifier == null ? new AuthorityKeyIdentifier(newCertIssuer, newIssuerSerialNumber) : new AuthorityKeyIdentifier(newKeyIdentifier, newCertIssuer, newIssuerSerialNumber));
        byte[] encodedValue = X509Ext.wrapInOctetString(authorityKeyIdentifier.getEncoded("DER"));
        extensionSet.addExtension(extensionOid, extensionSet.isCritical(extensionOid), encodedValue);
    }
}

