/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui;

import java.awt.SplashScreen;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOUtils;
import org.kse.ApplicationSettings;
import org.kse.AuthorityCertificates;
import org.kse.KSE;
import org.kse.crypto.jcepolicy.JcePolicyUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.KseRestart;
import org.kse.gui.LnfUtil;
import org.kse.gui.MacOsIntegration;
import org.kse.gui.actions.CheckUpdateAction;
import org.kse.gui.crypto.DUpgradeCryptoStrength;
import org.kse.gui.dnd.DroppedFileHandler;
import org.kse.gui.error.DError;
import org.kse.utilities.os.OperatingSystem;
import org.kse.version.JavaVersion;
import org.kse.version.Version;
import org.kse.version.VersionException;

public class CreateApplicationGui
implements Runnable {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/resources");
    private static final JavaVersion MIN_JRE_VERSION = JavaVersion.JRE_VERSION_170;
    private ApplicationSettings applicationSettings;
    private SplashScreen splash;
    private List<File> parameterFiles;

    public CreateApplicationGui(ApplicationSettings applicationSettings, SplashScreen splash, List<File> parameterFiles) {
        this.applicationSettings = applicationSettings;
        this.splash = splash;
        this.parameterFiles = parameterFiles;
    }

    @Override
    public void run() {
        try {
            if (!CreateApplicationGui.checkJreVersion()) {
                System.exit(1);
            }
            CreateApplicationGui.initLookAndFeel(this.applicationSettings);
            JcePolicyUtil.removeRestrictions();
            if (JcePolicyUtil.isLocalPolicyCrytoStrengthLimited()) {
                this.upgradeCryptoStrength();
            }
            KseFrame kseFrame = new KseFrame();
            if (Thread.currentThread().getContextClassLoader() == null) {
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            }
            if (OperatingSystem.isMacOs()) {
                this.integrateWithMacOs(kseFrame);
            }
            kseFrame.display();
            this.checkCaCerts(kseFrame);
            DroppedFileHandler.openFiles(kseFrame, this.parameterFiles);
            if (!Boolean.getBoolean("kse.update.disabled")) {
                this.checkForUpdates(kseFrame);
            }
        }
        catch (Throwable t) {
            DError dError = new DError(new JFrame(), t);
            dError.setLocationRelativeTo(null);
            dError.setVisible(true);
            System.exit(1);
        }
        finally {
            this.closeSplash();
        }
    }

    private void checkCaCerts(final KseFrame kseFrame) {
        File caCertificatesFile = this.applicationSettings.getCaCertificatesFile();
        if (caCertificatesFile.exists()) {
            return;
        }
        final File newCaCertsFile = new File(AuthorityCertificates.getDefaultCaCertificatesLocation().toString());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int selected = JOptionPane.showConfirmDialog(kseFrame.getUnderlyingFrame(), MessageFormat.format(res.getString("CreateApplicationGui.CaCertsFileNotFound.message"), newCaCertsFile), KSE.getApplicationName(), 0);
                if (selected == 0) {
                    CreateApplicationGui.this.applicationSettings.setCaCertificatesFile(newCaCertsFile);
                }
            }
        });
    }

    private void checkForUpdates(final KseFrame kseFrame) {
        new Thread(){

            @Override
            public void run() {
                try {
                    URL latestVersionUrl = new URL("https://keystore-explorer.org/version.txt");
                    String versionString = IOUtils.toString((URL)latestVersionUrl, (String)"ASCII");
                    final Version latestVersion = new Version(versionString);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CheckUpdateAction checkUpdateAction = new CheckUpdateAction(kseFrame);
                            checkUpdateAction.compareVersions(latestVersion, true);
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    private static void initLookAndFeel(ApplicationSettings applicationSettings) {
        LnfUtil.installLnfs();
        String lookFeelClassName = applicationSettings.getLookAndFeelClass();
        if (lookFeelClassName != null) {
            LnfUtil.useLnf(lookFeelClassName);
        } else {
            String lookAndFeelClass = LnfUtil.useLnfForPlatform();
            applicationSettings.setLookAndFeelClass(lookAndFeelClass);
        }
        boolean lookFeelDecorated = applicationSettings.getLookAndFeelDecorated();
        JFrame.setDefaultLookAndFeelDecorated(lookFeelDecorated);
        JDialog.setDefaultLookAndFeelDecorated(lookFeelDecorated);
    }

    private static boolean checkJreVersion() {
        JavaVersion actualJreVersion = null;
        try {
            actualJreVersion = JavaVersion.getJreVersion();
        }
        catch (VersionException ex) {
            String message = res.getString("CreateApplicationGui.NoParseJreVersion.message");
            System.err.println(message);
            JOptionPane.showMessageDialog(new JFrame(), message, KSE.getApplicationName(), 0);
            return false;
        }
        if (actualJreVersion.compareTo(MIN_JRE_VERSION) < 0) {
            String message = MessageFormat.format(res.getString("CreateApplicationGui.MinJreVersionReq.message"), actualJreVersion, MIN_JRE_VERSION);
            System.err.println(message);
            JOptionPane.showMessageDialog(new JFrame(), message, KSE.getApplicationName(), 0);
            return false;
        }
        return true;
    }

    private void upgradeCryptoStrength() {
        this.closeSplash();
        JOptionPane.showMessageDialog(new JFrame(), res.getString("CryptoStrengthUpgrade.UpgradeRequired.message"), KSE.getApplicationName(), 1);
        DUpgradeCryptoStrength dUpgradeCryptoStrength = new DUpgradeCryptoStrength(new JFrame());
        dUpgradeCryptoStrength.setLocationRelativeTo(null);
        dUpgradeCryptoStrength.setVisible(true);
        if (dUpgradeCryptoStrength.hasCryptoStrengthBeenUpgraded()) {
            JOptionPane.showMessageDialog(new JFrame(), res.getString("CryptoStrengthUpgrade.Upgraded.message"), KSE.getApplicationName(), 1);
            KseRestart.restart();
            System.exit(0);
        } else if (dUpgradeCryptoStrength.hasCryptoStrengthUpgradeFailed()) {
            System.exit(1);
        } else {
            JOptionPane.showMessageDialog(new JFrame(), res.getString("CryptoStrengthUpgrade.NotUpgraded.message"), KSE.getApplicationName(), 2);
            System.exit(1);
        }
    }

    private void integrateWithMacOs(KseFrame kseFrame) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        MacOsIntegration macOsIntegration = new MacOsIntegration(kseFrame);
        macOsIntegration.addEventHandlers();
    }

    private void closeSplash() {
        if (this.splash != null && this.splash.isVisible()) {
            this.splash.close();
        }
    }
}

