/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class FileExtFilter
extends FileFilter {
    private String[] exts;
    private String description;

    public FileExtFilter(String ext, String description) {
        this.exts = new String[1];
        this.exts[0] = ext;
        this.description = description;
    }

    public FileExtFilter(String[] exts, String description) {
        this.exts = new String[exts.length];
        System.arraycopy(exts, 0, this.exts, 0, exts.length);
        this.description = description;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String fileExt = this.getExtension(file);
        if (fileExt == null) {
            return false;
        }
        for (int i = 0; i < this.exts.length; ++i) {
            String ext = this.exts[i];
            if (!fileExt.equalsIgnoreCase(ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String[] getExtensions() {
        return this.exts;
    }

    private String getExtension(File file) {
        String ext = null;
        String name = file.getName();
        int i = name.lastIndexOf(46);
        if (i > -1 && i < name.length() - 1) {
            ext = name.substring(i + 1).toLowerCase();
        }
        return ext;
    }
}

