/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.kse.crypto.Password;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.error.DError;
import org.kse.utilities.history.HistoryAction;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class AppendToCertificateChainAction
extends KeyStoreExplorerAction
implements HistoryAction {
    private static final long serialVersionUID = 1L;

    public AppendToCertificateChainAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("AppendToCertificateChainAction.statusbar"));
        this.putValue("Name", res.getString("AppendToCertificateChainAction.text"));
        this.putValue("ShortDescription", res.getString("AppendToCertificateChainAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/appendcert.png"))));
    }

    @Override
    public String getHistoryDescription() {
        return (String)this.getValue("Name");
    }

    @Override
    protected void doAction() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            String alias = this.kseFrame.getSelectedEntryAlias();
            Password password = this.getEntryPassword(alias, currentState);
            if (password == null) {
                return;
            }
            KeyStoreState newState = currentState.createBasisForNextState(this);
            KeyStore keyStore = newState.getKeyStore();
            Key privKey = keyStore.getKey(alias, password.toCharArray());
            X509Certificate[] certChain = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(keyStore.getCertificateChain(alias)));
            X509Certificate certToAppendTo = certChain[certChain.length - 1];
            if (X509CertUtil.isCertificateSelfSigned(certToAppendTo)) {
                JOptionPane.showMessageDialog(this.frame, res.getString("AppendToCertificateChainAction.CannotAppendCertSelfSigned.message"), res.getString("AppendToCertificateChainAction.AppendToCertificateChain.Title"), 2);
                return;
            }
            File certFile = this.chooseAppendCertificateFile();
            if (certFile == null) {
                return;
            }
            X509Certificate[] certs = this.openCertificate(certFile);
            if (certs == null || certs.length == 0) {
                return;
            }
            if (certs.length > 1) {
                JOptionPane.showMessageDialog(this.frame, res.getString("AppendToCertificateChainAction.NoMultipleAppendCert.message"), res.getString("AppendToCertificateChainAction.AppendToCertificateChain.Title"), 2);
                return;
            }
            X509Certificate certToAppend = certs[0];
            if (!X509CertUtil.verifyCertificate(certToAppendTo, certToAppend)) {
                JOptionPane.showMessageDialog(this.frame, res.getString("AppendToCertificateChainAction.AppendCertNotSigner.message"), res.getString("AppendToCertificateChainAction.AppendToCertificateChain.Title"), 2);
                return;
            }
            Certificate[] newCertChain = new X509Certificate[certChain.length + 1];
            System.arraycopy(certChain, 0, newCertChain, 0, certChain.length);
            newCertChain[newCertChain.length - 1] = certToAppend;
            keyStore.deleteEntry(alias);
            keyStore.setKeyEntry(alias, privKey, password.toCharArray(), newCertChain);
            currentState.append(newState);
            this.kseFrame.updateControls(true);
            JOptionPane.showMessageDialog(this.frame, res.getString("AppendToCertificateChainAction.AppendToCertificateChainSuccessful.message"), res.getString("AppendToCertificateChainAction.AppendToCertificateChain.Title"), 1);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    private File chooseAppendCertificateFile() {
        JFileChooser chooser = FileChooserFactory.getX509FileChooser();
        chooser.setCurrentDirectory(CurrentDirectory.get());
        chooser.setDialogTitle(res.getString("AppendToCertificateChainAction.AppendToCertificateChain.Title"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonText(res.getString("AppendToCertificateChainAction.AppendCertificate.button"));
        int rtnValue = chooser.showOpenDialog(this.frame);
        if (rtnValue == 0) {
            File openFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(openFile);
            return openFile;
        }
        return null;
    }
}

