/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.security.KeyStore;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.error.DError;
import org.kse.utilities.history.HistoryAction;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class DeleteKeyPairAction
extends KeyStoreExplorerAction
implements HistoryAction {
    private static final long serialVersionUID = 1L;

    public DeleteKeyPairAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("DeleteKeyPairAction.statusbar"));
        this.putValue("Name", res.getString("DeleteKeyPairAction.text"));
        this.putValue("ShortDescription", res.getString("DeleteKeyPairAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/delete.png"))));
    }

    @Override
    public String getHistoryDescription() {
        return (String)this.getValue("Name");
    }

    @Override
    protected void doAction() {
        this.deleteSelectedEntry();
    }

    public void deleteSelectedEntry() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            KeyStoreState newState = currentState.createBasisForNextState(this);
            KeyStore keyStore = newState.getKeyStore();
            String alias = this.kseFrame.getSelectedEntryAlias();
            String message = MessageFormat.format(res.getString("DeleteKeyPairAction.ConfirmDelete.message"), alias);
            int selected = JOptionPane.showConfirmDialog(this.frame, message, res.getString("DeleteKeyPairAction.DeleteEntry.Title"), 0);
            if (selected != 0) {
                return;
            }
            keyStore.deleteEntry(alias);
            newState.removeEntryPassword(alias);
            currentState.append(newState);
            this.kseFrame.updateControls(true);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

