/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.kse.crypto.Password;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.DGetAlias;
import org.kse.gui.dialogs.importexport.DImportKeyPairOpenSsl;
import org.kse.gui.dialogs.importexport.DImportKeyPairPkcs12;
import org.kse.gui.dialogs.importexport.DImportKeyPairPkcs8;
import org.kse.gui.dialogs.importexport.DImportKeyPairPvk;
import org.kse.gui.dialogs.importexport.DImportKeyPairType;
import org.kse.gui.error.DError;
import org.kse.gui.password.DGetNewPassword;
import org.kse.utilities.history.HistoryAction;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class ImportKeyPairAction
extends KeyStoreExplorerAction
implements HistoryAction {
    private static final long serialVersionUID = 1L;

    public ImportKeyPairAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("ImportKeyPairAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("LongDescription", res.getString("ImportKeyPairAction.statusbar"));
        this.putValue("Name", res.getString("ImportKeyPairAction.text"));
        this.putValue("ShortDescription", res.getString("ImportKeyPairAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/importkeypair.png"))));
    }

    @Override
    public String getHistoryDescription() {
        return (String)this.getValue("Name");
    }

    @Override
    protected void doAction() {
        DImportKeyPairType dImportKeyPairType = new DImportKeyPairType(this.frame);
        dImportKeyPairType.setLocationRelativeTo(this.frame);
        dImportKeyPairType.setVisible(true);
        if (!dImportKeyPairType.importTypeSelected()) {
            return;
        }
        if (dImportKeyPairType.importPkcs12()) {
            this.importKeyPairPkcs12();
        } else if (dImportKeyPairType.importPkcs8()) {
            this.importKeyPairPkcs8();
        } else if (dImportKeyPairType.importPvk()) {
            this.importKeyPairPvk();
        } else {
            this.importKeyPairOpenSsl();
        }
    }

    private void importKeyPairPkcs12() {
        try {
            String message;
            int selected;
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            KeyStoreState newState = currentState.createBasisForNextState(this);
            KeyStore keyStore = newState.getKeyStore();
            DImportKeyPairPkcs12 dImportKeyPairPkcs12 = new DImportKeyPairPkcs12(this.frame);
            dImportKeyPairPkcs12.setLocationRelativeTo(this.frame);
            dImportKeyPairPkcs12.setVisible(true);
            PrivateKey privKey = dImportKeyPairPkcs12.getPrivateKey();
            Certificate[] certs = dImportKeyPairPkcs12.getCertificateChain();
            if (privKey == null || certs == null) {
                return;
            }
            Certificate[] x509Certs = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(certs));
            DGetAlias dGetAlias = new DGetAlias(this.frame, res.getString("ImportKeyPairAction.NewKeyPairEntryAlias.Title"), X509CertUtil.getCertificateAlias(x509Certs[0]));
            dGetAlias.setLocationRelativeTo(this.frame);
            dGetAlias.setVisible(true);
            String alias = dGetAlias.getAlias();
            if (alias == null) {
                return;
            }
            if (keyStore.containsAlias(alias) && (selected = JOptionPane.showConfirmDialog(this.frame, message = MessageFormat.format(res.getString("ImportKeyPairAction.OverWriteEntry.message"), alias), res.getString("ImportKeyPairAction.NewKeyPairEntryAlias.Title"), 0)) != 0) {
                return;
            }
            Password password = new Password((char[])null);
            KeyStoreType type = KeyStoreType.resolveJce(keyStore.getType());
            if (type.hasEntryPasswords()) {
                DGetNewPassword dGetNewPassword = new DGetNewPassword(this.frame, res.getString("ImportKeyPairAction.NewKeyPairEntryPassword.Title"), this.applicationSettings.getPasswordQualityConfig());
                dGetNewPassword.setLocationRelativeTo(this.frame);
                dGetNewPassword.setVisible(true);
                password = dGetNewPassword.getPassword();
                if (password == null) {
                    return;
                }
            }
            if (keyStore.containsAlias(alias)) {
                keyStore.deleteEntry(alias);
                newState.removeEntryPassword(alias);
            }
            keyStore.setKeyEntry(alias, privKey, password.toCharArray(), x509Certs);
            newState.setEntryPassword(alias, password);
            currentState.append(newState);
            this.kseFrame.updateControls(true);
            JOptionPane.showMessageDialog(this.frame, res.getString("ImportKeyPairAction.KeyPairImportSuccessful.message"), res.getString("ImportKeyPairAction.ImportKeyPair.Title"), 1);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    private void importKeyPairPkcs8() {
        try {
            String message;
            int selected;
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            KeyStoreState newState = currentState.createBasisForNextState(this);
            KeyStore keyStore = newState.getKeyStore();
            DImportKeyPairPkcs8 dImportKeyPairPkcs8 = new DImportKeyPairPkcs8(this.frame);
            dImportKeyPairPkcs8.setLocationRelativeTo(this.frame);
            dImportKeyPairPkcs8.setVisible(true);
            PrivateKey privateKey = dImportKeyPairPkcs8.getPrivateKey();
            Certificate[] certs = dImportKeyPairPkcs8.getCertificateChain();
            if (privateKey == null || certs == null) {
                return;
            }
            Certificate[] x509Certs = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(certs));
            DGetAlias dGetAlias = new DGetAlias(this.frame, res.getString("ImportKeyPairAction.NewKeyPairEntryAlias.Title"), X509CertUtil.getCertificateAlias(x509Certs[0]));
            dGetAlias.setLocationRelativeTo(this.frame);
            dGetAlias.setVisible(true);
            String alias = dGetAlias.getAlias();
            if (alias == null) {
                return;
            }
            if (keyStore.containsAlias(alias) && (selected = JOptionPane.showConfirmDialog(this.frame, message = MessageFormat.format(res.getString("ImportKeyPairAction.OverWriteEntry.message"), alias), res.getString("ImportKeyPairAction.NewKeyPairEntryAlias.Title"), 0)) != 0) {
                return;
            }
            Password password = new Password((char[])null);
            KeyStoreType type = KeyStoreType.resolveJce(keyStore.getType());
            if (type.hasEntryPasswords()) {
                DGetNewPassword dGetNewPassword = new DGetNewPassword(this.frame, res.getString("ImportKeyPairAction.NewKeyPairEntryPassword.Title"), this.applicationSettings.getPasswordQualityConfig());
                dGetNewPassword.setLocationRelativeTo(this.frame);
                dGetNewPassword.setVisible(true);
                password = dGetNewPassword.getPassword();
                if (password == null) {
                    return;
                }
            }
            if (keyStore.containsAlias(alias)) {
                keyStore.deleteEntry(alias);
                newState.removeEntryPassword(alias);
            }
            keyStore.setKeyEntry(alias, privateKey, password.toCharArray(), x509Certs);
            newState.setEntryPassword(alias, password);
            currentState.append(newState);
            this.kseFrame.updateControls(true);
            JOptionPane.showMessageDialog(this.frame, res.getString("ImportKeyPairAction.KeyPairImportSuccessful.message"), res.getString("ImportKeyPairAction.ImportKeyPair.Title"), 1);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    private void importKeyPairPvk() {
        try {
            String message;
            int selected;
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            KeyStoreState newState = currentState.createBasisForNextState(this);
            KeyStore keyStore = newState.getKeyStore();
            DImportKeyPairPvk dImportKeyPairPvk = new DImportKeyPairPvk(this.frame);
            dImportKeyPairPvk.setLocationRelativeTo(this.frame);
            dImportKeyPairPvk.setVisible(true);
            PrivateKey privateKey = dImportKeyPairPvk.getPrivateKey();
            Certificate[] certs = dImportKeyPairPvk.getCertificateChain();
            if (privateKey == null || certs == null) {
                return;
            }
            Certificate[] x509Certs = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(certs));
            DGetAlias dGetAlias = new DGetAlias(this.frame, res.getString("ImportKeyPairAction.NewKeyPairEntryAlias.Title"), X509CertUtil.getCertificateAlias(x509Certs[0]));
            dGetAlias.setLocationRelativeTo(this.frame);
            dGetAlias.setVisible(true);
            String alias = dGetAlias.getAlias();
            if (alias == null) {
                return;
            }
            if (keyStore.containsAlias(alias) && (selected = JOptionPane.showConfirmDialog(this.frame, message = MessageFormat.format(res.getString("ImportKeyPairAction.OverWriteEntry.message"), alias), res.getString("ImportKeyPairAction.NewKeyPairEntryAlias.Title"), 0)) != 0) {
                return;
            }
            Password password = new Password((char[])null);
            KeyStoreType type = KeyStoreType.resolveJce(keyStore.getType());
            if (type.hasEntryPasswords()) {
                DGetNewPassword dGetNewPassword = new DGetNewPassword(this.frame, res.getString("ImportKeyPairAction.NewKeyPairEntryPassword.Title"), this.applicationSettings.getPasswordQualityConfig());
                dGetNewPassword.setLocationRelativeTo(this.frame);
                dGetNewPassword.setVisible(true);
                password = dGetNewPassword.getPassword();
                if (password == null) {
                    return;
                }
            }
            if (keyStore.containsAlias(alias)) {
                keyStore.deleteEntry(alias);
                newState.removeEntryPassword(alias);
            }
            keyStore.setKeyEntry(alias, privateKey, password.toCharArray(), x509Certs);
            newState.setEntryPassword(alias, password);
            currentState.append(newState);
            this.kseFrame.updateControls(true);
            JOptionPane.showMessageDialog(this.frame, res.getString("ImportKeyPairAction.KeyPairImportSuccessful.message"), res.getString("ImportKeyPairAction.ImportKeyPair.Title"), 1);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    private void importKeyPairOpenSsl() {
        try {
            String message;
            int selected;
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            KeyStoreState newState = currentState.createBasisForNextState(this);
            KeyStore keyStore = newState.getKeyStore();
            DImportKeyPairOpenSsl dImportKeyPairOpenSsl = new DImportKeyPairOpenSsl(this.frame);
            dImportKeyPairOpenSsl.setLocationRelativeTo(this.frame);
            dImportKeyPairOpenSsl.setVisible(true);
            PrivateKey privateKey = dImportKeyPairOpenSsl.getPrivateKey();
            Certificate[] certs = dImportKeyPairOpenSsl.getCertificateChain();
            if (privateKey == null || certs == null) {
                return;
            }
            Certificate[] x509Certs = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(certs));
            DGetAlias dGetAlias = new DGetAlias(this.frame, res.getString("ImportKeyPairAction.NewKeyPairEntryAlias.Title"), X509CertUtil.getCertificateAlias(x509Certs[0]));
            dGetAlias.setLocationRelativeTo(this.frame);
            dGetAlias.setVisible(true);
            String alias = dGetAlias.getAlias();
            if (alias == null) {
                return;
            }
            if (keyStore.containsAlias(alias) && (selected = JOptionPane.showConfirmDialog(this.frame, message = MessageFormat.format(res.getString("ImportKeyPairAction.OverWriteEntry.message"), alias), res.getString("ImportKeyPairAction.NewKeyPairEntryAlias.Title"), 0)) != 0) {
                return;
            }
            Password password = new Password((char[])null);
            KeyStoreType type = KeyStoreType.resolveJce(keyStore.getType());
            if (type.hasEntryPasswords()) {
                DGetNewPassword dGetNewPassword = new DGetNewPassword(this.frame, res.getString("ImportKeyPairAction.NewKeyPairEntryPassword.Title"), this.applicationSettings.getPasswordQualityConfig());
                dGetNewPassword.setLocationRelativeTo(this.frame);
                dGetNewPassword.setVisible(true);
                password = dGetNewPassword.getPassword();
                if (password == null) {
                    return;
                }
            }
            if (keyStore.containsAlias(alias)) {
                keyStore.deleteEntry(alias);
                newState.removeEntryPassword(alias);
            }
            keyStore.setKeyEntry(alias, privateKey, password.toCharArray(), x509Certs);
            newState.setEntryPassword(alias, password);
            currentState.append(newState);
            this.kseFrame.updateControls(true);
            JOptionPane.showMessageDialog(this.frame, res.getString("ImportKeyPairAction.KeyPairImportSuccessful.message"), res.getString("ImportKeyPairAction.ImportKeyPair.Title"), 1);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

