/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.kse.ApplicationSettings;
import org.kse.crypto.Password;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.CursorUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.error.DError;
import org.kse.gui.error.DProblem;
import org.kse.gui.error.Problem;
import org.kse.gui.password.DGetNewPassword;
import org.kse.gui.password.DGetPassword;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public abstract class KeyStoreExplorerAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    protected static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/actions/resources");
    protected KseFrame kseFrame;
    protected JFrame frame;
    protected ApplicationSettings applicationSettings;

    public KeyStoreExplorerAction(KseFrame kseFrame) {
        this.kseFrame = kseFrame;
        this.frame = kseFrame.getUnderlyingFrame();
        this.applicationSettings = kseFrame.getApplicationSettings();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            this.kseFrame.setDefaultStatusBarText();
            CursorUtil.setCursorBusy(this.frame);
            this.kseFrame.getUnderlyingFrame().repaint();
            this.doAction();
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
        finally {
            CursorUtil.setCursorFree(this.frame);
        }
    }

    protected abstract void doAction();

    protected Password getEntryPassword(String alias, KeyStoreState state) {
        Password password = state.getEntryPassword(alias);
        if (password == null) {
            password = !KeyStoreType.resolveJce(state.getKeyStore().getType()).hasEntryPasswords() ? new Password((char[])null) : this.unlockEntry(alias, state);
        }
        return password;
    }

    protected Password unlockEntry(String alias, KeyStoreState state) {
        try {
            KeyStore keyStore = state.getKeyStore();
            DGetPassword dGetPassword = new DGetPassword(this.frame, MessageFormat.format(res.getString("KeyStoreExplorerAction.UnlockEntry.Title"), alias));
            dGetPassword.setLocationRelativeTo(this.frame);
            dGetPassword.setVisible(true);
            Password password = dGetPassword.getPassword();
            if (password == null) {
                return null;
            }
            keyStore.getKey(alias, password.toCharArray());
            state.setEntryPassword(alias, password);
            this.kseFrame.updateControls(true);
            return password;
        }
        catch (GeneralSecurityException ex) {
            String problemStr = MessageFormat.format(res.getString("KeyStoreExplorerAction.NoUnlockEntry.Problem"), alias);
            String[] causes = new String[]{res.getString("KeyStoreExplorerAction.PasswordIncorrectEntry.Cause")};
            Problem problem = new Problem(problemStr, causes, ex);
            DProblem dProblem = new DProblem(this.frame, res.getString("KeyStoreExplorerAction.ProblemUnlockingEntry.Title"), problem);
            dProblem.setLocationRelativeTo(this.frame);
            dProblem.setVisible(true);
            return null;
        }
    }

    protected X509Certificate[] openCertificate(File certificateFile) {
        try {
            return this.openCertificate(FileUtils.readFileToByteArray((File)certificateFile), certificateFile.getName());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("KeyStoreExplorerAction.NoReadFile.message"), certificateFile), res.getString("KeyStoreExplorerAction.OpenCertificate.Title"), 2);
            return new X509Certificate[0];
        }
    }

    protected X509Certificate[] openCertificate(byte[] data, String name) {
        try {
            X509Certificate[] certs = X509CertUtil.loadCertificates(data);
            if (certs.length == 0) {
                JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("KeyStoreExplorerAction.NoCertsFound.message"), name), res.getString("KeyStoreExplorerAction.OpenCertificate.Title"), 2);
            }
            return certs;
        }
        catch (Exception ex) {
            String problemStr = MessageFormat.format(res.getString("KeyStoreExplorerAction.NoOpenCert.Problem"), name);
            String[] causes = new String[]{res.getString("KeyStoreExplorerAction.NotCert.Cause"), res.getString("KeyStoreExplorerAction.CorruptedCert.Cause")};
            Problem problem = new Problem(problemStr, causes, ex);
            DProblem dProblem = new DProblem(this.frame, res.getString("KeyStoreExplorerAction.ProblemOpeningCert.Title"), problem);
            dProblem.setLocationRelativeTo(this.frame);
            dProblem.setVisible(true);
            return null;
        }
    }

    protected Password getNewKeyStorePassword() {
        DGetNewPassword dGetNewPassword = new DGetNewPassword(this.frame, res.getString("KeyStoreExplorerAction.SetKeyStorePassword.Title"), ApplicationSettings.getInstance().getPasswordQualityConfig());
        dGetNewPassword.setLocationRelativeTo(this.frame);
        dGetNewPassword.setVisible(true);
        Password password = dGetNewPassword.getPassword();
        return password;
    }

    protected boolean isKeyStoreFileOpen(File keyStoreFile) {
        KeyStoreHistory[] histories = this.kseFrame.getKeyStoreHistories();
        for (int i = 0; i < histories.length; ++i) {
            File f = histories[i].getFile();
            if (f == null || !f.equals(keyStoreFile)) continue;
            return true;
        }
        return false;
    }
}

