/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.security.KeyStore;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.kse.crypto.Password;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.crypto.keystore.KeyStoreUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.OpenAction;
import org.kse.gui.dialogs.DNewKeyStoreType;
import org.kse.gui.error.DError;

public class OpenCaCertificatesAction
extends OpenAction {
    private static final long serialVersionUID = 1L;

    public OpenCaCertificatesAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("OpenCaCertificatesAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        this.putValue("LongDescription", res.getString("OpenCaCertificatesAction.statusbar"));
        this.putValue("Name", res.getString("OpenCaCertificatesAction.text"));
        this.putValue("ShortDescription", res.getString("OpenCaCertificatesAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/opencacerts.png"))));
    }

    @Override
    protected void doAction() {
        File caCertificatesFile = this.applicationSettings.getCaCertificatesFile();
        if (caCertificatesFile.isFile()) {
            this.openKeyStore(caCertificatesFile, "changeit");
            return;
        }
        int selected = JOptionPane.showConfirmDialog(this.frame, res.getString("OpenCaCertificatesAction.NoCaCertificatesKeyStoreCreate.message"), res.getString("OpenCaCertificatesAction.OpenCaCertificatesKeyStore.Title"), 0);
        if (selected != 0) {
            return;
        }
        try {
            DNewKeyStoreType dNewKeyStoreType = new DNewKeyStoreType(this.frame);
            dNewKeyStoreType.setLocationRelativeTo(this.frame);
            dNewKeyStoreType.setVisible(true);
            KeyStoreType keyStoreType = dNewKeyStoreType.getKeyStoreType();
            if (keyStoreType == null) {
                return;
            }
            Password password = this.getNewKeyStorePassword();
            if (password == null) {
                return;
            }
            KeyStore caCertificatesKeyStore = KeyStoreUtil.create(keyStoreType);
            KeyStoreUtil.save(caCertificatesKeyStore, caCertificatesFile, password);
            this.kseFrame.addKeyStore(caCertificatesKeyStore, caCertificatesFile, password);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

