/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.kse.ApplicationSettings;
import org.kse.AuthorityCertificates;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.ExitAction;
import org.kse.gui.dialogs.DPreferences;

public class PreferencesAction
extends ExitAction {
    private static final long serialVersionUID = 1L;
    private KseFrame kseFrame;

    public PreferencesAction(KseFrame kseFrame) {
        super(kseFrame);
        this.kseFrame = kseFrame;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("PreferencesAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("LongDescription", res.getString("PreferencesAction.statusbar"));
        this.putValue("Name", res.getString("PreferencesAction.text"));
        this.putValue("ShortDescription", res.getString("PreferencesAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/preferences.png"))));
    }

    @Override
    protected void doAction() {
        this.showPreferences();
    }

    public void showPreferences() {
        ApplicationSettings applicationSettings = ApplicationSettings.getInstance();
        File caCertificatesFile = applicationSettings.getCaCertificatesFile();
        DPreferences dPreferences = new DPreferences(this.frame, applicationSettings.getUseCaCertificates(), caCertificatesFile, applicationSettings.getUseWindowsTrustedRootCertificates(), applicationSettings.getEnableImportTrustedCertTrustCheck(), applicationSettings.getEnableImportCaReplyTrustCheck(), applicationSettings.getPasswordQualityConfig(), applicationSettings.getDefaultDN(), applicationSettings.getLanguage(), applicationSettings.isAutoUpdateCheckEnabled(), applicationSettings.getAutoUpdateCheckInterval(), applicationSettings.getKeyStoreTableColumns());
        dPreferences.setLocationRelativeTo(this.frame);
        dPreferences.setVisible(true);
        if (dPreferences.wasCancelled()) {
            return;
        }
        File tmpFile = dPreferences.getCaCertificatesFile();
        if (!tmpFile.equals(caCertificatesFile)) {
            AuthorityCertificates authorityCertificates = AuthorityCertificates.getInstance();
            authorityCertificates.setCaCertificates(null);
        }
        caCertificatesFile = tmpFile;
        applicationSettings.setCaCertificatesFile(caCertificatesFile);
        applicationSettings.setUseCaCertificates(dPreferences.getUseCaCertificates());
        applicationSettings.setUseWindowsTrustedRootCertificates(dPreferences.getUseWinTrustRootCertificates());
        applicationSettings.setEnableImportTrustedCertTrustCheck(dPreferences.getEnableImportTrustedCertTrustCheck());
        applicationSettings.setEnableImportCaReplyTrustCheck(dPreferences.getEnableImportCaReplyTrustCheck());
        applicationSettings.setPasswordQualityConfig(dPreferences.getPasswordQualityConfig());
        applicationSettings.setDefaultDN(dPreferences.getDefaultDN());
        applicationSettings.setAutoUpdateCheckEnabled(dPreferences.isAutoUpdateChecksEnabled());
        applicationSettings.setAutoUpdateCheckInterval(dPreferences.getAutoUpdateChecksInterval());
        UIManager.LookAndFeelInfo lookFeelInfo = dPreferences.getLookFeelInfo();
        applicationSettings.setLookAndFeelClass(lookFeelInfo.getClassName());
        boolean lookAndFeelDecorated = dPreferences.getLookFeelDecoration();
        applicationSettings.setLookAndFeelDecorated(lookAndFeelDecorated);
        String language = dPreferences.getLanguage();
        boolean languageHasChanged = !language.equals(applicationSettings.getLanguage());
        applicationSettings.setLanguage(language);
        if (dPreferences.columnsChanged()) {
            applicationSettings.setKeyStoreTableColumns(dPreferences.getColumns());
            this.kseFrame.redrawKeyStores(applicationSettings);
        }
        if (!lookFeelInfo.getClassName().equals(UIManager.getLookAndFeel().getClass().getName()) || lookAndFeelDecorated != JFrame.isDefaultLookAndFeelDecorated() || languageHasChanged) {
            JOptionPane.showMessageDialog(this.frame, res.getString("PreferencesAction.LookFeelChanged.message"), res.getString("PreferencesAction.LookFeelChanged.Title"), 1);
            this.exitApplication(true);
        }
    }
}

