/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.error.DError;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class RedoAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;
    private String defaultName = res.getString("RedoAction.text");

    public RedoAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("RedoAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("LongDescription", res.getString("RedoAction.statusbar"));
        this.putValue("Name", this.defaultName);
        this.putValue("ShortDescription", res.getString("RedoAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/redo.png"))));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            KeyStoreState currentState = this.kseFrame.getActiveKeyStoreHistory().getCurrentState();
            KeyStoreState nextState = currentState.nextState();
            this.putValue("Name", MessageFormat.format(res.getString("RedoAction.dynamic.text"), nextState.getActionDescription()));
        } else {
            this.putValue("Name", this.defaultName);
        }
    }

    @Override
    protected void doAction() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            history.getCurrentState().setNextStateAsCurrentState();
            this.kseFrame.updateControls(true);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

