/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.kse.crypto.Password;
import org.kse.crypto.keystore.KeyStoreUtil;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.actions.SetPasswordAction;
import org.kse.gui.error.DError;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class SaveAsAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;

    public SaveAsAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("SaveAsAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        this.putValue("LongDescription", res.getString("SaveAsAction.statusbar"));
        this.putValue("Name", res.getString("SaveAsAction.text"));
        this.putValue("ShortDescription", res.getString("SaveAsAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/saveas.png"))));
    }

    @Override
    protected void doAction() {
        this.saveKeyStoreAs(this.kseFrame.getActiveKeyStoreHistory());
    }

    protected boolean saveKeyStoreAs(KeyStoreHistory history) {
        File saveFile = null;
        try {
            String message;
            int selected;
            KeyStoreState currentState = history.getCurrentState();
            Password password = currentState.getPassword();
            if (password == null || password.isNulled()) {
                SetPasswordAction setPasswordAction = new SetPasswordAction(this.kseFrame);
                if (setPasswordAction.setKeyStorePassword()) {
                    currentState = history.getCurrentState();
                    password = currentState.getPassword();
                } else {
                    return false;
                }
            }
            JFileChooser chooser = FileChooserFactory.getKeyStoreFileChooser();
            chooser.setCurrentDirectory(CurrentDirectory.get());
            chooser.setDialogTitle(res.getString("SaveAsAction.SaveKeyStoreAs.Title"));
            chooser.setMultiSelectionEnabled(false);
            int rtnValue = chooser.showSaveDialog(this.frame);
            if (rtnValue != 0) {
                return false;
            }
            saveFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(saveFile);
            if (saveFile.isFile() && (selected = JOptionPane.showConfirmDialog(this.frame, message = MessageFormat.format(res.getString("SaveAsAction.OverWriteFile.message"), saveFile), res.getString("SaveAsAction.SaveKeyStoreAs.Title"), 0)) != 0) {
                return false;
            }
            if (this.isKeyStoreFileOpen(saveFile)) {
                JOptionPane.showMessageDialog(this.frame, res.getString("SaveAsAction.NoSaveKeyStoreAlreadyOpen.message"), res.getString("SaveAsAction.SaveKeyStoreAs.Title"), 2);
                return false;
            }
            KeyStoreUtil.save(currentState.getKeyStore(), saveFile, password);
            currentState.setPassword(password);
            history.setFile(saveFile);
            currentState.setAsSavedState();
            this.kseFrame.updateControls(false);
            this.kseFrame.addRecentFile(saveFile);
            return true;
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("SaveAsAction.NoWriteFile.message"), saveFile), res.getString("SaveAsAction.SaveKeyStoreAs.Title"), 2);
            return false;
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
            return false;
        }
    }
}

