/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Dialog;
import java.awt.Toolkit;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.kse.crypto.Password;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.error.DError;
import org.kse.gui.error.DProblem;
import org.kse.gui.error.Problem;
import org.kse.gui.password.DChangePassword;
import org.kse.utilities.history.HistoryAction;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class SetKeyPairPasswordAction
extends KeyStoreExplorerAction
implements HistoryAction {
    private static final long serialVersionUID = 1L;

    public SetKeyPairPasswordAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("SetKeyPairPasswordAction.statusbar"));
        this.putValue("Name", res.getString("SetKeyPairPasswordAction.text"));
        this.putValue("ShortDescription", res.getString("SetKeyPairPasswordAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/setpass.png"))));
    }

    @Override
    public String getHistoryDescription() {
        return res.getString("SetKeyPairPasswordAction.History.text");
    }

    @Override
    protected void doAction() {
        String alias = null;
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            KeyStoreState newState = currentState.createBasisForNextState(this);
            KeyStore keyStore = newState.getKeyStore();
            alias = this.kseFrame.getSelectedEntryAlias();
            Password oldPassword = newState.getEntryPassword(alias);
            DChangePassword dChangePassword = new DChangePassword(this.frame, Dialog.ModalityType.DOCUMENT_MODAL, res.getString("SetKeyPairPasswordAction.SetKeyPairPassword.Title"), oldPassword, this.applicationSettings.getPasswordQualityConfig());
            dChangePassword.setLocationRelativeTo(this.frame);
            dChangePassword.setVisible(true);
            if (oldPassword == null) {
                oldPassword = dChangePassword.getOldPassword();
            }
            Password newPassword = dChangePassword.getNewPassword();
            if (oldPassword == null || newPassword == null) {
                return;
            }
            Certificate[] certs = keyStore.getCertificateChain(alias);
            certs = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(certs));
            Key privateKey = keyStore.getKey(alias, oldPassword.toCharArray());
            keyStore.deleteEntry(alias);
            newState.removeEntryPassword(alias);
            keyStore.setKeyEntry(alias, privateKey, newPassword.toCharArray(), certs);
            if (currentState.getEntryPassword(alias) == null) {
                currentState.setEntryPassword(alias, oldPassword);
            }
            newState.setEntryPassword(alias, newPassword);
            currentState.append(newState);
            this.kseFrame.updateControls(true);
            JOptionPane.showMessageDialog(this.frame, res.getString("SetKeyPairPasswordAction.SetKeyPairPasswordSuccessful.message"), res.getString("SetKeyPairPasswordAction.SetKeyPairPassword.Title"), 1);
        }
        catch (GeneralSecurityException ex) {
            String problemStr = MessageFormat.format(res.getString("SetKeyPairPasswordAction.NoSetPasswordKeyPairEntry.Problem"), alias);
            String[] causes = new String[]{res.getString("SetKeyPairPasswordAction.PasswordIncorrectKeyPairEntry.Cause"), res.getString("SetKeyPairPasswordAction.NotSupportedAlgorithmKeyPairEntry.Cause")};
            Problem problem = new Problem(problemStr, causes, ex);
            DProblem dProblem = new DProblem(this.frame, res.getString("SetKeyPairPasswordAction.ProblemSettingPasswordKeyPairEntry.Title"), problem);
            dProblem.setLocationRelativeTo(this.frame);
            dProblem.setVisible(true);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

