/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.kse.crypto.CryptoException;
import org.kse.crypto.digest.DigestType;
import org.kse.crypto.digest.DigestUtil;
import org.kse.gui.CursorUtil;
import org.kse.gui.crypto.DViewCertificateFingerprint;
import org.kse.gui.error.DError;

public class JCertificateFingerprint
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/resources");
    private JComboBox<DigestType> jcbFingerprintAlg;
    private JTextField jtfCertificateFingerprint;
    private JButton jbViewCertificateFingerprint;
    private byte[] encodedCertificate;

    public JCertificateFingerprint(int columns) {
        this.initComponents(columns);
    }

    private void initComponents(int columns) {
        this.jcbFingerprintAlg = new JComboBox();
        this.jcbFingerprintAlg.setToolTipText(res.getString("JCertificateFingerprint.jcbFingerprintAlg.tooltip"));
        this.jcbFingerprintAlg.setMaximumRowCount(10);
        this.jcbFingerprintAlg.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JCertificateFingerprint.this.populateFingerprint();
            }
        });
        GridBagConstraints gbc_jcbFingerprintAlg = new GridBagConstraints();
        gbc_jcbFingerprintAlg.gridwidth = 1;
        gbc_jcbFingerprintAlg.gridheight = 1;
        gbc_jcbFingerprintAlg.gridx = 0;
        gbc_jcbFingerprintAlg.gridy = 0;
        gbc_jcbFingerprintAlg.insets = new Insets(0, 0, 0, 5);
        this.jtfCertificateFingerprint = new JTextField(columns);
        this.jtfCertificateFingerprint.setEditable(false);
        this.jtfCertificateFingerprint.setToolTipText(res.getString("JCertificateFingerprint.jtfCertificateFingerprint.tooltip"));
        GridBagConstraints gbc_jtfCertificateFingerprint = new GridBagConstraints();
        gbc_jtfCertificateFingerprint.gridwidth = 1;
        gbc_jtfCertificateFingerprint.gridheight = 1;
        gbc_jtfCertificateFingerprint.gridx = 1;
        gbc_jtfCertificateFingerprint.gridy = 0;
        gbc_jtfCertificateFingerprint.insets = new Insets(0, 0, 0, 5);
        ImageIcon viewIcon = new ImageIcon(this.getClass().getResource("images/view_cert_fingerprint.png"));
        this.jbViewCertificateFingerprint = new JButton(viewIcon);
        this.jbViewCertificateFingerprint.setToolTipText(res.getString("JCertificateFingerprint.jbViewCertificateFingerprint.tooltip"));
        this.jbViewCertificateFingerprint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JCertificateFingerprint.this);
                    JCertificateFingerprint.this.displayFingerprint();
                }
                finally {
                    CursorUtil.setCursorFree(JCertificateFingerprint.this);
                }
            }
        });
        GridBagConstraints gbc_jbViewCertificateFingerprint = new GridBagConstraints();
        gbc_jbViewCertificateFingerprint.gridwidth = 1;
        gbc_jbViewCertificateFingerprint.gridheight = 1;
        gbc_jbViewCertificateFingerprint.gridx = 2;
        gbc_jbViewCertificateFingerprint.gridy = 0;
        gbc_jbViewCertificateFingerprint.insets = new Insets(0, 0, 0, 0);
        this.setLayout(new GridBagLayout());
        this.add(this.jcbFingerprintAlg, gbc_jcbFingerprintAlg);
        this.add((Component)this.jtfCertificateFingerprint, gbc_jtfCertificateFingerprint);
        this.add((Component)this.jbViewCertificateFingerprint, gbc_jbViewCertificateFingerprint);
        this.populateFingerprintAlgs();
        this.populateFingerprint();
    }

    private void populateFingerprintAlgs() {
        DigestType[] digestAlgs;
        for (DigestType digestAlg : digestAlgs = DigestType.values()) {
            this.jcbFingerprintAlg.addItem(digestAlg);
        }
        this.jcbFingerprintAlg.setSelectedIndex(0);
    }

    public void setEncodedCertificate(byte[] encodedCertificate) {
        this.encodedCertificate = encodedCertificate;
        this.populateFingerprint();
    }

    public void setFingerprintAlg(DigestType fingerprintAlg) {
        this.jcbFingerprintAlg.setSelectedItem((Object)fingerprintAlg);
    }

    public DigestType getSelectedFingerprintAlg() {
        return (DigestType)((Object)this.jcbFingerprintAlg.getSelectedItem());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.jbViewCertificateFingerprint.setEnabled(enabled);
    }

    private void populateFingerprint() {
        if (this.encodedCertificate != null) {
            DigestType fingerprintAlg = (DigestType)((Object)this.jcbFingerprintAlg.getSelectedItem());
            try {
                this.jtfCertificateFingerprint.setText(DigestUtil.getFriendlyMessageDigest(this.encodedCertificate, fingerprintAlg));
            }
            catch (CryptoException ex) {
                Container container = this.getTopLevelAncestor();
                DError dError = null;
                dError = container instanceof JDialog ? new DError((JDialog)container, (Throwable)ex) : new DError((JFrame)container, (Throwable)ex);
                dError.setLocationRelativeTo(container);
                dError.setVisible(true);
                return;
            }
        } else {
            this.jtfCertificateFingerprint.setText("");
        }
        this.jtfCertificateFingerprint.setCaretPosition(0);
    }

    private void displayFingerprint() {
        Container container = this.getTopLevelAncestor();
        DigestType fingerprintAlg = (DigestType)((Object)this.jcbFingerprintAlg.getSelectedItem());
        if (container instanceof JDialog) {
            DViewCertificateFingerprint dViewCertificateFingerprint = new DViewCertificateFingerprint((JDialog)container, this.encodedCertificate, fingerprintAlg);
            dViewCertificateFingerprint.setLocationRelativeTo(container);
            dViewCertificateFingerprint.setVisible(true);
        } else if (container instanceof JFrame) {
            DViewCertificateFingerprint dViewCertificateFingerprint = new DViewCertificateFingerprint((JFrame)container, this.encodedCertificate, fingerprintAlg);
            dViewCertificateFingerprint.setLocationRelativeTo(container);
            dViewCertificateFingerprint.setVisible(true);
        }
    }
}

