/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.kse.crypto.x509.KseX500NameStyle;
import org.kse.gui.CursorUtil;
import org.kse.gui.crypto.DDistinguishedNameChooser;

public class JDistinguishedName
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/resources");
    private JTextField jtfDistinguishedName;
    private JButton jbViewEditDistinguishedName;
    private JButton jbClearDistinguishedName;
    private String title;
    private boolean editable;
    private X500Name distinguishedName;

    public JDistinguishedName(String title, int columns, boolean editable) {
        this.title = title;
        this.editable = editable;
        this.initComponents(columns);
    }

    private void initComponents(int columns) {
        this.jtfDistinguishedName = new JTextField(columns);
        this.jtfDistinguishedName.setEditable(false);
        GridBagConstraints gbcJtfDistinguishedName = new GridBagConstraints();
        gbcJtfDistinguishedName.gridwidth = 1;
        gbcJtfDistinguishedName.gridheight = 1;
        gbcJtfDistinguishedName.gridx = 0;
        gbcJtfDistinguishedName.gridy = 0;
        gbcJtfDistinguishedName.insets = new Insets(0, 0, 0, 5);
        ImageIcon viewEditIcon = new ImageIcon(this.getClass().getResource("images/view_edit_dn.png"));
        this.jbViewEditDistinguishedName = new JButton(viewEditIcon);
        if (this.editable) {
            this.jbViewEditDistinguishedName.setToolTipText(res.getString("JDistinguishedName.jbViewEditDistinguishedName.Edit.tooltip"));
            this.jbViewEditDistinguishedName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        CursorUtil.setCursorBusy(JDistinguishedName.this);
                        JDistinguishedName.this.editDistinguishedName();
                    }
                    finally {
                        CursorUtil.setCursorFree(JDistinguishedName.this);
                    }
                }
            });
        } else {
            this.jbViewEditDistinguishedName.setToolTipText(res.getString("JDistinguishedName.jbViewEditDistinguishedName.View.tooltip"));
            this.jbViewEditDistinguishedName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        CursorUtil.setCursorBusy(JDistinguishedName.this);
                        JDistinguishedName.this.displayDistinguishedName();
                    }
                    finally {
                        CursorUtil.setCursorFree(JDistinguishedName.this);
                    }
                }
            });
        }
        GridBagConstraints gbcJbViewEditDistinguishedName = new GridBagConstraints();
        gbcJbViewEditDistinguishedName.gridwidth = 1;
        gbcJbViewEditDistinguishedName.gridheight = 1;
        gbcJbViewEditDistinguishedName.gridx = 1;
        gbcJbViewEditDistinguishedName.gridy = 0;
        gbcJbViewEditDistinguishedName.insets = this.editable ? new Insets(0, 0, 0, 5) : new Insets(0, 0, 0, 0);
        ImageIcon clearIcon = new ImageIcon(this.getClass().getResource("images/clear_dn.png"));
        this.jbClearDistinguishedName = new JButton(clearIcon);
        this.jbClearDistinguishedName.setToolTipText(res.getString("JDistinguishedName.jbClearDistinguishedName.tooltip"));
        this.jbClearDistinguishedName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JDistinguishedName.this);
                    JDistinguishedName.this.clearDistinguishedName();
                }
                finally {
                    CursorUtil.setCursorFree(JDistinguishedName.this);
                }
            }
        });
        GridBagConstraints gbcJbClearDistinguishedName = new GridBagConstraints();
        gbcJbClearDistinguishedName.gridwidth = 1;
        gbcJbClearDistinguishedName.gridheight = 1;
        gbcJbClearDistinguishedName.gridx = 2;
        gbcJbClearDistinguishedName.gridy = 0;
        gbcJbClearDistinguishedName.insets = new Insets(0, 0, 0, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jtfDistinguishedName, gbcJtfDistinguishedName);
        this.add((Component)this.jbViewEditDistinguishedName, gbcJbViewEditDistinguishedName);
        if (this.editable) {
            this.add((Component)this.jbClearDistinguishedName, gbcJbClearDistinguishedName);
        }
        this.populate();
    }

    public void setDistinguishedName(X500Name distinguishedName) {
        this.distinguishedName = distinguishedName == null ? new X500Name((X500NameStyle)KseX500NameStyle.INSTANCE, new RDN[0]) : new X500Name((X500NameStyle)KseX500NameStyle.INSTANCE, distinguishedName.getRDNs());
        this.populate();
    }

    public X500Name getDistinguishedName() {
        return this.distinguishedName;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.jbViewEditDistinguishedName.setEnabled(enabled);
        this.jbClearDistinguishedName.setEnabled(enabled);
    }

    @Override
    public void setToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
        this.jtfDistinguishedName.setToolTipText(toolTipText);
    }

    private void populate() {
        if (this.distinguishedName != null) {
            this.jtfDistinguishedName.setText(this.distinguishedName.toString());
            if (this.editable) {
                this.jbClearDistinguishedName.setEnabled(true);
            }
        } else {
            this.jtfDistinguishedName.setText("");
            if (this.editable) {
                this.jbClearDistinguishedName.setEnabled(false);
            }
        }
        this.jtfDistinguishedName.setCaretPosition(0);
    }

    private void displayDistinguishedName() {
        Container container = this.getTopLevelAncestor();
        if (container instanceof JDialog) {
            DDistinguishedNameChooser dDistinguishedNameChooser = new DDistinguishedNameChooser((JDialog)container, this.title, this.distinguishedName, false);
            dDistinguishedNameChooser.setLocationRelativeTo(container);
            dDistinguishedNameChooser.setVisible(true);
        } else if (container instanceof JFrame) {
            DDistinguishedNameChooser dDistinguishedNameChooser = new DDistinguishedNameChooser((JFrame)container, this.title, this.distinguishedName, false);
            dDistinguishedNameChooser.setLocationRelativeTo(container);
            dDistinguishedNameChooser.setVisible(true);
        }
    }

    private void editDistinguishedName() {
        Container container = this.getTopLevelAncestor();
        DDistinguishedNameChooser dDistinguishedNameChooser = null;
        dDistinguishedNameChooser = container instanceof JDialog ? new DDistinguishedNameChooser((JDialog)container, this.title, this.distinguishedName, true) : new DDistinguishedNameChooser((JFrame)container, this.title, this.distinguishedName, true);
        dDistinguishedNameChooser.setLocationRelativeTo(container);
        dDistinguishedNameChooser.setVisible(true);
        X500Name newDistinguishedName = dDistinguishedNameChooser.getDistinguishedName();
        if (newDistinguishedName == null) {
            return;
        }
        this.setDistinguishedName(newDistinguishedName);
    }

    private void clearDistinguishedName() {
        this.setDistinguishedName(null);
    }
}

