/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.accessdescription;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.kse.crypto.x509.GeneralNameUtil;
import org.kse.utilities.oid.ObjectIdComparator;

public class AccessDescriptionsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/accessdescription/resources");
    private static ObjectIdComparator objectIdComparator = new ObjectIdComparator();
    private String[] columnNames = new String[2];
    private Object[][] data;

    public AccessDescriptionsTableModel() {
        this.columnNames[0] = res.getString("AccessDescriptionsTableModel.AccessMethodColumn");
        this.columnNames[1] = res.getString("AccessDescriptionsTableModel.AccessLocationColumn");
        this.data = new Object[0][0];
    }

    public void load(List<AccessDescription> accessDescriptions) {
        AccessDescription[] accessDescriptionsArray = accessDescriptions.toArray(new AccessDescription[accessDescriptions.size()]);
        Arrays.sort(accessDescriptionsArray, new AccessDescriptionMethodComparator());
        this.data = new Object[accessDescriptionsArray.length][2];
        int i = 0;
        for (AccessDescription accessDescription : accessDescriptionsArray) {
            this.data[i][0] = accessDescription;
            this.data[i][1] = accessDescription;
            ++i;
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return AccessDescription.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    static class AccessDescriptionLocationComparator
    implements Comparator<AccessDescription> {
        AccessDescriptionLocationComparator() {
        }

        @Override
        public int compare(AccessDescription description1, AccessDescription description2) {
            return GeneralNameUtil.safeToString(description1.getAccessLocation(), false).compareToIgnoreCase(GeneralNameUtil.safeToString(description2.getAccessLocation(), false));
        }
    }

    static class AccessDescriptionMethodComparator
    implements Comparator<AccessDescription> {
        AccessDescriptionMethodComparator() {
        }

        @Override
        public int compare(AccessDescription description1, AccessDescription description2) {
            return objectIdComparator.compare(description1.getAccessMethod(), description2.getAccessMethod());
        }
    }
}

