/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.generalname;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.util.IPAddress;
import org.kse.crypto.x509.GeneralNameUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.JDistinguishedName;
import org.kse.gui.error.DError;
import org.kse.gui.oid.JObjectId;
import org.kse.utilities.DialogViewer;

public class DGeneralNameChooser
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/generalname/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JLabel jlGeneralNameType;
    private JRadioButton jrbDirectoryName;
    private JRadioButton jrbDnsName;
    private JRadioButton jrbIpAddress;
    private JRadioButton jrbRegisteredId;
    private JRadioButton jrbRfc822Name;
    private JRadioButton jrbUniformResourceIdentifier;
    private JRadioButton jrbPrincipalName;
    private JPanel jpGeneralNameValue;
    private JLabel jlGeneralNameValue;
    private JDistinguishedName jdnDirectoryName;
    private JTextField jtfDnsName;
    private JTextField jtfIpAddress;
    private JObjectId joiRegisteredId;
    private JTextField jtfRfc822Name;
    private JTextField jtfUniformResourceIdentifier;
    private JTextField jtfPrincipalName;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private GeneralName generalName;

    public DGeneralNameChooser(JFrame parent, String title, GeneralName generalName) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(generalName);
    }

    public DGeneralNameChooser(JDialog parent, String title, GeneralName generalName) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(generalName);
    }

    private void initComponents(GeneralName generalName) {
        this.jrbDirectoryName = new JRadioButton(res.getString("DGeneralNameChooser.jrbDirectoryName.text"));
        this.jrbDirectoryName.setToolTipText(res.getString("DGeneralNameChooser.jrbDirectoryName.tooltip"));
        this.jrbDnsName = new JRadioButton(res.getString("DGeneralNameChooser.jrbDnsName.text"));
        this.jrbDnsName.setToolTipText(res.getString("DGeneralNameChooser.jrbDnsName.tooltip"));
        this.jrbIpAddress = new JRadioButton(res.getString("DGeneralNameChooser.jrbIpAddress.text"));
        this.jrbIpAddress.setToolTipText(res.getString("DGeneralNameChooser.jrbIpAddress.tooltip"));
        this.jrbRegisteredId = new JRadioButton(res.getString("DGeneralNameChooser.jrbRegisteredId.text"));
        this.jrbRegisteredId.setToolTipText(res.getString("DGeneralNameChooser.jrbRegisteredId.tooltip"));
        this.jrbRfc822Name = new JRadioButton(res.getString("DGeneralNameChooser.jrbRfc822Name.text"));
        this.jrbRfc822Name.setToolTipText(res.getString("DGeneralNameChooser.jrbRfc822Name.tooltip"));
        this.jrbUniformResourceIdentifier = new JRadioButton(res.getString("DGeneralNameChooser.jrbUniformResourceIdentifier.text"));
        this.jrbUniformResourceIdentifier.setToolTipText(res.getString("DGeneralNameChooser.jrbUniformResourceIdentifier.tooltip"));
        this.jrbPrincipalName = new JRadioButton(res.getString("DGeneralNameChooser.jrbPrincipalName.text"));
        this.jrbPrincipalName.setToolTipText(res.getString("DGeneralNameChooser.jrbPrincipalName.tooltip"));
        ButtonGroup bgGeneralName = new ButtonGroup();
        bgGeneralName.add(this.jrbDirectoryName);
        bgGeneralName.add(this.jrbDnsName);
        bgGeneralName.add(this.jrbIpAddress);
        bgGeneralName.add(this.jrbRegisteredId);
        bgGeneralName.add(this.jrbRfc822Name);
        bgGeneralName.add(this.jrbUniformResourceIdentifier);
        bgGeneralName.add(this.jrbPrincipalName);
        this.jlGeneralNameType = new JLabel(res.getString("DGeneralNameChooser.jlGeneralNameType.text"));
        this.jlGeneralNameValue = new JLabel(res.getString("DGeneralNameChooser.jlGeneralNameValue.text"));
        this.jpGeneralNameValue = new JPanel(new FlowLayout(0));
        this.jdnDirectoryName = new JDistinguishedName(res.getString("DGeneralNameChooser.DirectoryName.Title"), 20, true);
        this.jtfDnsName = new JTextField(30);
        this.jtfIpAddress = new JTextField(30);
        this.joiRegisteredId = new JObjectId(res.getString("DGeneralNameChooser.RegisteredId.Title"));
        this.jtfRfc822Name = new JTextField(30);
        this.jtfUniformResourceIdentifier = new JTextField(30);
        this.jtfPrincipalName = new JTextField(30);
        this.jbOK = new JButton(res.getString("DGeneralNameChooser.jbOK.text"));
        this.jbCancel = new JButton(res.getString("DGeneralNameChooser.jbCancel.text"));
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        Container pane = this.getContentPane();
        pane.setLayout((LayoutManager)new MigLayout("insets dialog, fill", "[]rel[]", ""));
        pane.add((Component)this.jlGeneralNameType, "spanx, wrap");
        pane.add((Component)this.jrbDirectoryName, "");
        pane.add((Component)this.jrbDnsName, "");
        pane.add((Component)this.jrbIpAddress, "");
        pane.add((Component)this.jrbRegisteredId, "wrap");
        pane.add((Component)this.jrbRfc822Name, "");
        pane.add((Component)this.jrbUniformResourceIdentifier, "");
        pane.add((Component)this.jrbPrincipalName, "wrap");
        pane.add((Component)this.jlGeneralNameValue, "spanx");
        pane.add((Component)this.jpGeneralNameValue, "spanx, wrap");
        pane.add((Component)new JSeparator(), "spanx, growx, wrap");
        pane.add((Component)this.jpButtons, "right, spanx");
        this.jrbDirectoryName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DGeneralNameChooser.this.generalNameTypeChanged();
            }
        });
        this.jrbDnsName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DGeneralNameChooser.this.generalNameTypeChanged();
            }
        });
        this.jrbRegisteredId.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DGeneralNameChooser.this.generalNameTypeChanged();
            }
        });
        this.jrbIpAddress.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DGeneralNameChooser.this.generalNameTypeChanged();
            }
        });
        this.jrbRfc822Name.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DGeneralNameChooser.this.generalNameTypeChanged();
            }
        });
        this.jrbUniformResourceIdentifier.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DGeneralNameChooser.this.generalNameTypeChanged();
            }
        });
        this.jrbPrincipalName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DGeneralNameChooser.this.generalNameTypeChanged();
            }
        });
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGeneralNameChooser.this.okPressed();
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGeneralNameChooser.this.cancelPressed();
            }
        });
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGeneralNameChooser.this.cancelPressed();
            }
        });
        this.populate(generalName);
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void generalNameTypeChanged() {
        this.jpGeneralNameValue.removeAll();
        this.jpGeneralNameValue.add(this.jlGeneralNameValue);
        if (this.jrbDirectoryName.isSelected()) {
            this.jpGeneralNameValue.add(this.jdnDirectoryName);
        } else if (this.jrbDnsName.isSelected()) {
            this.jpGeneralNameValue.add(this.jtfDnsName);
        } else if (this.jrbIpAddress.isSelected()) {
            this.jpGeneralNameValue.add(this.jtfIpAddress);
        } else if (this.jrbRegisteredId.isSelected()) {
            this.jpGeneralNameValue.add(this.joiRegisteredId);
        } else if (this.jrbRfc822Name.isSelected()) {
            this.jpGeneralNameValue.add(this.jtfRfc822Name);
        } else if (this.jrbUniformResourceIdentifier.isSelected()) {
            this.jpGeneralNameValue.add(this.jtfUniformResourceIdentifier);
        } else if (this.jrbPrincipalName.isSelected()) {
            this.jpGeneralNameValue.add(this.jtfPrincipalName);
        }
        this.pack();
    }

    private void populate(GeneralName generalName) {
        if (generalName == null) {
            this.jrbDirectoryName.setSelected(true);
        } else {
            switch (generalName.getTagNo()) {
                case 4: {
                    this.jrbDirectoryName.setSelected(true);
                    this.jdnDirectoryName.setDistinguishedName((X500Name)generalName.getName());
                    break;
                }
                case 2: {
                    this.jrbDnsName.setSelected(true);
                    this.jtfDnsName.setText(((DERIA5String)generalName.getName()).getString());
                    break;
                }
                case 7: {
                    this.jrbIpAddress.setSelected(true);
                    byte[] ipAddressBytes = ((ASN1OctetString)generalName.getName()).getOctets();
                    try {
                        this.jtfIpAddress.setText(InetAddress.getByAddress(ipAddressBytes).getHostAddress());
                    }
                    catch (UnknownHostException unknownHostException) {}
                    break;
                }
                case 8: {
                    this.jrbRegisteredId.setSelected(true);
                    this.joiRegisteredId.setObjectId((ASN1ObjectIdentifier)generalName.getName());
                    break;
                }
                case 1: {
                    this.jrbRfc822Name.setSelected(true);
                    this.jtfRfc822Name.setText(((DERIA5String)generalName.getName()).getString());
                    break;
                }
                case 6: {
                    this.jrbUniformResourceIdentifier.setSelected(true);
                    this.jtfUniformResourceIdentifier.setText(((DERIA5String)generalName.getName()).getString());
                    break;
                }
                case 0: {
                    this.jrbPrincipalName.setSelected(true);
                    this.jtfPrincipalName.setText(GeneralNameUtil.parseUPN(generalName));
                }
            }
        }
    }

    public GeneralName getGeneralName() {
        return this.generalName;
    }

    private void okPressed() {
        try {
            GeneralName newGeneralName = null;
            if (this.jrbDirectoryName.isSelected()) {
                X500Name directoryName = this.jdnDirectoryName.getDistinguishedName();
                if (directoryName == null) {
                    JOptionPane.showMessageDialog(this, res.getString("DGeneralNameChooser.DirectoryNameValueReq.message"), this.getTitle(), 2);
                    return;
                }
                newGeneralName = new GeneralName(4, (ASN1Encodable)directoryName);
            } else if (this.jrbDnsName.isSelected()) {
                String dnsName = this.jtfDnsName.getText().trim();
                if (dnsName.length() == 0) {
                    JOptionPane.showMessageDialog(this, res.getString("DGeneralNameChooser.DnsNameValueReq.message"), this.getTitle(), 2);
                    return;
                }
                newGeneralName = new GeneralName(2, (ASN1Encodable)new DERIA5String(dnsName));
            } else if (this.jrbIpAddress.isSelected()) {
                String ipAddress = this.jtfIpAddress.getText().trim();
                if (ipAddress.length() == 0) {
                    JOptionPane.showMessageDialog(this, res.getString("DGeneralNameChooser.IpAddressValueReq.message"), this.getTitle(), 2);
                    return;
                }
                if (!IPAddress.isValid((String)ipAddress)) {
                    JOptionPane.showMessageDialog(this, res.getString("DGeneralNameChooser.NotAValidIP.message"), this.getTitle(), 2);
                    return;
                }
                newGeneralName = new GeneralName(7, ipAddress);
            } else if (this.jrbRegisteredId.isSelected()) {
                ASN1ObjectIdentifier registeredId = this.joiRegisteredId.getObjectId();
                if (registeredId == null) {
                    JOptionPane.showMessageDialog(this, res.getString("DGeneralNameChooser.RegisteredIdValueReq.message"), this.getTitle(), 2);
                    return;
                }
                newGeneralName = new GeneralName(8, (ASN1Encodable)registeredId);
            } else if (this.jrbRfc822Name.isSelected()) {
                String rfc822Name = this.jtfRfc822Name.getText().trim();
                if (rfc822Name.length() == 0) {
                    JOptionPane.showMessageDialog(this, res.getString("DGeneralNameChooser.Rfc822NameValueReq.message"), this.getTitle(), 2);
                    return;
                }
                newGeneralName = new GeneralName(1, (ASN1Encodable)new DERIA5String(rfc822Name));
            } else if (this.jrbUniformResourceIdentifier.isSelected()) {
                String uniformResourceIdentifier = this.jtfUniformResourceIdentifier.getText().trim();
                if (uniformResourceIdentifier.length() == 0) {
                    JOptionPane.showMessageDialog(this, res.getString("DGeneralNameChooser.UniformResourceIdentifierValueReq.message"), this.getTitle(), 2);
                    return;
                }
                newGeneralName = new GeneralName(6, (ASN1Encodable)new DERIA5String(uniformResourceIdentifier));
            } else if (this.jrbPrincipalName.isSelected()) {
                String upnString = this.jtfPrincipalName.getText().trim();
                if (upnString.length() == 0) {
                    JOptionPane.showMessageDialog(this, res.getString("DGeneralNameChooser.PrincipalNameValueReq.message"), this.getTitle(), 2);
                    return;
                }
                ASN1EncodableVector asn1Vector = new ASN1EncodableVector();
                asn1Vector.add((ASN1Encodable)new ASN1ObjectIdentifier("1.3.6.1.4.1.311.20.2.3"));
                asn1Vector.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERUTF8String(upnString)));
                newGeneralName = new GeneralName(0, (ASN1Encodable)new DERSequence(asn1Vector));
            }
            this.generalName = newGeneralName;
        }
        catch (Exception e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        DialogViewer.run(new DGeneralNameChooser(new JFrame(), "GeneralNameChooser", null));
    }
}

