/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.generalsubtree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.generalname.JGeneralName;

public class DGeneralSubtreeChooser
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/generalsubtree/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpGeneralSubtree;
    private JLabel jlBase;
    private JGeneralName jgnBase;
    private JLabel jlMinimum;
    private JTextField jtfMinimum;
    private JLabel jlMaximum;
    private JTextField jtfMaximum;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private GeneralSubtree generalSubtree;

    public DGeneralSubtreeChooser(JFrame parent, String title, GeneralSubtree generalSubtree) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(generalSubtree);
    }

    public DGeneralSubtreeChooser(JDialog parent, String title, GeneralSubtree generalSubtree) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(generalSubtree);
    }

    private void initComponents(GeneralSubtree generalSubtree) {
        this.jlBase = new JLabel(res.getString("DGeneralSubtreeChooser.jlBase.text"));
        GridBagConstraints gbc_jlBase = new GridBagConstraints();
        gbc_jlBase.gridx = 0;
        gbc_jlBase.gridy = 0;
        gbc_jlBase.gridwidth = 1;
        gbc_jlBase.gridheight = 1;
        gbc_jlBase.insets = new Insets(5, 5, 0, 5);
        gbc_jlBase.anchor = 13;
        this.jgnBase = new JGeneralName(res.getString("DGeneralSubtreeChooser.Base.Title"));
        this.jgnBase.setToolTipText(res.getString("DGeneralSubtreeChooser.jgnBase.tooltip"));
        GridBagConstraints gbc_jgnBase = new GridBagConstraints();
        gbc_jgnBase.gridx = 1;
        gbc_jgnBase.gridy = 0;
        gbc_jgnBase.gridwidth = 1;
        gbc_jgnBase.gridheight = 1;
        gbc_jgnBase.insets = new Insets(5, 5, 0, 5);
        gbc_jgnBase.anchor = 17;
        this.jlMinimum = new JLabel(res.getString("DGeneralSubtreeChooser.jlMinimum.text"));
        GridBagConstraints gbc_jlMinimum = new GridBagConstraints();
        gbc_jlMinimum.gridx = 0;
        gbc_jlMinimum.gridy = 1;
        gbc_jlMinimum.gridwidth = 1;
        gbc_jlMinimum.gridheight = 1;
        gbc_jlMinimum.insets = new Insets(5, 5, 5, 5);
        gbc_jlMinimum.anchor = 13;
        this.jtfMinimum = new JTextField(3);
        this.jtfMinimum.setToolTipText(res.getString("DGeneralSubtreeChooser.jtfMinimum.tooltip"));
        GridBagConstraints gbc_jtfMinimum = new GridBagConstraints();
        gbc_jtfMinimum.gridx = 1;
        gbc_jtfMinimum.gridy = 1;
        gbc_jtfMinimum.gridwidth = 1;
        gbc_jtfMinimum.gridheight = 1;
        gbc_jtfMinimum.insets = new Insets(5, 5, 5, 5);
        gbc_jtfMinimum.anchor = 17;
        this.jlMaximum = new JLabel(res.getString("DGeneralSubtreeChooser.jlMaximum.text"));
        GridBagConstraints gbc_jlMaximum = new GridBagConstraints();
        gbc_jlMaximum.gridx = 0;
        gbc_jlMaximum.gridy = 2;
        gbc_jlMaximum.gridwidth = 1;
        gbc_jlMaximum.gridheight = 1;
        gbc_jlMaximum.insets = new Insets(5, 5, 5, 5);
        gbc_jlMaximum.anchor = 13;
        this.jtfMaximum = new JTextField(3);
        this.jtfMaximum.setToolTipText(res.getString("DGeneralSubtreeChooser.jtfMaximum.tooltip"));
        GridBagConstraints gbc_jtfMaximum = new GridBagConstraints();
        gbc_jtfMaximum.gridx = 1;
        gbc_jtfMaximum.gridy = 2;
        gbc_jtfMaximum.gridwidth = 1;
        gbc_jtfMaximum.gridheight = 1;
        gbc_jtfMaximum.insets = new Insets(5, 5, 5, 5);
        gbc_jtfMaximum.anchor = 17;
        this.jpGeneralSubtree = new JPanel(new GridBagLayout());
        this.jpGeneralSubtree.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpGeneralSubtree.add((Component)this.jlBase, gbc_jlBase);
        this.jpGeneralSubtree.add((Component)this.jgnBase, gbc_jgnBase);
        this.jpGeneralSubtree.add((Component)this.jlMinimum, gbc_jlMinimum);
        this.jpGeneralSubtree.add((Component)this.jtfMinimum, gbc_jtfMinimum);
        this.jpGeneralSubtree.add((Component)this.jlMaximum, gbc_jlMaximum);
        this.jpGeneralSubtree.add((Component)this.jtfMaximum, gbc_jtfMaximum);
        this.jbOK = new JButton(res.getString("DGeneralSubtreeChooser.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGeneralSubtreeChooser.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DGeneralSubtreeChooser.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGeneralSubtreeChooser.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DGeneralSubtreeChooser.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.jpGeneralSubtree);
        this.getContentPane().add("South", this.jpButtons);
        this.populate(generalSubtree);
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void populate(GeneralSubtree generalSubtree) {
        if (generalSubtree != null) {
            this.jgnBase.setGeneralName(generalSubtree.getBase());
            if (generalSubtree.getMinimum() != null) {
                this.jtfMinimum.setText("" + generalSubtree.getMinimum().intValue());
                this.jtfMinimum.setCaretPosition(0);
            }
            if (generalSubtree.getMaximum() != null) {
                this.jtfMaximum.setText("" + generalSubtree.getMaximum().intValue());
                this.jtfMaximum.setCaretPosition(0);
            }
        }
    }

    public GeneralSubtree getGeneralSubtree() {
        return this.generalSubtree;
    }

    private void okPressed() {
        GeneralName base = this.jgnBase.getGeneralName();
        if (base == null) {
            JOptionPane.showMessageDialog(this, res.getString("DGeneralSubtreeChooser.BaseValueReq.message"), this.getTitle(), 2);
            return;
        }
        int minimum = -1;
        String minimumStr = this.jtfMinimum.getText().trim();
        if (minimumStr.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DGeneralSubtreeChooser.MinimumValueReq.message"), this.getTitle(), 2);
            return;
        }
        if (minimumStr.length() > 0) {
            try {
                minimum = Integer.parseInt(minimumStr);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, res.getString("DGeneralSubtreeChooser.InvalidMinimumValue.message"), this.getTitle(), 2);
                return;
            }
            if (minimum < 0) {
                JOptionPane.showMessageDialog(this, res.getString("DGeneralSubtreeChooser.InvalidMinimumValue.message"), this.getTitle(), 2);
                return;
            }
        }
        int maximum = -1;
        String maximumStr = this.jtfMaximum.getText().trim();
        if (maximumStr.length() > 0) {
            try {
                maximum = Integer.parseInt(maximumStr);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, res.getString("DGeneralSubtreeChooser.InvalidMaximumValue.message"), this.getTitle(), 2);
                return;
            }
            if (maximum < 0) {
                JOptionPane.showMessageDialog(this, res.getString("DGeneralSubtreeChooser.InvalidMaximumValue.message"), this.getTitle(), 2);
                return;
            }
        }
        BigInteger asn1Minimum = minimum != -1 ? BigInteger.valueOf(minimum) : null;
        BigInteger asn1Maximum = maximum != -1 ? BigInteger.valueOf(maximum) : null;
        this.generalSubtree = new GeneralSubtree(base, asn1Minimum, asn1Maximum);
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

